/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeUtils {
    public static final String FUNCTION_TYPE_PREFIX = "@fn:";
    public static final String METHOD_TYPE_PREFIX = "@mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "@static.mtd:";

    private CodeUtils() {
    }

    public static String extractClassName(ClassName className) {
        Expression expression = className.getName();
        assert (expression instanceof Identifier) : "unsupported type of ClassName.getClassName().getName(): " + expression.getClass().getName();
        return expression instanceof Identifier ? ((Identifier)expression).getName() : "";
    }

    public static String extractClassName(ClassDeclaration classDeclaration) {
        return classDeclaration.getName().getName();
    }

    public static String extractSuperClassName(ClassDeclaration classDeclaration) {
        Identifier identifier = classDeclaration.getSuperClass();
        return identifier != null ? identifier.getName() : null;
    }

    @CheckForNull
    public static String extractVariableName(Variable variable) {
        if (variable.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)variable.getName();
            StringBuilder stringBuilder = new StringBuilder();
            if (variable.isDollared()) {
                stringBuilder.append("$");
            }
            stringBuilder.append(identifier.getName());
            return stringBuilder.toString();
        }
        if (variable.getName() instanceof Variable) {
            Variable variable2 = (Variable)variable.getName();
            return CodeUtils.extractVariableName(variable2);
        }
        return null;
    }

    public static boolean isVariableTypeResolved(IndexedConstant indexedConstant) {
        return indexedConstant.getTypeName() == null || !indexedConstant.getTypeName().startsWith("@");
    }

    private static String findClassNameEnclosingDeclaration(PHPParseResult pHPParseResult, IndexedConstant indexedConstant) {
        if (pHPParseResult.getFile().getFileObject().equals(indexedConstant.getFileObject())) {
            return CodeUtils.findClassNameEnclosingDeclaration(pHPParseResult.getProgram(), indexedConstant);
        }
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(indexedConstant.getFileObject());
        ClassNameExtractor classNameExtractor = new ClassNameExtractor(indexedConstant);
        try {
            sourceModel.runUserActionTask((CancellableTask)classNameExtractor, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return classNameExtractor.className;
    }

    private static String findClassNameEnclosingDeclaration(Program program, IndexedConstant indexedConstant) {
        ASTNode aSTNode = Utils.getNodeAtOffset(program, indexedConstant.getOffset(), ClassDeclaration.class);
        if (aSTNode instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration = (ClassDeclaration)aSTNode;
            return classDeclaration.getName().getName();
        }
        return null;
    }

    public static void resolveFunctionType(PHPParseResult pHPParseResult, PHPIndex pHPIndex, Map<String, IndexedConstant> map, IndexedConstant indexedConstant) {
        String string = indexedConstant.getTypeName();
        if (!CodeUtils.isVariableTypeResolved(indexedConstant)) {
            String string2 = null;
            boolean bl = true;
            if (string.startsWith(FUNCTION_TYPE_PREFIX)) {
                String string3 = string.substring(FUNCTION_TYPE_PREFIX.length());
                for (IndexedFunction indexedFunction : pHPIndex.getFunctions(pHPParseResult, string3, NameKind.EXACT_NAME)) {
                    string2 = indexedFunction.getReturnType();
                }
            } else if (string.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                String[] stringArray = string.substring(STATIC_METHOD_TYPE_PREFIX.length()).split("\\.");
                String string4 = stringArray[0];
                if ("self".equals(string4) || "parent".equals(string4)) {
                    string4 = CodeUtils.findClassNameEnclosingDeclaration(pHPParseResult, indexedConstant);
                }
                String string5 = stringArray[1];
                for (IndexedFunction indexedFunction : pHPIndex.getAllMethods(pHPParseResult, string4, string5, NameKind.EXACT_NAME, Integer.MAX_VALUE)) {
                    string2 = indexedFunction.getReturnType();
                }
            } else if (string.startsWith(METHOD_TYPE_PREFIX)) {
                String[] stringArray = string.substring(METHOD_TYPE_PREFIX.length()).split("\\.");
                String string6 = stringArray[0];
                String string7 = stringArray[1];
                String string8 = null;
                if ("$this".equals(string6)) {
                    string8 = CodeUtils.findClassNameEnclosingDeclaration(pHPParseResult, indexedConstant);
                } else {
                    IndexedConstant indexedConstant2 = map.get(string6);
                    if (indexedConstant2 != null && indexedConstant2 != indexedConstant) {
                        CodeUtils.resolveFunctionType(pHPParseResult, pHPIndex, map, indexedConstant2);
                        string8 = indexedConstant2.getTypeName();
                    }
                }
                if (string8 != null) {
                    for (IndexedFunction indexedFunction : pHPIndex.getAllMethods(pHPParseResult, string8, string7, NameKind.EXACT_NAME, Integer.MAX_VALUE)) {
                        string2 = indexedFunction.getReturnType();
                    }
                }
            } else {
                bl = false;
            }
            if (bl) {
                indexedConstant.setTypeName(string2);
            }
        }
    }

    public static String extractVariableTypeFromAssignment(Assignment assignment) {
        Expression expression;
        Expression expression2 = assignment.getRightHandSide();
        if (expression2 instanceof Assignment) {
            return CodeUtils.extractVariableTypeFromAssignment((Assignment)assignment.getRightHandSide());
        }
        if (expression2 instanceof Reference) {
            expression = (Reference)expression2;
            expression2 = ((Reference)expression).getExpression();
        }
        if (expression2 instanceof ClassInstanceCreation) {
            expression = (ClassInstanceCreation)expression2;
            Expression expression3 = ((ClassInstanceCreation)expression).getClassName().getName();
            if (expression3 instanceof Identifier) {
                Identifier identifier = (Identifier)expression3;
                return identifier.getName();
            }
        } else {
            if (expression2 instanceof ArrayCreation) {
                return "array";
            }
            if (expression2 instanceof FunctionInvocation) {
                expression = (FunctionInvocation)expression2;
                String string = CodeUtils.extractFunctionName((FunctionInvocation)expression);
                return FUNCTION_TYPE_PREFIX + string;
            }
            if (expression2 instanceof StaticMethodInvocation) {
                expression = (StaticMethodInvocation)expression2;
                String string = ((StaticDispatch)expression).getClassName().getName();
                String string2 = CodeUtils.extractFunctionName(((StaticMethodInvocation)expression).getMethod());
                if (string != null && string2 != null) {
                    return STATIC_METHOD_TYPE_PREFIX + string + '.' + string2;
                }
            } else if (expression2 instanceof MethodInvocation) {
                Object object;
                expression = (MethodInvocation)expression2;
                String string = null;
                if (((Dispatch)expression).getDispatcher() instanceof Variable) {
                    object = (Variable)((Dispatch)expression).getDispatcher();
                    string = CodeUtils.extractVariableName((Variable)object);
                }
                object = CodeUtils.extractFunctionName(((MethodInvocation)expression).getMethod());
                if (string != null && object != null) {
                    return METHOD_TYPE_PREFIX + string + '.' + (String)object;
                }
            }
        }
        return null;
    }

    public static String extractFunctionName(FunctionInvocation functionInvocation) {
        return CodeUtils.extractFunctionName(functionInvocation.getFunctionName());
    }

    public static String extractFunctionName(FunctionDeclaration functionDeclaration) {
        return functionDeclaration.getFunctionName().getName();
    }

    public static String extractMethodName(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getFunction().getFunctionName().getName();
    }

    public static String extractFunctionName(FunctionName functionName) {
        if (functionName.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)functionName.getName();
            return identifier.getName();
        }
        if (functionName.getName() instanceof Variable) {
            Variable variable = (Variable)functionName.getName();
            return CodeUtils.extractVariableName(variable);
        }
        return null;
    }

    public static String getParamDisplayName(FormalParameter formalParameter) {
        Expression expression = formalParameter.getParameterName();
        StringBuilder stringBuilder = new StringBuilder();
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            Identifier identifier = (Identifier)variable.getName();
            if (variable.isDollared()) {
                stringBuilder.append("$");
            }
            stringBuilder.append(identifier.getName());
        } else if (expression instanceof Reference) {
            stringBuilder.append("&");
            Reference reference = (Reference)expression;
            if (reference.getExpression() instanceof Variable) {
                Variable variable = (Variable)reference.getExpression();
                if (variable.isDollared()) {
                    stringBuilder.append("$");
                }
                Identifier identifier = (Identifier)variable.getName();
                stringBuilder.append(identifier.getName());
            }
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassNameExtractor
    implements CancellableTask<CompilationInfo> {
        IndexedConstant variable;
        String className;

        public ClassNameExtractor(IndexedConstant indexedConstant) {
            this.variable = indexedConstant;
        }

        public void cancel() {
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            Program program = Utils.getRoot(compilationInfo);
            this.className = CodeUtils.findClassNameEnclosingDeclaration(program, this.variable);
        }
    }
}

