/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.nav.SemiAttribute;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

public class DeclarationFinderImpl
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(CompilationInfo compilationInfo, int n) {
        return DeclarationFinderImpl.findDeclarationImpl(compilationInfo, n);
    }

    public OffsetRange getReferenceSpan(Document document, final int n) {
        OffsetRange[] offsetRangeArray;
        LinkedList linkedList = TokenHierarchy.get((Document)document).embeddedTokenSequences(n, false);
        linkedList = new LinkedList(linkedList);
        Collections.reverse(linkedList);
        for (TokenSequence tokenSequence : linkedList) {
            if (tokenSequence.language() != PHPTokenId.language() || (offsetRangeArray = tokenSequence.token()).id() != PHPTokenId.PHP_VARIABLE && offsetRangeArray.id() != PHPTokenId.PHP_STRING) continue;
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + offsetRangeArray.length());
        }
        FileObject fileObject = NavUtils.getFile(document);
        if (fileObject != null) {
            TokenSequence tokenSequence;
            tokenSequence = SourceModelFactory.getInstance().getModel(fileObject);
            offsetRangeArray = new OffsetRange[1];
            try {
                tokenSequence.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                    public void cancel() {
                    }

                    public void run(CompilationInfo compilationInfo) throws Exception {
                        List<ASTNode> list = NavUtils.underCaret(compilationInfo, n);
                        if (list.size() == 0) {
                            return;
                        }
                        list = new LinkedList<ASTNode>(list);
                        Collections.reverse(list);
                        Scalar scalar = null;
                        for (ASTNode aSTNode : list) {
                            if (aSTNode instanceof Include) {
                                FileObject fileObject = NavUtils.resolveInclude(compilationInfo, (Include)aSTNode);
                                if (fileObject == null || scalar == null) continue;
                                offsetRangeArray[0] = new OffsetRange(scalar.getStartOffset() + 1, scalar.getEndOffset() - 1);
                                break;
                            }
                            if (!(aSTNode instanceof Scalar)) continue;
                            scalar = (Scalar)aSTNode;
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (offsetRangeArray[0] != null) {
                return offsetRangeArray[0];
            }
        }
        return OffsetRange.NONE;
    }

    static DeclarationFinder.DeclarationLocation findDeclarationImpl(CompilationInfo compilationInfo, int n) {
        SemiAttribute semiAttribute;
        List<ASTNode> list = NavUtils.underCaret(compilationInfo, n);
        SemiAttribute.AttributedElement attributedElement = NavUtils.findElement(compilationInfo, list, n, semiAttribute = SemiAttribute.semiAttribute(compilationInfo));
        if (attributedElement != null) {
            return DeclarationFinderImpl.create(compilationInfo, attributedElement);
        }
        if (list.size() == 0) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        list = new LinkedList<ASTNode>(list);
        Collections.reverse(list);
        for (ASTNode aSTNode : list) {
            if (!(aSTNode instanceof Include)) continue;
            FileObject fileObject = NavUtils.resolveInclude(compilationInfo, (Include)aSTNode);
            if (fileObject == null) break;
            return new DeclarationFinder.DeclarationLocation(fileObject, 0);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    static DeclarationFinder.DeclarationLocation create(CompilationInfo compilationInfo, SemiAttribute.AttributedElement attributedElement) {
        Object object;
        Union2<ASTNode, IndexedElement> union2;
        List<Union2<ASTNode, IndexedElement>> list = attributedElement.getWrites();
        switch (attributedElement.getKind()) {
            case FUNC: 
            case CLASS: {
                union2 = list.get(0);
                break;
            }
            case VARIABLE: {
                int n = -1;
                union2 = list.get(0);
                for (Object object2 : list) {
                    if (!object2.hasFirst() || (object = (ASTNode)object2.first()) == null || ((ASTNode)object).getStartOffset() >= n && n != -1) continue;
                    union2 = object2;
                    n = ((ASTNode)object).getStartOffset();
                }
                break;
            }
            default: {
                union2 = list.get(list.size() - 1);
            }
        }
        if (union2.hasFirst() && union2.first() == null || union2.hasSecond() && union2.second() != null) {
            String string;
            Object object32;
            Object object2;
            Index index = compilationInfo.getIndex("text/x-php5");
            PHPIndex pHPIndex = PHPIndex.get(index);
            switch (attributedElement.getKind()) {
                case FUNC: {
                    if (attributedElement.isClassMember()) {
                        object = (SemiAttribute.ClassMemberElement)attributedElement;
                        object2 = pHPIndex.getAllMethods(null, ((SemiAttribute.ClassMemberElement)object).getClassName(), ((SemiAttribute.AttributedElement)object).getName(), NameKind.PREFIX, -1);
                        break;
                    }
                    object2 = pHPIndex.getFunctions(null, attributedElement.getName(), NameKind.PREFIX);
                    break;
                }
                case IFACE: {
                    object2 = pHPIndex.getInterfaces(null, attributedElement.getName(), NameKind.PREFIX);
                    break;
                }
                case CLASS: {
                    object2 = pHPIndex.getClasses(null, attributedElement.getName(), NameKind.PREFIX);
                    break;
                }
                case VARIABLE: {
                    if (attributedElement.isClassMember()) {
                        object = (SemiAttribute.ClassMemberElement)attributedElement;
                        object2 = pHPIndex.getAllFields(null, ((SemiAttribute.ClassMemberElement)object).getClassName(), ((SemiAttribute.AttributedElement)object).getName(), NameKind.PREFIX, -1);
                        break;
                    }
                    if (union2.hasSecond()) {
                        object = (IndexedElement)union2.second();
                        FileObject fileObject = ((IndexedElement)object).getFileObject();
                        if (fileObject == null) {
                            return DeclarationFinder.DeclarationLocation.NONE;
                        }
                        return new DeclarationFinder.DeclarationLocation(fileObject, ((IndexedElement)object).getOffset());
                    }
                    object2 = Collections.emptyList();
                    break;
                }
                case CONST: {
                    if (attributedElement.isClassMember()) {
                        object = (SemiAttribute.ClassMemberElement)attributedElement;
                        object2 = pHPIndex.getAllClassConstants(null, ((SemiAttribute.ClassMemberElement)object).getClassName(), ((SemiAttribute.AttributedElement)object).getName(), NameKind.PREFIX);
                        break;
                    }
                    if (union2.hasSecond()) {
                        object = (IndexedElement)union2.second();
                        FileObject fileObject = ((IndexedElement)object).getFileObject();
                        assert (fileObject != null);
                        return new DeclarationFinder.DeclarationLocation(fileObject, ((IndexedElement)object).getOffset());
                    }
                    object2 = Collections.emptyList();
                    break;
                }
                default: {
                    object2 = Collections.emptyList();
                }
            }
            object = new LinkedList();
            for (Object object32 : object2) {
                string = ((IndexedElement)object32).getName();
                if (attributedElement.getKind().equals((Object)SemiAttribute.AttributedElement.Kind.VARIABLE) && string.startsWith("$")) {
                    string = string.substring(1);
                }
                if (!attributedElement.getName().equals(string)) continue;
                DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(((IndexedElement)object32).getFileObject(), ((IndexedElement)object32).getOffset());
                object.add(new AlternativeLocationImpl((IndexedElement)object32, attributedElement.getKind(), declarationLocation));
            }
            if (object.isEmpty()) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            if (object.size() == 1) {
                return ((DeclarationFinder.AlternativeLocation)object.get(0)).getLocation();
            }
            DeclarationFinder.DeclarationLocation declarationLocation = ((DeclarationFinder.AlternativeLocation)object.get(0)).getLocation();
            object32 = object.iterator();
            while (object32.hasNext()) {
                string = (DeclarationFinder.AlternativeLocation)object32.next();
                declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)string);
            }
            return declarationLocation;
        }
        return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), ((ASTNode)union2.first()).getStartOffset());
    }

    private static final class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final IndexedElement el;
        private final SemiAttribute.AttributedElement.Kind k;
        private final DeclarationFinder.DeclarationLocation l;

        public AlternativeLocationImpl(IndexedElement indexedElement, SemiAttribute.AttributedElement.Kind kind, DeclarationFinder.DeclarationLocation declarationLocation) {
            this.el = indexedElement;
            this.k = kind;
            this.l = declarationLocation;
        }

        public ElementHandle getElement() {
            return this.el;
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            ElementKind elementKind = null;
            switch (this.k) {
                case FUNC: {
                    elementKind = ElementKind.METHOD;
                    break;
                }
                case CLASS: {
                    elementKind = ElementKind.CLASS;
                }
            }
            if (elementKind != null) {
                htmlFormatter.name(elementKind, true);
                htmlFormatter.appendText(this.el.getName());
                htmlFormatter.name(elementKind, false);
            } else {
                htmlFormatter.appendText(this.el.getName());
            }
            if (this.l.getFileObject() != null) {
                htmlFormatter.appendText(" in ");
                htmlFormatter.appendText(FileUtil.getFileDisplayName((FileObject)this.l.getFileObject()));
            }
            return htmlFormatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.l;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            AlternativeLocationImpl alternativeLocationImpl = (AlternativeLocationImpl)alternativeLocation;
            return this.el.getName().compareTo(alternativeLocationImpl.el.getName());
        }
    }
}

