/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocPropertyTag;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GSFPHPElementHandle
implements ElementHandle {
    private final CompilationInfo info;

    GSFPHPElementHandle(CompilationInfo compilationInfo) {
        this.info = compilationInfo;
    }

    public FileObject getFileObject() {
        return this.info.getFileObject();
    }

    public String getMimeType() {
        return "text/x-php5";
    }

    public String getIn() {
        return null;
    }

    public boolean signatureEquals(ElementHandle elementHandle) {
        return false;
    }

    public abstract ASTNode getASTNode();

    private static Set<Modifier> translateModifiers(int n) {
        HashSet<Modifier> hashSet = new HashSet<Modifier>();
        if (BodyDeclaration.Modifier.isPrivate(n)) {
            hashSet.add(Modifier.PRIVATE);
        }
        if (BodyDeclaration.Modifier.isProtected(n)) {
            hashSet.add(Modifier.PROTECTED);
        }
        if (BodyDeclaration.Modifier.isPublic(n)) {
            hashSet.add(Modifier.PUBLIC);
        }
        if (BodyDeclaration.Modifier.isStatic(n)) {
            hashSet.add(Modifier.STATIC);
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldsFromTagProperty
    extends GSFPHPElementHandle {
        private PHPDocPropertyTag declaration;

        public FieldsFromTagProperty(CompilationInfo compilationInfo, PHPDocPropertyTag pHPDocPropertyTag) {
            super(compilationInfo);
            this.declaration = pHPDocPropertyTag;
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }

        public String getName() {
            return "$" + this.declaration.getFieldName();
        }

        public ElementKind getKind() {
            return ElementKind.FIELD;
        }

        public Set<Modifier> getModifiers() {
            return GSFPHPElementHandle.translateModifiers(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldsDeclarationHandle
    extends GSFPHPElementHandle {
        private FieldsDeclaration declaration;

        public FieldsDeclarationHandle(CompilationInfo compilationInfo, FieldsDeclaration fieldsDeclaration) {
            super(compilationInfo);
            this.declaration = fieldsDeclaration;
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }

        public String getName() {
            Variable[] variableArray;
            String string = "";
            for (Variable variable : variableArray = this.declaration.getVariableNames()) {
                String string2 = Utils.resolveVariableName(variable);
                if (string2 == null) continue;
                string = variable.isDollared() ? string + "$" + string2 : string + string2;
            }
            return string;
        }

        public ElementKind getKind() {
            return ElementKind.FIELD;
        }

        public Set<Modifier> getModifiers() {
            return GSFPHPElementHandle.translateModifiers(this.declaration.getModifier());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalConstant
    extends GSFPHPElementHandle {
        private FunctionInvocation invocation;
        private String name = null;

        public GlobalConstant(CompilationInfo compilationInfo, FunctionInvocation functionInvocation) {
            super(compilationInfo);
            this.invocation = functionInvocation;
        }

        @Override
        public ASTNode getASTNode() {
            return this.invocation;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public String getName() {
            Scalar scalar;
            List<Expression> list;
            if (this.name == null && (list = this.invocation.getParameters()).size() == 2 && list.get(0) instanceof Scalar && list.get(1) instanceof Scalar && (scalar = (Scalar)list.get(0)).getScalarType() == Scalar.Type.STRING) {
                this.name = scalar.getStringValue();
            }
            return this.name;
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodDeclarationHandle
    extends FunctionDeclarationHandle {
        private MethodDeclaration declaration;

        public MethodDeclarationHandle(CompilationInfo compilationInfo, MethodDeclaration methodDeclaration) {
            super(compilationInfo, methodDeclaration.getFunction());
            this.declaration = methodDeclaration;
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return GSFPHPElementHandle.translateModifiers(this.declaration.getModifier());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassConstantDeclarationHandle
    extends GSFPHPElementHandle {
        private ClassConstantDeclaration declaration;

        public ClassConstantDeclarationHandle(CompilationInfo compilationInfo, ClassConstantDeclaration classConstantDeclaration) {
            super(compilationInfo);
            this.declaration = classConstantDeclaration;
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }

        public String getName() {
            String string = "";
            List<Identifier> list = this.declaration.getNames();
            for (Identifier identifier : list) {
                string = string + identifier;
            }
            return string;
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionDeclarationHandle
    extends GSFPHPElementHandle {
        private FunctionDeclaration declaration;

        public FunctionDeclarationHandle(CompilationInfo compilationInfo, FunctionDeclaration functionDeclaration) {
            super(compilationInfo);
            this.declaration = functionDeclaration;
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }

        public String getName() {
            String string = "";
            if (this.declaration.getFunctionName() != null) {
                string = this.declaration.getFunctionName().getName();
            }
            return string;
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InterfaceDeclarationHandle
    extends GSFPHPElementHandle {
        private InterfaceDeclaration declaration;

        public InterfaceDeclarationHandle(CompilationInfo compilationInfo, InterfaceDeclaration interfaceDeclaration) {
            super(compilationInfo);
            this.declaration = interfaceDeclaration;
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }

        public String getName() {
            String string = "";
            if (this.declaration.getName() != null) {
                string = this.declaration.getName().getName();
            }
            return string;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDeclarationHandle
    extends GSFPHPElementHandle {
        private ClassDeclaration declaration;

        public ClassDeclarationHandle(CompilationInfo compilationInfo, ClassDeclaration classDeclaration) {
            super(compilationInfo);
            this.declaration = classDeclaration;
        }

        public String getName() {
            String string = "";
            if (this.declaration.getName() != null) {
                string = this.declaration.getName().getName();
            }
            return string;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ASTNode getASTNode() {
            return this.declaration;
        }
    }
}

