/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AccidentalAssignmentCustomizer;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.openide.util.NbBundle;

public class AccidentalAssignmentRule
extends PHPRule
implements PHPRuleWithPreferences {
    private static final String INCL_WHILE_PREFS_KEY = "php.verification.accidental.assignment.include.while";
    private Preferences prefs = null;
    private boolean inclWhile = false;

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "accidental.assignment";
    }

    public String getDescription() {
        return NbBundle.getMessage(AccidentalAssignmentRule.class, (String)"AccidentalAssignmentDesc");
    }

    public void visit(Program program) {
        this.inclWhile = AccidentalAssignmentRule.includeAssignementsInWhile(this.prefs);
        super.visit(program);
    }

    public void visit(IfStatement ifStatement) {
        this.check(ifStatement.getCondition());
        super.visit(ifStatement);
    }

    public void visit(DoStatement doStatement) {
        this.check(doStatement.getCondition());
        super.visit(doStatement);
    }

    public void visit(ForStatement forStatement) {
        for (Expression expression : forStatement.getConditions()) {
            this.check(expression);
        }
        super.visit(forStatement);
    }

    public void visit(WhileStatement whileStatement) {
        if (this.inclWhile) {
            this.check(whileStatement.getCondition());
        }
        super.visit(whileStatement);
    }

    private void check(Expression expression) {
        expression.accept(new ExpressionFinder());
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AccidentalAssignmentRule.class, (String)"AccidentalAssignmentDispName");
    }

    public JComponent getCustomizer(Preferences preferences) {
        return new AccidentalAssignmentCustomizer(preferences);
    }

    public static final boolean includeAssignementsInWhile(Preferences preferences) {
        return preferences.getBoolean(INCL_WHILE_PREFS_KEY, false);
    }

    public static final void setIncludeAssignementsInWhile(Preferences preferences, boolean bl) {
        preferences.putBoolean(INCL_WHILE_PREFS_KEY, bl);
    }

    public void setPreferences(Preferences preferences) {
        this.prefs = preferences;
    }

    private class ExpressionFinder
    extends DefaultVisitor {
        private ExpressionFinder() {
        }

        public void visit(Assignment assignment) {
            OffsetRange offsetRange = new OffsetRange(assignment.getStartOffset(), assignment.getEndOffset());
            Hint hint = new Hint((Rule)AccidentalAssignmentRule.this, AccidentalAssignmentRule.this.getDisplayName(), AccidentalAssignmentRule.this.context.compilationInfo.getFileObject(), offsetRange, null, 500);
            AccidentalAssignmentRule.this.addResult(hint);
            super.visit(assignment);
        }
    }
}

