/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.http.api;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpProgress;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpRequest;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSHttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpActivity {
    private JSHttpRequest request;
    private JSHttpResponse response;
    private Date startTime;
    private Date endTime;
    private static final Logger LOG = Logger.getLogger(HttpActivity.class.getName());
    private JSHttpProgress lastProgress;
    String mimeType;

    private HttpActivity() {
    }

    public HttpActivity(JSHttpRequest jSHttpRequest) {
        this(jSHttpRequest, null);
    }

    public HttpActivity(JSHttpRequest jSHttpRequest, JSHttpResponse jSHttpResponse) {
        this.request = jSHttpRequest;
        if (jSHttpRequest != null) {
            this.startTime = HttpActivity.convertLongStringToTime(jSHttpRequest.getTimeStamp());
        }
        if (jSHttpResponse != null) {
            this.setResponse(jSHttpResponse);
        }
    }

    public static final Date convertLongStringToTime(String string) {
        Calendar calendar = Calendar.getInstance();
        long l = Long.parseLong(string);
        calendar.setTimeInMillis(l);
        return calendar.getTime();
    }

    public String getResponseText() {
        if (this.response != null) {
            return this.response.getResponseText();
        }
        if (this.lastProgress != null) {
            return this.lastProgress.getResponseText();
        }
        return "";
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime;
        }
        return this.startTime;
    }

    public String getMethod() {
        return this.request.getMethod().toString().toUpperCase();
    }

    public JSHttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(JSHttpResponse jSHttpResponse) {
        assert (jSHttpResponse != null);
        this.response = jSHttpResponse;
        this.mimeType = jSHttpResponse.getMimeType();
        assert (this.mimeType != null);
        this.endTime = HttpActivity.convertLongStringToTime(jSHttpResponse.getTimeStamp());
        assert (this.endTime != null);
    }

    public JSHttpRequest getRequest() {
        return this.request;
    }

    public void updateProgress(JSHttpProgress jSHttpProgress) {
        assert (jSHttpProgress != null);
        this.lastProgress = jSHttpProgress;
        this.endTime = HttpActivity.convertLongStringToTime(this.lastProgress.getTimeStamp());
        assert (this.endTime != null);
        this.mimeType = this.lastProgress.getMimeType();
        assert (this.mimeType != null);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getCategory() {
        String string = null;
        if (this.response != null) {
            string = this.response.getCategory();
        } else if (this.lastProgress != null) {
            string = this.lastProgress.getCategory();
        } else {
            LOG.finest("getCategory: Response and Progress are null");
        }
        return string;
    }

    public JSHttpProgress getProgress() {
        return this.lastProgress;
    }

    public String toString() {
        if (this.request != null) {
            return this.request.getUrl().toLowerCase().toString();
        }
        if (this.response != null) {
            return this.response.getUrl().toLowerCase().toString();
        }
        return this.lastProgress.getId();
    }

    public Map<String, String> getResponseHeader() {
        Map map = Collections.emptyMap();
        if (this.response != null) {
            map = this.response.getHeader();
        } else if (this.lastProgress != null) {
            map = this.lastProgress.getHeader();
        }
        return map;
    }

    public Map<String, String> getRequestHeader() {
        return this.request.getHeader();
    }
}

