/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class NbJSBreakpointModel
implements NodeModel,
TableModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String CONDITIONAL_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String DISABLED_CONDITIONAL_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof NbJSBreakpoint) {
            NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
            return nbJSBreakpoint.getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof NbJSBreakpoint) {
            NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
            if (!nbJSBreakpoint.isEnabled()) {
                if (nbJSBreakpoint.isConditional()) {
                    return DISABLED_CONDITIONAL_LINE_BREAKPOINT;
                }
                return DISABLED_LINE_BREAKPOINT;
            }
            if (nbJSBreakpoint.isConditional()) {
                return CONDITIONAL_LINE_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof NbJSBreakpoint) {
            NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
            return nbJSBreakpoint.getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof NbJSBreakpoint) {
            NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
            if ("BreakpointEnabled".equals(string)) {
                return nbJSBreakpoint.isEnabled();
            }
            if ("RESOLVED_LOCATION".equals(string)) {
                return nbJSBreakpoint.getResolvedLocation();
            }
            return string;
        }
        if ("RESOLVED_LOCATION".equals(string)) {
            return "";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if ("RESOLVED_LOCATION".equals(string)) {
            return true;
        }
        if (object instanceof NbJSBreakpoint) {
            return !"BreakpointEnabled".equals(string);
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof NbJSBreakpoint && "BreakpointEnabled".equals(string) && object2 instanceof Boolean) {
            if (((Boolean)object2).booleanValue()) {
                ((NbJSBreakpoint)((Object)object)).enable();
            } else {
                ((NbJSBreakpoint)((Object)object)).disable();
            }
        } else {
            throw new UnknownTypeException(object);
        }
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

