/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JToolTip;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.models.AbstractColumnModel;
import org.netbeans.modules.web.client.javascript.debugger.models.Log;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class NbJSSourcesModel
implements TreeModel,
NodeModel,
TableModel,
NodeActionsProvider,
JSDebuggerEventListener {
    private final Action GO_TO_ACTION;
    private final Action GO_TO_CLIENT_SOURCE_ACTION;
    private final NbJSDebugger debugger;
    private JSSource[] sources;
    private List<ModelListener> listeners;
    private PropertyChangeListener propertyChangeListener;

    public NbJSSourcesModel(ContextProvider contextProvider) {
        this.debugger = NbJSContextProviderWrapper.getContextProviderWrapper(contextProvider).getNbJSDebugger();
        this.debugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)((Object)this), (Object)this.debugger));
        this.propertyChangeListener = new PropertyChangeListenerImpl();
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)this.debugger));
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
        this.sources = this.debugger.isIgnoringQueryStrings() ? this.filterEquivalentSources(this.debugger.getSources()) : this.debugger.getSources();
        this.GO_TO_ACTION = NbJSEditorUtil.createDebuggerGoToAction(this.debugger);
        this.GO_TO_CLIENT_SOURCE_ACTION = NbJSEditorUtil.createDebuggerGoToClientSourceAction(this.debugger);
    }

    private void setSources(JSSource[] jSSourceArray) {
        if (this.debugger.isIgnoringQueryStrings()) {
            jSSourceArray = this.filterEquivalentSources(jSSourceArray);
        }
        this.sources = jSSourceArray;
        this.fireTreeChanges();
    }

    private JSSource[] filterEquivalentSources(JSSource[] jSSourceArray) {
        if (jSSourceArray == null || jSSourceArray.length < 2) {
            return jSSourceArray;
        }
        LinkedHashMap<URI, JSSource> linkedHashMap = new LinkedHashMap<URI, JSSource>();
        for (JSSource jSSource : jSSourceArray) {
            URI uRI = this.getURIWithoutQuery(jSSource.getLocation().getURI());
            if (linkedHashMap.containsKey(uRI)) continue;
            linkedHashMap.put(uRI, jSSource);
        }
        return linkedHashMap.values().toArray(new JSSource[0]);
    }

    private URI getURIWithoutQuery(URI uRI) {
        try {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), null, uRI.getFragment());
            return uRI2;
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.INFO, "Could not remove query string from URI: " + uRI.toASCIIString());
            return uRI;
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            if (this.sources == null) {
                return JSSource.EMPTY_ARRAY;
            }
            return this.sources;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return this.sources == null ? 0 : this.sources.length;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof JSSource) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTableValueChanges(Object object, Object object2, String string) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TableValueChanged(object, object2, string));
        }
    }

    public void fireTreeChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof JSSource) {
            if (string.equals(COLUMN_ID.USE_COLUMN.name())) {
                return ((JSSource)object).isEnabled();
            }
            if (string.equals(COLUMN_ID.DEFAULT_SOURCES_COLUMN.name())) {
                return ((JSSource)object).getLocation().getURI().toString();
            }
        } else if (object instanceof JToolTip) {
            return "";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (string.equals(COLUMN_ID.USE_COLUMN.name()) && object instanceof JSSource) {
            JSSource jSSource = (JSSource)object;
            jSSource.setEnabled(((Boolean)object2).booleanValue());
            return;
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof JSSource) {
            return new Action[]{this.GO_TO_ACTION, this.GO_TO_CLIENT_SOURCE_ACTION};
        }
        return new Action[0];
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof JSSource) {
            FileObject fileObject = this.debugger.getFileObjectForSource((JSSource)object);
            NbJSEditorUtil.openFileObject(fileObject);
        }
    }

    public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        JSDebuggerState jSDebuggerState = jSDebuggerEvent.getDebuggerState();
        NbJSDebugger nbJSDebugger = (NbJSDebugger)jSDebuggerEvent.getSource();
        switch (jSDebuggerState.getState()) {
            case SUSPENDED: {
                break;
            }
            case RUNNING: 
            case STARTING: {
                break;
            }
            case DISCONNECTED: {
                nbJSDebugger.removeJSDebuggerEventListener(this);
                break;
            }
        }
        this.fireTreeChanges();
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return "";
        }
        if (object instanceof JSSource) {
            JSSource jSSource = (JSSource)object;
            FileObject fileObject = this.debugger.getFileObjectForSource(jSSource);
            if (fileObject == null) {
                String string = jSSource.getLocation().getURI().toString();
                Log.getLogger().warning("The File Object for the following source is null:" + string);
                return string;
            }
            return fileObject instanceof URLFileObject ? ((URLFileObject)fileObject).getDisplayName() : FileUtil.getFileDisplayName((FileObject)fileObject);
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        return "org/openide/nodes/defaultNode";
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        return this.getDisplayName(object);
    }

    public static class SourcesUsedColumn
    extends AbstractColumnModel {
        public String getID() {
            return COLUMN_ID.USE_COLUMN.name();
        }

        public String getDisplayName() {
            return NbBundle.getBundle(NbJSSourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(NbJSSourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Name_Mnc").charAt(0));
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle(NbJSSourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumnModel {
        public String getID() {
            return COLUMN_ID.DEFAULT_SOURCES_COLUMN.name();
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(NbJSSourcesModel.class).getString("CTL_SourcesModel_Column_Name_Name_Mnc").charAt(0));
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("sources")) {
                NbJSSourcesModel.this.setSources((JSSource[])propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("reloadsources")) {
                NbJSSourcesModel.this.fireTreeChanges();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum COLUMN_ID {
        USE_COLUMN,
        DEFAULT_SOURCES_COLUMN;

    }
}

