/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSVariablesModel;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSPrimitive;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public final class NbJSWatchesModel
extends NbJSVariablesModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private WatchesListener listener;

    public NbJSWatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        this.checkListener(object);
        if (object == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches();
        }
        if (object instanceof Watch) {
            Watch watch = (Watch)object;
            JSProperty jSProperty = this.eval(watch.getExpression());
            return jSProperty == null ? new Object[]{} : super.getChildren(jSProperty, n, n2);
        }
        return super.getChildren(object, n, n2);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Watch) {
            Watch watch = (Watch)object;
            JSProperty jSProperty = this.eval(watch.getExpression());
            return jSProperty == null ? true : super.isLeaf(jSProperty);
        }
        return super.isLeaf(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        this.checkListener(object);
        if (object == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches().length;
        }
        if (object instanceof Watch) {
            Watch watch = (Watch)object;
            JSProperty jSProperty = this.eval(watch.getExpression());
            return jSProperty == null ? 0 : super.getChildrenCount(jSProperty);
        }
        return super.getChildrenCount(object);
    }

    private JSProperty eval(String string) {
        JSCallStackFrame jSCallStackFrame = this.debugger.getSelectedFrame();
        if (jSCallStackFrame != null) {
            return jSCallStackFrame.eval(string);
        }
        return null;
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbJSWatchesModel.getMessage("CTL_CallstackModel.Column.Name.Name");
        }
        if (object instanceof Watch) {
            return ((Watch)object).getExpression();
        }
        return super.getDisplayName(object);
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        if (object == "Root" || object instanceof Watch) {
            return WATCH;
        }
        return super.getIconBaseWithExtension(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbJSWatchesModel.getMessage("CTL_CallstackModel.Column.Name.Desc");
        }
        if (object instanceof Watch) {
            Watch watch = (Watch)object;
            JSProperty jSProperty = this.eval(watch.getExpression());
            return jSProperty == null ? NbJSWatchesModel.getMessage("CTL_WatchesModel.Unknown.Evaluation") : super.getShortDescription(jSProperty);
        }
        return super.getShortDescription(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof Watch) {
            Watch watch = (Watch)object;
            JSProperty jSProperty = this.eval(watch.getExpression());
            if (jSProperty == null) {
                return NbJSWatchesModel.getMessage("CTL_WatchesModel.Unknown.Evaluation");
            }
            if ("WatchValue".equals(string)) {
                return super.getValueAt(jSProperty, "LocalsValue");
            }
            if ("WatchType".equals(string)) {
                return super.getValueAt(jSProperty, "LocalsType");
            }
            if ("WatchToString".equals(string)) {
                return super.getValueAt(jSProperty, "LocalsToString");
            }
        } else {
            if ("WatchValue".equals(string)) {
                return super.getValueAt(object, "LocalsValue");
            }
            if ("WatchType".equals(string)) {
                return super.getValueAt(object, "LocalsType");
            }
            if ("WatchToString".equals(string) || "LocalsToString".equals(string)) {
                return super.getValueAt(object, "LocalsToString");
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        JSValue jSValue;
        Watch watch;
        JSProperty jSProperty;
        return !"WatchValue".equals(string) || !(object instanceof Watch) || (jSProperty = this.eval((watch = (Watch)object).getExpression())) == null || (jSValue = jSProperty.getValue()) == null || !(jSValue instanceof JSPrimitive) && jSValue.getTypeOf() != JSValue.TypeOf.STRING;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        Watch watch;
        JSProperty jSProperty;
        if ("WatchValue".equals(string) && object instanceof Watch && (jSProperty = this.eval((watch = (Watch)object).getExpression())) != null) {
            JSValue jSValue = jSProperty.getValue();
            if (jSValue != null && (jSValue instanceof JSPrimitive || jSValue.getTypeOf() == JSValue.TypeOf.STRING) && jSProperty.setValue(object2.toString())) {
                this.fireChanges();
            }
            return;
        }
        throw new UnknownTypeException(object);
    }

    private synchronized void checkListener(Object object) {
        if (this.listener == null && (object == "Root" || object instanceof Watch)) {
            this.listener = new WatchesListener(this);
        }
    }

    private void fireWatchPropertyChanged(Watch watch, String string) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)watch));
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(NbJSWatchesModel.class, (String)string);
    }

    private static class WatchesListener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference<NbJSWatchesModel> modelRef;

        public WatchesListener(NbJSWatchesModel nbJSWatchesModel) {
            Watch[] watchArray;
            this.modelRef = new WeakReference<NbJSWatchesModel>(nbJSWatchesModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watchArray = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private NbJSWatchesModel getModel() {
            NbJSWatchesModel nbJSWatchesModel = (NbJSWatchesModel)this.modelRef.get();
            if (nbJSWatchesModel == null) {
                Watch[] watchArray;
                DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
                for (Watch watch : watchArray = DebuggerManager.getDebuggerManager().getWatches()) {
                    watch.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return nbJSWatchesModel;
        }

        public void watchAdded(Watch watch) {
            NbJSWatchesModel nbJSWatchesModel = this.getModel();
            if (nbJSWatchesModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            nbJSWatchesModel.fireChanges();
        }

        public void watchRemoved(Watch watch) {
            NbJSWatchesModel nbJSWatchesModel = this.getModel();
            if (nbJSWatchesModel == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            nbJSWatchesModel.fireChanges();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            NbJSWatchesModel nbJSWatchesModel = this.getModel();
            if (nbJSWatchesModel == null) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof Watch)) {
                return;
            }
            Watch watch = (Watch)propertyChangeEvent.getSource();
            nbJSWatchesModel.fireWatchPropertyChanged(watch, propertyChangeEvent.getPropertyName());
        }
    }
}

