/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSDebuggerAnnotation;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSUtil;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public final class NbJSCallStackAnnotationListener
extends DebuggerManagerAdapter
implements JSDebuggerEventListener {
    private static final Map<JSCallStackFrame, Annotation> callStackToAnnotation = new HashMap<JSCallStackFrame, Annotation>();
    private static NbJSDebuggerAnnotation currentLineAnnotation;
    private static final NbJSCallStackAnnotationListener annotationListener;

    public String[] getProperties() {
        return new String[]{"debuggerEngines"};
    }

    public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        NbJSDebugger nbJSDebugger = (NbJSDebugger)jSDebuggerEvent.getSource();
        JSDebuggerState jSDebuggerState = jSDebuggerEvent.getDebuggerState();
        if (nbJSDebugger != null && jSDebuggerState == null) {
            NbJSUtil.severe("STATE SHOULD NOT BE NULL");
            return;
        }
        switch (jSDebuggerState.getState()) {
            case SUSPENDED: {
                JSCallStackFrame[] jSCallStackFrameArray = nbJSDebugger.getCallStackFrames();
                NbJSCallStackAnnotationListener.clearAnnotations();
                this.addAnnotations(nbJSDebugger, jSCallStackFrameArray);
                JSCallStackFrame jSCallStackFrame = nbJSDebugger.getSelectedFrame();
                if (jSCallStackFrame == null) {
                    return;
                }
                NbJSCallStackAnnotationListener.annotateCurrentLineAnnotation(nbJSDebugger, jSCallStackFrame);
                break;
            }
            case RUNNING: 
            case DISCONNECTED: {
                NbJSCallStackAnnotationListener.clearAnnotations();
                NbJSCallStackAnnotationListener.removeCurrentLineAnnotation();
                break;
            }
        }
    }

    private final void addAnnotations(NbJSDebugger nbJSDebugger, JSCallStackFrame[] jSCallStackFrameArray) {
        for (JSCallStackFrame jSCallStackFrame : jSCallStackFrameArray) {
            NbJSCallStackAnnotationListener.addAnnotation(nbJSDebugger, jSCallStackFrame);
        }
    }

    private static final void clearAnnotations() {
        HashSet<JSCallStackFrame> hashSet = new HashSet<JSCallStackFrame>(callStackToAnnotation.keySet());
        for (JSCallStackFrame jSCallStackFrame : hashSet) {
            NbJSCallStackAnnotationListener.removeAnnotation(jSCallStackFrame);
        }
    }

    private static final void addAnnotation(NbJSDebugger nbJSDebugger, JSCallStackFrame jSCallStackFrame) {
        Line line = NbJSEditorUtil.getLine(nbJSDebugger, jSCallStackFrame);
        if (line != null) {
            NbJSDebuggerAnnotation nbJSDebuggerAnnotation = new NbJSDebuggerAnnotation(NbJSEditorUtil.CALL_STACK_FRAME_ANNOTATION_TYPE, (Annotatable)line);
            callStackToAnnotation.put(jSCallStackFrame, nbJSDebuggerAnnotation);
        }
    }

    private static final void annotateCurrentLineAnnotation(NbJSDebugger nbJSDebugger, JSCallStackFrame jSCallStackFrame) {
        Line line;
        if (currentLineAnnotation != null) {
            currentLineAnnotation.detach();
        }
        if ((line = NbJSEditorUtil.getLine(nbJSDebugger, jSCallStackFrame)) != null) {
            currentLineAnnotation = new NbJSDebuggerAnnotation(NbJSEditorUtil.CURRENT_LINE_ANNOTATION_TYPE, (Annotatable)line);
            NbJSEditorUtil.showLine(line);
        }
    }

    private static final void removeCurrentLineAnnotation() {
        if (currentLineAnnotation != null) {
            currentLineAnnotation.detach();
            currentLineAnnotation = null;
        }
    }

    private static final void removeAnnotation(JSCallStackFrame jSCallStackFrame) {
        Annotation annotation = callStackToAnnotation.remove(jSCallStackFrame);
        if (annotation == null) {
            return;
        }
        annotation.detach();
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
        NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
        if (nbJSDebugger == null) {
            return;
        }
        nbJSDebugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)((Object)annotationListener), (Object)nbJSDebugger));
        super.engineAdded(debuggerEngine);
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
        NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
        if (nbJSDebugger == null) {
            return;
        }
        nbJSDebugger.removeJSDebuggerEventListener(annotationListener);
        super.engineRemoved(debuggerEngine);
    }

    static {
        annotationListener = new NbJSCallStackAnnotationListener();
    }
}

