/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointManager;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSFileObjectBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;

public final class NbJSBreakpointsReader
implements Properties.Reader {
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_LINE_NUMBER = "lineNumber";
    private static final String PROPERTY_CONDITION = "condition";
    private static final String PROPERTY_HITCOUNTFILTER = "hitCountFilter";
    private static final String PROPERTY_HITCOUNTFILTERSTYLE = "hitCountFilterStyle";

    public String[] getSupportedClassNames() {
        return new String[]{NbJSBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        Object object;
        NbJSBreakpoint nbJSBreakpoint = null;
        if (string.equals(NbJSFileObjectBreakpoint.class.getName())) {
            object = NbJSBreakpointsReader.getLine(properties.getString(PROPERTY_URL, null), properties.getInt(PROPERTY_LINE_NUMBER, 1));
            if (object == null) {
                return null;
            }
            nbJSBreakpoint = NbJSBreakpointManager.createBreakpoint((Line)object);
        } else if (string.equals(NbJSURIBreakpoint.class.getName())) {
            nbJSBreakpoint = NbJSBreakpointManager.createURIBreakpoint(properties.getString(PROPERTY_URL, null), properties.getInt(PROPERTY_LINE_NUMBER, 1));
        }
        if (nbJSBreakpoint != null) {
            object = properties.getString(PROPERTY_CONDITION, null);
            int n = properties.getInt(PROPERTY_HITCOUNTFILTER, 0);
            int n2 = properties.getInt(PROPERTY_HITCOUNTFILTERSTYLE, -1);
            if (object != null && ((String)object).length() > 0) {
                nbJSBreakpoint.setCondition((String)object);
            }
            if (n > 0) {
                Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[n2];
                nbJSBreakpoint.setHitCountFilter(n, hIT_COUNT_FILTERING_STYLE);
            }
        }
        return nbJSBreakpoint;
    }

    public void write(Object object, Properties properties) {
        assert (object instanceof NbJSBreakpoint);
        NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
        if (nbJSBreakpoint instanceof NbJSURIBreakpoint) {
            this.writeURIFileObject((NbJSURIBreakpoint)nbJSBreakpoint, properties);
        } else {
            FileObject fileObject = nbJSBreakpoint.getFileObject();
            assert (fileObject != null);
            String string = null;
            try {
                string = fileObject.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileStateInvalidException.printStackTrace();
            }
            int n = nbJSBreakpoint.getLineNumber() - 1;
            String string2 = nbJSBreakpoint.getCondition();
            int n2 = nbJSBreakpoint.getHitCountFilter();
            Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = nbJSBreakpoint.getHitCountFilteringStyle();
            properties.setString(PROPERTY_URL, string);
            properties.setInt(PROPERTY_LINE_NUMBER, n);
            properties.setString(PROPERTY_CONDITION, string2);
            properties.setInt(PROPERTY_HITCOUNTFILTER, n2);
            if (hIT_COUNT_FILTERING_STYLE != null) {
                properties.setInt(PROPERTY_HITCOUNTFILTERSTYLE, hIT_COUNT_FILTERING_STYLE.ordinal());
            }
        }
    }

    public void writeURIFileObject(NbJSURIBreakpoint nbJSURIBreakpoint, Properties properties) {
        properties.setString(PROPERTY_URL, nbJSURIBreakpoint.getLocation().getURI().toString());
        properties.setInt(PROPERTY_LINE_NUMBER, nbJSURIBreakpoint.getLineNumber() - 1);
    }

    private static Line getLine(String string, int n) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            NbJSUtil.finest("Did not find FileObject. Malformed URL '" + string + "'");
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        LineCookie lineCookie = NbJSEditorUtil.getLineCookie(fileObject);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            NbJSUtil.LOGGER.log(Level.FINE, indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NbJSUtil.LOGGER.log(Level.FINE, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        return null;
    }
}

