/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import org.netbeans.modules.web.client.javascript.debugger.api.NbJSFileObjectLocation;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.tools.api.JSAbstractLocation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;

public final class NbJSFileObjectBreakpoint
extends NbJSBreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    private Line line;
    private int lineNumber;

    NbJSFileObjectBreakpoint(Line line) {
        this(NbJSFileObjectBreakpoint.createNbJSAbstactLocation(line));
        this.line = line;
        this.lineNumber = NbJSFileObjectBreakpoint.getLineNumber(line);
    }

    NbJSFileObjectBreakpoint(JSAbstractLocation jSAbstractLocation) {
        super(jSAbstractLocation);
    }

    public FileObject getFileObject() {
        if (this.line != null) {
            DataObject dataObject = (DataObject)this.line.getLookup().lookup(DataObject.class);
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private static final JSAbstractLocation createNbJSAbstactLocation(Line line) {
        if (line == null) {
            throw new NullPointerException("Line can not be null in order to create a NbJSFileObjectBreakpoint");
        }
        DataObject dataObject = (DataObject)line.getLookup().lookup(DataObject.class);
        NbJSFileObjectLocation nbJSFileObjectLocation = new NbJSFileObjectLocation(dataObject.getPrimaryFile(), line.getLineNumber() + 1);
        return nbJSFileObjectLocation;
    }

    public NbJSFileObjectLocation getLocation() {
        JSAbstractLocation jSAbstractLocation = super.getLocation();
        assert (jSAbstractLocation instanceof NbJSFileObjectLocation);
        return (NbJSFileObjectLocation)jSAbstractLocation;
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        Line line2 = line;
        this.line = line;
        if (line == null) {
            throw new NullPointerException("Line is null");
        }
        this.setLocation(NbJSFileObjectBreakpoint.createNbJSAbstactLocation(line));
        this.firePropertyChange(PROP_LINE_NUMBER, this.getLineNumber(), NbJSFileObjectBreakpoint.getLineNumber(line));
        this.lineNumber = NbJSFileObjectBreakpoint.getLineNumber(line);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    static int getLineNumber(Line line) {
        return line.getLineNumber() + 1;
    }

    public void notifyUpdated(Object object) {
        if (object instanceof Line) {
            this.line = (Line)object;
            this.lineNumber = NbJSFileObjectBreakpoint.getLineNumber(this.line);
            this.location = NbJSFileObjectBreakpoint.createNbJSAbstactLocation(this.line);
        }
        super.notifyUpdated(object);
    }
}

