/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointAnnotation;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointAnnotationListener;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public final class NbJSURIBreakpointAnnotationListener
extends NbJSBreakpointAnnotationListener {
    private final List<NbJSURIBreakpoint> uriBreakpoints = new CopyOnWriteArrayList<NbJSURIBreakpoint>();
    private final Map<DebuggerEngine, Map<NbJSURIBreakpoint, Annotation>> engineToBreakpointsToAnnotations = new ConcurrentHashMap<DebuggerEngine, Map<NbJSURIBreakpoint, Annotation>>();
    private final Map<Annotation, Breakpoint> lingeringAnnotations = new WeakHashMap<Annotation, Breakpoint>();
    private final List<WeakReference<NbJSBreakpointAnnotation>> nonEngineAnnotations = new ArrayList<WeakReference<NbJSBreakpointAnnotation>>();

    public String[] getProperties() {
        return new String[]{"breakpoints", "debuggerEngines"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof NbJSURIBreakpoint)) {
            return;
        }
        NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)breakpoint;
        this.addBreakpointAnnotation(nbJSURIBreakpoint);
        this.uriBreakpoints.add(nbJSURIBreakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof NbJSURIBreakpoint)) {
            return;
        }
        NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)breakpoint;
        this.removeBreakpointAnnotation(nbJSURIBreakpoint);
        this.uriBreakpoints.remove((Object)nbJSURIBreakpoint);
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
        NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
        if (nbJSDebugger == null) {
            return;
        }
        assert (!this.engineToBreakpointsToAnnotations.containsKey(debuggerEngine));
        this.engineToBreakpointsToAnnotations.put(debuggerEngine, new HashMap());
        for (NbJSURIBreakpoint nbJSURIBreakpoint : this.uriBreakpoints) {
            this.addBreakpointAnnotation(nbJSURIBreakpoint, debuggerEngine);
        }
        super.engineAdded(debuggerEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineRemoved(DebuggerEngine debuggerEngine) {
        assert (debuggerEngine != null);
        Map<NbJSURIBreakpoint, Annotation> map = this.engineToBreakpointsToAnnotations.get(debuggerEngine);
        if (map != null) {
            Map<Annotation, Breakpoint> map2 = this.lingeringAnnotations;
            synchronized (map2) {
                for (Map.Entry<NbJSURIBreakpoint, Annotation> entry : map.entrySet()) {
                    this.lingeringAnnotations.put(entry.getValue(), entry.getKey());
                }
            }
        }
        this.engineToBreakpointsToAnnotations.remove(debuggerEngine);
        super.engineRemoved(debuggerEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addBreakpointAnnotation(NbJSBreakpoint nbJSBreakpoint) {
        assert (nbJSBreakpoint instanceof NbJSURIBreakpoint);
        boolean bl = false;
        NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)nbJSBreakpoint;
        Line line = nbJSURIBreakpoint.getOwnerLine();
        DataObject dataObject = line != null ? (DataObject)line.getLookup().lookup(DataObject.class) : null;
        FileObject fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
        for (Object object : this.engineToBreakpointsToAnnotations.keySet()) {
            bl = bl || this.addBreakpointAnnotation((NbJSURIBreakpoint)nbJSBreakpoint, (DebuggerEngine)object, fileObject);
        }
        if (!bl && line != null) {
            Object object;
            Object object2 = new NbJSBreakpointAnnotation((Annotatable)line, nbJSBreakpoint);
            object = this.nonEngineAnnotations;
            synchronized (object) {
                this.nonEngineAnnotations.add(new WeakReference<Iterator<DebuggerEngine>>((Iterator<DebuggerEngine>)object2));
            }
        }
        nbJSBreakpoint.addPropertyChangeListener(this.getEnableBreakpointPropertyChangeListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeBreakpointAnnotation(NbJSBreakpoint nbJSBreakpoint) {
        assert (nbJSBreakpoint instanceof NbJSURIBreakpoint);
        boolean bl = false;
        for (DebuggerEngine object22 : this.engineToBreakpointsToAnnotations.keySet()) {
            this.removeBreakpointAnnotation((NbJSURIBreakpoint)nbJSBreakpoint, object22);
            bl = true;
        }
        Map<Annotation, Breakpoint> map = this.nonEngineAnnotations;
        synchronized (map) {
            Iterator<WeakReference<NbJSBreakpointAnnotation>> iterator = this.nonEngineAnnotations.iterator();
            while (iterator.hasNext()) {
                Object object = (NbJSBreakpointAnnotation)((Object)iterator.next().get());
                if (object == null) {
                    iterator.remove();
                    continue;
                }
                if (object.getBreakpoint() != nbJSBreakpoint) continue;
                object.detach();
                iterator.remove();
            }
        }
        map = this.lingeringAnnotations;
        synchronized (map) {
            if (!bl && this.lingeringAnnotations.containsValue((Object)nbJSBreakpoint)) {
                LinkedHashSet<Annotation> linkedHashSet = new LinkedHashSet<Annotation>();
                for (Map.Entry entry : this.lingeringAnnotations.entrySet()) {
                    if (entry.getValue() != nbJSBreakpoint) continue;
                    Annotation annotation = (Annotation)entry.getKey();
                    if (annotation != null) {
                        annotation.detach();
                    }
                    linkedHashSet.add(annotation);
                }
                for (Annotation annotation : linkedHashSet) {
                    this.lingeringAnnotations.remove(annotation);
                }
            }
        }
        assert (this.enableBreakpointPropertyChangeListener != null);
        nbJSBreakpoint.removePropertyChangeListener(this.enableBreakpointPropertyChangeListener);
    }

    private final boolean addBreakpointAnnotation(NbJSURIBreakpoint nbJSURIBreakpoint, DebuggerEngine debuggerEngine) {
        return this.addBreakpointAnnotation(nbJSURIBreakpoint, debuggerEngine, null);
    }

    private final boolean addBreakpointAnnotation(NbJSURIBreakpoint nbJSURIBreakpoint, DebuggerEngine debuggerEngine, FileObject fileObject) {
        Line line = nbJSURIBreakpoint.getLine(debuggerEngine);
        if (line != null) {
            NbJSBreakpointAnnotation nbJSBreakpointAnnotation = new NbJSBreakpointAnnotation((Annotatable)line, nbJSURIBreakpoint);
            Map<NbJSURIBreakpoint, Annotation> map = this.engineToBreakpointsToAnnotations.get(debuggerEngine);
            map.put(nbJSURIBreakpoint, (Annotation)nbJSBreakpointAnnotation);
            return fileObject != null && nbJSURIBreakpoint.getFileObject(debuggerEngine) == fileObject;
        }
        return false;
    }

    private final void removeBreakpointAnnotation(NbJSURIBreakpoint nbJSURIBreakpoint, DebuggerEngine debuggerEngine) {
        Map<NbJSURIBreakpoint, Annotation> map = this.engineToBreakpointsToAnnotations.get(debuggerEngine);
        Annotation annotation = map.remove((Object)nbJSURIBreakpoint);
        if (annotation == null) {
            return;
        }
        annotation.detach();
    }
}

