/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSFileObjectLocation;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSLocation;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.impl.Log;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentityLocationMappersFactory
implements LocationMappersFactory {
    static final String[] SUPPORTED_MIME_TYPES = new String[]{"text/html", "text/javascript"};

    public NbJSToJSLocationMapper getNbJSToJSLocationMapper(FileObject fileObject, URI uRI, Map<String, Object> map) {
        return new NbJSToJSLocationMapperImpl(fileObject, uRI, map);
    }

    public JSToNbJSLocationMapper getJSToNbJSLocationMapper(FileObject fileObject, URI uRI, Map<String, Object> map) {
        return new JSToNbJSLocationMapperImpl(fileObject, uRI, map);
    }

    public NbJSToJSLocationMapper getNbJSToJSLocationMapper(FileObject[] fileObjectArray, URI uRI, Map<String, Object> map) {
        return new NbJSToJSLocationMapperImpl(fileObjectArray, uRI, map);
    }

    public JSToNbJSLocationMapper getJSToNbJSLocationMapper(FileObject[] fileObjectArray, URI uRI, Map<String, Object> map) {
        return new JSToNbJSLocationMapperImpl(fileObjectArray, uRI, map);
    }

    private static boolean hasSupportedMIMEType(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String string = fileObject.getMIMEType();
        for (String string2 : SUPPORTED_MIME_TYPES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NbJSToJSLocationMapperImpl
    implements NbJSToJSLocationMapper {
        private final String serverPrefix;
        private final FileObject[] documentBases;
        private FileObject welcomeFile;

        public NbJSToJSLocationMapperImpl(FileObject fileObject, URI uRI, Map<String, Object> map) {
            this(new FileObject[]{fileObject}, uRI, map);
            FileObject[] fileObjectArray;
            String string = null;
            if (map != null && (fileObjectArray = map.get("welcome-file")) instanceof String) {
                string = (String)fileObjectArray;
            }
            if (string != null) {
                this.welcomeFile = null;
                for (FileObject fileObject2 : this.documentBases) {
                    FileObject fileObject3 = fileObject2.getFileObject(string);
                    if (fileObject3 == null) continue;
                    this.welcomeFile = fileObject3;
                }
            } else {
                this.welcomeFile = null;
            }
        }

        public NbJSToJSLocationMapperImpl(FileObject[] fileObjectArray, URI uRI, Map<String, Object> map) {
            String string = uRI.toString();
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.serverPrefix = string;
            this.documentBases = (FileObject[])fileObjectArray.clone();
        }

        public JSLocation getJSLocation(NbJSLocation nbJSLocation, Lookup lookup) {
            if (nbJSLocation instanceof NbJSFileObjectLocation) {
                NbJSFileObjectLocation nbJSFileObjectLocation = (NbJSFileObjectLocation)nbJSLocation;
                FileObject fileObject = nbJSFileObjectLocation.getFileObject();
                if (!IdentityLocationMappersFactory.hasSupportedMIMEType(fileObject)) {
                    return null;
                }
                URI uRI = this.fileObjectToUri(fileObject);
                if (uRI != null) {
                    JSURILocation jSURILocation = new JSURILocation(uRI, nbJSFileObjectLocation.getLineNumber(), nbJSFileObjectLocation.getColumnNumber());
                    if (this.welcomeFile != null && fileObject.equals(this.welcomeFile)) {
                        try {
                            URI uRI2 = new URI(this.serverPrefix);
                            jSURILocation.addEquivalentURI(uRI2);
                            if (!this.serverPrefix.endsWith("/")) {
                                URI uRI3 = new URI(this.serverPrefix + "/");
                                jSURILocation.addEquivalentURI(uRI3);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Log.getLogger().log(Level.INFO, "Could not transform create URI", uRISyntaxException);
                        }
                    }
                    return jSURILocation;
                }
                return null;
            }
            return null;
        }

        URI fileObjectToUri(FileObject fileObject) {
            String string = fileObject.getPath();
            for (FileObject fileObject2 : this.documentBases) {
                String string2 = fileObject2.getPath();
                if (!string.startsWith(string2)) continue;
                String string3 = string.substring(string2.length());
                String string4 = string3.length() > 0 && string3.charAt(0) == '/' ? this.serverPrefix + string3 : this.serverPrefix + "/" + string3;
                try {
                    return new URI(string4);
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JSToNbJSLocationMapperImpl
    implements JSToNbJSLocationMapper {
        private final String serverPrefix;
        private final FileObject[] documentBases;
        private FileObject welcomeFile;

        public JSToNbJSLocationMapperImpl(FileObject fileObject, URI uRI, Map<String, Object> map) {
            this(new FileObject[]{fileObject}, uRI, map);
        }

        public JSToNbJSLocationMapperImpl(FileObject[] fileObjectArray, URI uRI, Map<String, Object> map) {
            FileObject[] fileObjectArray2;
            String string = uRI.toString();
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.serverPrefix = string;
            this.documentBases = (FileObject[])fileObjectArray.clone();
            String string2 = null;
            if (map != null && (fileObjectArray2 = map.get("welcome-file")) instanceof String) {
                string2 = (String)fileObjectArray2;
            }
            if (string2 != null) {
                this.welcomeFile = null;
                for (FileObject fileObject : this.documentBases) {
                    FileObject fileObject2 = fileObject.getFileObject(string2);
                    if (fileObject2 == null) continue;
                    this.welcomeFile = fileObject2;
                }
            } else {
                this.welcomeFile = null;
            }
        }

        public NbJSLocation getNbJSLocation(JSLocation jSLocation, Lookup lookup) {
            if (jSLocation instanceof JSURILocation) {
                JSURILocation jSURILocation = (JSURILocation)jSLocation;
                FileObject fileObject = this.uriToFO(jSURILocation.getURI());
                if (fileObject == null || !IdentityLocationMappersFactory.hasSupportedMIMEType(fileObject)) {
                    return null;
                }
                return new NbJSFileObjectLocation(fileObject, jSURILocation.getLineNumber(), jSURILocation.getColumnNumber());
            }
            return null;
        }

        FileObject uriToFO(URI uRI) {
            String string;
            try {
                string = uRI.toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                Log.getLogger().log(Level.FINE, "URI mapping failed due to URI->URL conversion: " + uRI.toString());
                string = null;
            }
            if (string != null && string.startsWith(this.serverPrefix)) {
                String string2 = string.substring(this.serverPrefix.length());
                if (this.welcomeFile != null && (string2.length() == 0 || string2.length() == 1 && string2.charAt(0) == '/')) {
                    return this.welcomeFile;
                }
                for (FileObject fileObject : this.documentBases) {
                    FileObject fileObject2 = fileObject.getFileObject(string2);
                    if (fileObject2 == null) continue;
                    return fileObject2;
                }
                return null;
            }
            return null;
        }
    }
}

