/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.libraries.provider;

import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javascript.libraries.provider.JavaScriptVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaScriptLibraryTypeProvider
implements LibraryTypeProvider {
    private static final String LIB_PREFIX = "libs.";
    public static final String LIBRARY_TYPE = "javascript";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SCRIPTPATH = "scriptpath";
    public static final String[] VOLUME_TYPES = new String[]{"scriptpath", "classpath"};

    private JavaScriptLibraryTypeProvider() {
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JavaScriptLibraryTypeProvider.class, (String)"TXT_JavaScriptLibraryType");
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String[] getSupportedVolumeTypes() {
        return VOLUME_TYPES;
    }

    public LibraryImplementation createLibrary() {
        return LibrariesSupport.createLibraryImplementation((String)LIBRARY_TYPE, (String[])VOLUME_TYPES);
    }

    public void libraryDeleted(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String string = JavaScriptLibraryTypeProvider.LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
                        editableProperties.remove((Object)string);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public static JavaScriptLibraryTypeProvider create() {
        return new JavaScriptLibraryTypeProvider();
    }

    public void libraryCreated(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = JavaScriptLibraryTypeProvider.addLibraryIntoBuild(libraryImplementation, editableProperties);
                    if (bl) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public Customizer getCustomizer(String string) {
        if (VOLUME_TYPES[0].equals(string) || VOLUME_TYPES[1].equals(string)) {
            return new JavaScriptVolumeCustomizer(string);
        }
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation libraryImplementation, EditableProperties editableProperties) {
        boolean bl = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            Object object2;
            String string = LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
            List list = libraryImplementation.getContent(VOLUME_TYPES[i]);
            if (list == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object2 : list) {
                URI uRI;
                if ("jar".equals(((URL)object2).getProtocol())) {
                    object2 = FileUtil.getArchiveFile((URL)object2);
                }
                File file = null;
                FileObject fileObject = URLMapper.findFileObject((URL)object2);
                if (fileObject != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                } else if ("file".equals(((URL)object2).getProtocol()) && (uRI = URI.create(((URL)object2).toExternalForm())) != null) {
                    file = new File(uRI);
                }
                if (file != null) {
                    if (!bl2) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    bl2 = false;
                    file = FileUtil.normalizeFile((File)file);
                    stringBuffer.append(file.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("JavaScriptLibraryTypeProvider: Can not resolve URL: " + object2);
            }
            String string2 = editableProperties.getProperty(string);
            object2 = stringBuffer.toString();
            if (((String)object2).equals(string2)) continue;
            if (((String)object2).length() > 0) {
                editableProperties.setProperty(string, (String)object2);
                bl = true;
                continue;
            }
            if (string2 == null) continue;
            editableProperties.remove((Object)string);
            bl = true;
        }
        return bl;
    }
}

