/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.editor.model.HtmlTags;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CssRuleCreateActionDialog
extends JPanel {
    private JDialog dialog;
    private DialogDescriptor dlg = null;
    private static final String ELEMENT_TYPE = "elelment";
    private static final String CLASS_TYPE = "class";
    private static final String ELEMENT_ID_TYPE = "element_id";
    private static final String NONE = "<None>";
    DefaultListModel selectedRules = new DefaultListModel();
    private String styleRuleName = "";
    private JPanel addRemoveRulePanel;
    private JButton addRuleButton;
    private JComboBox classPrefixComboBox;
    private JLabel classPrefixSeparator;
    private JPanel hierarchyContainer;
    private JButton moveRuleDownButton;
    private JPanel moveRulePanel;
    private JButton moveRuleUpButton;
    private JLabel previewLable;
    private JPanel previewPanel;
    private JTextField previewTextField;
    private JButton removeRuleButton;
    private JList ruleHierarchyList;
    private JPanel ruleHierarchyPanel;
    private JScrollPane ruleHierarchyScroll;
    private JPanel rulePanel;
    private JRadioButton selectClassRadioButton;
    private JTextField selectClassTextField;
    private JRadioButton selectElelmentIdRadioButton;
    private JComboBox selectElementComboBox;
    private JTextField selectElementIdTextField;
    private JRadioButton selectElementRadioButton;
    private ButtonGroup selectRuleButtonGroup;
    private JPanel selectRulePanel;

    public CssRuleCreateActionDialog() {
        this.initComponents();
        String[] stringArray = HtmlTags.getTags();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(NONE);
        defaultComboBoxModel.addElement("a:link");
        defaultComboBoxModel.addElement("a:visited");
        defaultComboBoxModel.addElement("a:hover");
        defaultComboBoxModel.addElement("a:active");
        for (int i = 0; i < stringArray.length; ++i) {
            defaultComboBoxModel.addElement(stringArray[i]);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultComboBoxModel2.addElement(stringArray[i]);
        }
        this.selectElementComboBox.setModel(defaultComboBoxModel2);
        this.classPrefixComboBox.setModel(defaultComboBoxModel);
        this.ruleHierarchyList.setModel(this.selectedRules);
        this.removeRuleButton.setEnabled(false);
    }

    public void showDialog() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    CssRuleCreateActionDialog.this.styleRuleName = CssRuleCreateActionDialog.this.previewTextField.getText().trim();
                    if (CssRuleCreateActionDialog.this.styleRuleName.equals("")) {
                        String string = CssRuleCreateActionDialog.this.selectRuleButtonGroup.getSelection().getActionCommand();
                        CssRuleCreateActionDialog.this.styleRuleName = CssRuleCreateActionDialog.this.getRule(string);
                    }
                    CssRuleCreateActionDialog.this.dialog.setVisible(false);
                }
            }
        };
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"STYLE_RULE_EDITOR_TITLE"), true, actionListener);
        this.dlg.setHelpCtx(new HelpCtx("projrave_ui_elements_css_create_style_rule"));
        this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public String getStyleRuleName() {
        return this.styleRuleName;
    }

    private void initComponents() {
        this.selectRuleButtonGroup = new ButtonGroup();
        this.previewPanel = new JPanel();
        this.previewLable = new JLabel();
        this.previewTextField = new JTextField();
        this.rulePanel = new JPanel();
        this.addRemoveRulePanel = new JPanel();
        this.addRuleButton = new JButton();
        this.removeRuleButton = new JButton();
        this.selectRulePanel = new JPanel();
        this.selectElementRadioButton = new JRadioButton();
        this.selectElementComboBox = new JComboBox();
        this.selectClassRadioButton = new JRadioButton();
        this.selectClassTextField = new JTextField();
        this.selectElelmentIdRadioButton = new JRadioButton();
        this.selectElementIdTextField = new JTextField();
        this.classPrefixComboBox = new JComboBox();
        this.classPrefixSeparator = new JLabel();
        this.ruleHierarchyPanel = new JPanel();
        this.moveRulePanel = new JPanel();
        this.moveRuleUpButton = new JButton();
        this.moveRuleDownButton = new JButton();
        this.hierarchyContainer = new JPanel();
        this.ruleHierarchyScroll = new JScrollPane();
        this.ruleHierarchyList = new JList();
        this.setLayout(new BorderLayout());
        this.previewPanel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.previewPanel.setLayout(new BorderLayout(5, 5));
        this.previewLable.setLabelFor(this.previewTextField);
        Mnemonics.setLocalizedText((JLabel)this.previewLable, (String)NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"RULE_PREVIEW_LABEL"));
        this.previewPanel.add((Component)this.previewLable, "West");
        this.previewTextField.setEditable(false);
        this.previewPanel.add((Component)this.previewTextField, "Center");
        this.previewTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"PREVIEW_LABEL_ACCESSIBLE_DESC"));
        this.add((Component)this.previewPanel, "South");
        this.rulePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rulePanel.setLayout(new BorderLayout(3, 3));
        this.addRemoveRulePanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.addRemoveRulePanel.setLayout(new GridBagLayout());
        this.addRuleButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ADD_RULE_BUTTON_MNEMONIC").charAt(0));
        this.addRuleButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ADD_RULE_LBL"));
        this.addRuleButton.setToolTipText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ADD_RULE_TOOL_TIP"));
        this.addRuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.addRuleButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.addRemoveRulePanel.add((Component)this.addRuleButton, gridBagConstraints);
        this.removeRuleButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"REMOVE_RULE_BUTTON_MNEMONIC").charAt(0));
        this.removeRuleButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"REMOVE_RULE_LBL"));
        this.removeRuleButton.setToolTipText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"REMOVE_RULE_TOOL_TIP"));
        this.removeRuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.removeRuleButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.addRemoveRulePanel.add((Component)this.removeRuleButton, gridBagConstraints);
        this.rulePanel.add((Component)this.addRemoveRulePanel, "Center");
        this.selectRulePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"RULE_TYPE_PANEL_TITLE")));
        this.selectRulePanel.setLayout(new GridBagLayout());
        this.selectRuleButtonGroup.add(this.selectElementRadioButton);
        this.selectElementRadioButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ELEMENT_RULE_TYPE_MNEMONIC").charAt(0));
        this.selectElementRadioButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"HTML_ELELEMT"));
        this.selectElementRadioButton.setActionCommand(ELEMENT_TYPE);
        this.selectElementRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.selectRuleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.selectRulePanel.add((Component)this.selectElementRadioButton, gridBagConstraints);
        this.selectElementRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"HTML_ELEMENT_RULE_TYPE_ACCESSIBLE_DESCRIPTION"));
        this.selectElementComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"a", "abbr"}));
        this.selectElementComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        this.selectRulePanel.add((Component)this.selectElementComboBox, gridBagConstraints);
        this.selectElementComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"HTML_ELEMENT_ACCESSIBLE_NAME"));
        this.selectElementComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"HTML_ELEMENT_ACCESSIBLE_DESC"));
        this.selectRuleButtonGroup.add(this.selectClassRadioButton);
        this.selectClassRadioButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"CLASS_RULE_TYPE_MNEMONIC").charAt(0));
        this.selectClassRadioButton.setSelected(true);
        this.selectClassRadioButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"CLASS_NAME_LBL"));
        this.selectClassRadioButton.setActionCommand(CLASS_TYPE);
        this.selectClassRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.selectRuleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.selectRulePanel.add((Component)this.selectClassRadioButton, gridBagConstraints);
        this.selectClassRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"CLASS_RULE_TYPE_ACCESSIBLE_DESCRIPTION"));
        this.selectClassTextField.setColumns(15);
        this.selectClassTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CssRuleCreateActionDialog.this.selectClassTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 5, 5);
        this.selectRulePanel.add((Component)this.selectClassTextField, gridBagConstraints);
        this.selectClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"CLASS_TEXT_FIELD_ACCESSIBLE_NAME"));
        this.selectClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"CLASS_TEXT_FIELD_ACCESSIBLE_DESC"));
        this.selectRuleButtonGroup.add(this.selectElelmentIdRadioButton);
        this.selectElelmentIdRadioButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ELEMENT_ID_RULE_TYPE_MNEMONIC").charAt(0));
        this.selectElelmentIdRadioButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ELEMENT_ID_LBL"));
        this.selectElelmentIdRadioButton.setActionCommand(ELEMENT_ID_TYPE);
        this.selectElelmentIdRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.selectRuleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.selectRulePanel.add((Component)this.selectElelmentIdRadioButton, gridBagConstraints);
        this.selectElelmentIdRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ELEMENT_ID_RULE_TYPE_ACCESSIBLE_DESCRIPTION"));
        this.selectElementIdTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        this.selectRulePanel.add((Component)this.selectElementIdTextField, gridBagConstraints);
        this.selectElementIdTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ELEMENT_ID_TEXTFIELD_ACCESSIBLE_NAME"));
        this.selectElementIdTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"ELEMENT_ID_TEXTFIELD_ACCESSIBLE_DESC"));
        this.classPrefixComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"abbr"}));
        this.classPrefixComboBox.setToolTipText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"OPTIONAL_ELEMENT_TOOLTIP"));
        this.classPrefixComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 2);
        this.selectRulePanel.add((Component)this.classPrefixComboBox, gridBagConstraints);
        this.classPrefixComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"OPTIONAL_ELEMENT_ACCESSIBLE_DESC"));
        this.classPrefixSeparator.setFont(new Font("Dialog", 1, 18));
        this.classPrefixSeparator.setText(".");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.selectRulePanel.add((Component)this.classPrefixSeparator, gridBagConstraints);
        this.rulePanel.add((Component)this.selectRulePanel, "West");
        this.ruleHierarchyPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"RULE_HIERARCHY_TITLE")));
        this.ruleHierarchyPanel.setLayout(new BorderLayout(2, 2));
        this.moveRulePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.moveRulePanel.setLayout(new GridBagLayout());
        this.moveRuleUpButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"UP_RULE_BUTTON_MNEMONIC").charAt(0));
        this.moveRuleUpButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"MOVE_RULE_UP_LBL"));
        this.moveRuleUpButton.setToolTipText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"UP_RULE_BUTTON_TOOLTIP"));
        this.moveRuleUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.moveRuleUpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.moveRulePanel.add((Component)this.moveRuleUpButton, gridBagConstraints);
        this.moveRuleDownButton.setMnemonic(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"DOWN_RULE_BUTTON_MNEMONIC").charAt(0));
        this.moveRuleDownButton.setText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"MOVE_RULE_DOWN_LBL"));
        this.moveRuleDownButton.setToolTipText(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"DOWN_RULE_BUTTON_TOOLTIP"));
        this.moveRuleDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssRuleCreateActionDialog.this.moveRuleDownActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.moveRulePanel.add((Component)this.moveRuleDownButton, gridBagConstraints);
        this.ruleHierarchyPanel.add((Component)this.moveRulePanel, "East");
        this.hierarchyContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.hierarchyContainer.setLayout(new BorderLayout());
        this.ruleHierarchyScroll.setPreferredSize(new Dimension(150, 200));
        this.ruleHierarchyScroll.setViewportView(this.ruleHierarchyList);
        this.ruleHierarchyList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"STYLE_RULE_LIST_ACCESSIBLE_NAME"));
        this.ruleHierarchyList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CssRuleCreateActionDialog.class, (String)"STYLE_RULE_LIST_ACCESSIBLE_DESC"));
        this.hierarchyContainer.add((Component)this.ruleHierarchyScroll, "Center");
        this.ruleHierarchyPanel.add((Component)this.hierarchyContainer, "Center");
        this.rulePanel.add((Component)this.ruleHierarchyPanel, "East");
        this.add((Component)this.rulePanel, "Center");
    }

    private void selectClassTextFieldKeyTyped(KeyEvent keyEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!CssRuleCreateActionDialog.this.selectClassTextField.getText().equals("")) {
                    CssRuleCreateActionDialog.this.classPrefixComboBox.setEnabled(true);
                } else {
                    CssRuleCreateActionDialog.this.classPrefixComboBox.setEnabled(false);
                }
            }
        });
    }

    private void moveRuleDownActionPerformed(ActionEvent actionEvent) {
        int n = this.ruleHierarchyList.getSelectedIndex();
        if (n >= 0 && n < this.selectedRules.getSize()) {
            Object e = this.selectedRules.get(n);
            int n2 = n + 1;
            if (n2 < this.selectedRules.getSize()) {
                Object e2 = this.selectedRules.get(n2);
                this.selectedRules.setElementAt(e, n + 1);
                this.selectedRules.setElementAt(e2, n);
                this.ruleHierarchyList.setSelectedIndex(n + 1);
                this.resetRuleHierarchy();
            }
        }
    }

    private void moveRuleUpActionPerformed(ActionEvent actionEvent) {
        int n = this.ruleHierarchyList.getSelectedIndex();
        if (n > 0) {
            Object e = this.selectedRules.get(n);
            Object e2 = this.selectedRules.get(n - 1);
            this.selectedRules.setElementAt(e, n - 1);
            this.selectedRules.setElementAt(e2, n);
            this.ruleHierarchyList.setSelectedIndex(n - 1);
            this.resetRuleHierarchy();
        }
    }

    private void removeRuleButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.ruleHierarchyList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.selectedRules.contains(objectArray[i])) continue;
            this.selectedRules.removeElement(objectArray[i]);
        }
        if (!this.selectedRules.isEmpty()) {
            this.ruleHierarchyList.setSelectedIndex(0);
        } else {
            this.removeRuleButton.setEnabled(false);
        }
        this.resetRuleHierarchy();
    }

    private void selectRuleActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ELEMENT_TYPE)) {
            this.selectElementComboBox.setEnabled(true);
            this.classPrefixComboBox.setEnabled(false);
            this.selectClassTextField.setEnabled(false);
            this.selectElementIdTextField.setEnabled(false);
        } else if (string.equals(CLASS_TYPE)) {
            this.selectElementComboBox.setEnabled(false);
            this.classPrefixComboBox.setEnabled(true);
            this.selectClassTextField.setEnabled(true);
            this.selectElementIdTextField.setEnabled(false);
        } else if (string.equals(ELEMENT_ID_TYPE)) {
            this.selectElementComboBox.setEnabled(false);
            this.classPrefixComboBox.setEnabled(false);
            this.selectClassTextField.setEnabled(false);
            this.selectElementIdTextField.setEnabled(true);
        }
        this.resetRuleHierarchy();
    }

    private void addRuleButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.selectRuleButtonGroup.getSelection().getActionCommand();
        String string2 = null;
        if (string.equals(ELEMENT_TYPE)) {
            string2 = (String)this.selectElementComboBox.getSelectedItem();
            if (string2.equals(NONE)) {
                string2 = null;
            }
        } else if (string.equals(CLASS_TYPE)) {
            if (!this.selectClassTextField.getText().trim().equals("")) {
                String string3 = (String)this.classPrefixComboBox.getSelectedItem();
                string2 = "." + this.selectClassTextField.getText().trim();
                if (!string3.equals(NONE)) {
                    string2 = string3 + string2;
                }
            }
        } else if (string.equals(ELEMENT_ID_TYPE) && !this.selectElementIdTextField.getText().trim().equals("")) {
            string2 = "#" + this.selectElementIdTextField.getText().trim();
        }
        if (string2 != null && !this.selectedRules.contains(string2)) {
            this.selectedRules.addElement(string2);
            this.ruleHierarchyList.setSelectedValue(string2, true);
            this.removeRuleButton.setEnabled(true);
        }
        this.resetRuleHierarchy();
    }

    private String getRule(String string) {
        String string2 = null;
        if (string.equals(ELEMENT_TYPE)) {
            string2 = (String)this.selectElementComboBox.getSelectedItem();
            if (string2.equals(NONE)) {
                string2 = null;
            }
        } else if (string.equals(CLASS_TYPE)) {
            if (!this.selectClassTextField.getText().trim().equals("")) {
                String string3 = (String)this.classPrefixComboBox.getSelectedItem();
                string2 = "." + this.selectClassTextField.getText().trim();
                if (!string3.equals(NONE)) {
                    string2 = string3 + string2;
                }
            }
        } else if (string.equals(ELEMENT_ID_TYPE) && !this.selectElementIdTextField.getText().trim().equals("")) {
            string2 = "#" + this.selectElementIdTextField.getText().trim();
        }
        return string2;
    }

    private void resetRuleHierarchy() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.selectedRules.size(); ++i) {
            String string = ((String)this.selectedRules.get(i)).trim();
            stringBuffer.append(string);
            if (i >= this.selectedRules.size() - 1) continue;
            stringBuffer.append(" ");
        }
        this.previewTextField.setText(stringBuffer.toString());
    }
}

