/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterDeserializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.Versionable;
import org.netbeans.modules.vmd.api.model.common.DefaultVersionDescriptor;
import org.netbeans.modules.vmd.model.PresenterDeserializerSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLComponentDescriptor
extends ComponentDescriptor {
    public static final String COMPONENT_DESCRIPTOR_NODE = "ComponentDescriptor";
    public static final String VERSION_ATTR = "version";
    public static final String TYPE_NODE = "TypeDescriptor";
    public static final String SUPER_TYPEID_ATTR = "superTypeID";
    public static final String THIS_TYPEID_ATTR = "thisTypeID";
    public static final String CAN_INSTANTIATE_ATTR = "canInstantiate";
    public static final String CAN_DERIVE_ATTR = "canDerive";
    public static final String PALETTE_NODE = "PaletteDescriptor";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String TOOLTIP_ATTR = "toolTip";
    public static final String SMALL_ICON_ATTR = "smallIcon";
    public static final String LARGE_ICON_ATTR = "largeIcon";
    public static final String PREFERRED_CATEGORYID_ATTR = "preferredCategoryID";
    public static final String PROPERTY_DESCRIPTOR_NODE = "PropertyDescriptor";
    public static final String NAME_ATTR = "name";
    public static final String TYPEID_ATTR = "typeID";
    public static final String DEFAULT_VALUE_ATTR = "defaultValue";
    public static final String ALLOW_NULL = "allowNull";
    public static final String ALLOW_USER_CODE = "allowUserCode";
    public static final String USE_FOR_SERIALIZATION_ATTR = "useForSerialization";
    public static final String READ_ONLY_ATTR = "readOnly";
    public static final String PRESENTERS_NODE = "Presenters";
    public static final String VERSION_VALUE_1 = "1";
    private TypeDescriptor typeDescriptor;
    private PaletteDescriptor paletteDescriptor;
    private List<PropertyDescriptor> propertyDescriptors;
    private List<PresenterDeserializer.PresenterFactory> presenterDescriptors;

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public VersionDescriptor getVersionDescriptor() {
        return DefaultVersionDescriptor.createForeverCompatibleVersionDescriptor();
    }

    @Override
    public Collection<String> getExcludedPropertyDescriptorNames() {
        return Collections.emptySet();
    }

    @Override
    public List<PropertyDescriptor> getDeclaredPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public PaletteDescriptor getPaletteDescriptor() {
        return this.paletteDescriptor;
    }

    @Override
    protected List<? extends Presenter> createPresenters() {
        ArrayList<Presenter> arrayList = new ArrayList<Presenter>();
        for (PresenterDeserializer.PresenterFactory presenterFactory : this.presenterDescriptors) {
            List<Presenter> list = presenterFactory.createPresenters(this);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public boolean deserialize(String string, Document document) {
        Node node = document.getFirstChild();
        if (!COMPONENT_DESCRIPTOR_NODE.equals(node.getNodeName())) {
            Debug.warning("Invalid root node");
            return false;
        }
        String string2 = XMLComponentDescriptor.getAttributeValue(node, VERSION_ATTR);
        if (VERSION_VALUE_1.equals(string2)) {
            this.deserializeVersion1(string, node);
            return true;
        }
        Debug.warning("Invalid version", string2);
        return false;
    }

    private void deserializeVersion1(String string, Node node) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        ArrayList<PresenterDeserializer.PresenterFactory> arrayList2 = new ArrayList<PresenterDeserializer.PresenterFactory>();
        for (Node node2 : XMLComponentDescriptor.getChildNode(node)) {
            String string2;
            if (TYPE_NODE.equals(node2.getNodeName())) {
                string2 = XMLComponentDescriptor.getAttributeValue(node2, THIS_TYPEID_ATTR);
                if (string2 == null) {
                    Debug.warning("Missing thisTypeID attribute");
                    continue;
                }
                this.typeDescriptor = new TypeDescriptor(TypeID.createFrom(XMLComponentDescriptor.getAttributeValue(node2, SUPER_TYPEID_ATTR)), TypeID.createFrom(string2), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node2, CAN_INSTANTIATE_ATTR)), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node2, CAN_DERIVE_ATTR)));
                continue;
            }
            if (PALETTE_NODE.equals(node2.getNodeName())) {
                this.paletteDescriptor = new PaletteDescriptor(XMLComponentDescriptor.getAttributeValue(node2, PREFERRED_CATEGORYID_ATTR), XMLComponentDescriptor.getAttributeValue(node2, DISPLAY_NAME_ATTR), XMLComponentDescriptor.getAttributeValue(node2, TOOLTIP_ATTR), XMLComponentDescriptor.getAttributeValue(node2, SMALL_ICON_ATTR), XMLComponentDescriptor.getAttributeValue(node2, LARGE_ICON_ATTR));
                continue;
            }
            if (!PROPERTY_DESCRIPTOR_NODE.equals(node2.getNodeName())) continue;
            string2 = XMLComponentDescriptor.getAttributeValue(node2, NAME_ATTR);
            if (string2 == null) {
                Debug.warning("Missing name attribute");
                continue;
            }
            TypeID typeID = TypeID.createFrom(XMLComponentDescriptor.getAttributeValue(node2, TYPEID_ATTR));
            if (typeID == null) {
                Debug.warning("Missing typeID attribute", string2);
                continue;
            }
            String string3 = XMLComponentDescriptor.getAttributeValue(node2, DEFAULT_VALUE_ATTR);
            arrayList.add(new PropertyDescriptor(string2, typeID, string3 != null ? PropertyValue.createUserCode(string3) : PropertyValue.createNull(), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node2, ALLOW_NULL)), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node2, ALLOW_USER_CODE)), Versionable.FOREVER, Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node2, USE_FOR_SERIALIZATION_ATTR)), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node2, READ_ONLY_ATTR))));
        }
        this.deserializePresenters(node, string, arrayList2);
        this.propertyDescriptors = arrayList;
        this.presenterDescriptors = arrayList2;
    }

    private void deserializePresenters(Node node, String string, ArrayList<PresenterDeserializer.PresenterFactory> arrayList) {
        for (Node node2 : XMLComponentDescriptor.getChildNode(node)) {
            if (!PRESENTERS_NODE.equals(node2.getNodeName())) continue;
            for (Node node3 : XMLComponentDescriptor.getChildNode(node2)) {
                PresenterDeserializer.PresenterFactory presenterFactory = PresenterDeserializerSupport.deserialize(string, node3);
                if (presenterFactory == null) continue;
                arrayList.add(presenterFactory);
            }
        }
    }

    static String getAttributeValue(Node node, String string) {
        try {
            NamedNodeMap namedNodeMap;
            if (node != null && (namedNodeMap = node.getAttributes()) != null && (node = namedNodeMap.getNamedItem(string)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException dOMException) {
            Debug.warning(dOMException);
        }
        return null;
    }

    static Node[] getChildNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        Node[] nodeArray = new Node[nodeList != null ? nodeList.getLength() : 0];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = nodeList.item(i);
        }
        return nodeArray;
    }
}

