/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.earproject.EarActionProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final EarProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public EarProjectOperations(EarProject earProject) {
        this.project = earProject;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        EarProjectOperations.addFile(fileObject, "nbproject", arrayList);
        EarProjectOperations.addFile(fileObject, "build.xml", arrayList);
        EarProjectOperations.addFile(fileObject, "src", arrayList);
        EarProjectOperations.addFile(fileObject, ".cvsignore", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        File file;
        AntProjectHelper antProjectHelper = this.project.getAntProjectHelper();
        if (antProjectHelper.getLibrariesLocation() != null && (file = antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation())) != null && file.exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)file).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject)) {
                return Collections.singletonList(fileObject);
            }
        }
        return Collections.emptyList();
    }

    public void notifyDeleting() throws IOException {
        EarActionProvider earActionProvider = (EarActionProvider)this.project.getLookup().lookup(EarActionProvider.class);
        assert (earActionProvider != null);
        Lookup lookup = Lookups.fixed((Object[])new Object[0]);
        Properties properties = new Properties();
        String[] stringArray = earActionProvider.getTargetNames("clean", lookup, properties);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        EarProjectOperations earProjectOperations = (EarProjectOperations)project.getLookup().lookup(EarProjectOperations.class);
        this.fixLibraryLocation(earProjectOperations);
        this.project.setName(string);
    }

    public void notifyMoving() throws IOException {
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, final String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        EarProjectOperations earProjectOperations = (EarProjectOperations)project.getLookup().lookup(EarProjectOperations.class);
        this.fixLibraryLocation(earProjectOperations);
        final String string2 = this.project.getName();
        this.project.setName(string);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                AntProjectHelper antProjectHelper = EarProjectOperations.this.project.getAntProjectHelper();
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                String string3 = (String)editableProperties.get((Object)"jar.name");
                String string22 = string3.substring(0, string3.length() - 4);
                if (string3.endsWith(".ear") && string22.equals(string2)) {
                    editableProperties.put("jar.name", string + ".ear");
                }
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
            }
        });
    }

    private void fixLibraryLocation(EarProjectOperations earProjectOperations) throws IllegalArgumentException {
        String string = earProjectOperations.libraryPath;
        if (string != null) {
            if (!new File(string).isAbsolute()) {
                if (!earProjectOperations.libraryWithinProject) {
                    File file = earProjectOperations.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String string2 = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (string2 != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(string2);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (earProjectOperations.libraryWithinProject && earProjectOperations.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)earProjectOperations.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)file, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fileObject = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fileObject != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject);
                }
            }
        }
    }
}

