/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CustomizerProviderImpl
implements CustomizerProvider {
    private final EarProject project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private final AntBasedProjectType abpt;
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();
    public static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-j2ee-earproject/Customizer";

    public CustomizerProviderImpl(EarProject earProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, AntBasedProjectType antBasedProjectType) {
        this.project = earProject;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = referenceHelper;
        this.abpt = antBasedProjectType;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null);
    }

    public void showCustomizer(String string, String string2) {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        EarProjectProperties earProjectProperties = new EarProjectProperties(this.project, this.project.getUpdateHelper(), this.project.evaluator(), this.project.getReferenceHelper());
        Lookup lookup = Lookups.fixed((Object[])new Object[]{this.project, earProjectProperties, new SubCategoryProvider(string, string2)});
        OptionListener optionListener = new OptionListener(this.project, earProjectProperties);
        StoreListener storeListener = new StoreListener(earProjectProperties);
        dialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)lookup, (String)string, (ActionListener)optionListener, (ActionListener)storeListener, null);
        dialog.addWindowListener(optionListener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.setVisible(true);
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String string, String string2) {
            this.category = string;
            this.subcategory = string2;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private EarProjectProperties uiProperties;

        OptionListener(Project project, EarProjectProperties earProjectProperties) {
            this.project = project;
            this.uiProperties = earProjectProperties;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            project2Dialog.remove(this.project);
        }

        public void windowClosing(WindowEvent windowEvent) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private class StoreListener
    implements ActionListener {
        private EarProjectProperties uiProperties;

        StoreListener(EarProjectProperties earProjectProperties) {
            this.uiProperties = earProjectProperties;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.uiProperties.store();
        }
    }
}

