/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageEmbedding<T extends TokenId> {
    private final Language<T> language;
    private final int startSkipLength;
    private final int endSkipLength;
    private final boolean joinSections;

    public static <T extends TokenId> LanguageEmbedding<T> create(Language<T> language, int n, int n2) {
        return LanguageEmbedding.create(language, n, n2, false);
    }

    public static <T extends TokenId> LanguageEmbedding<T> create(Language<T> language, int n, int n2, boolean bl) {
        if (language == null) {
            throw new IllegalArgumentException("language may not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("startSkipLength=" + n + " < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("endSkipLength=" + n2 + " < 0");
        }
        LanguageOperation<T> languageOperation = LexerApiPackageAccessor.get().languageOperation(language);
        return languageOperation.getEmbedding(n, n2, bl);
    }

    LanguageEmbedding(Language<T> language, int n, int n2, boolean bl) {
        assert (language != null) : "Embedded language may not be null.";
        assert (n >= 0 && n2 >= 0);
        this.language = language;
        this.startSkipLength = n;
        this.endSkipLength = n2;
        this.joinSections = bl;
    }

    public Language<T> language() {
        return this.language;
    }

    public int startSkipLength() {
        return this.startSkipLength;
    }

    public int endSkipLength() {
        return this.endSkipLength;
    }

    public boolean joinSections() {
        return this.joinSections;
    }

    public String toString() {
        return "language: " + this.language() + ", skip[" + this.startSkipLength() + ", " + this.endSkipLength + "];" + (this.joinSections ? "join" : "no-join");
    }
}

