/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2ee.sun.share.SecurityMasterListModel;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.GroupTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.util.NbBundle;

public class SecurityAddGroupPanel
extends JPanel
implements ListSelectionListener {
    private final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final GroupTableModel groupModel;
    private Dimension initialPreferredSize;
    private String groupName;
    private JTable existingGroupsTable;
    private SecurityMasterListModel existingGroupsModel;
    private ButtonGroup buttonGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLblGroupName;
    private JLabel jLblRequiredMark;
    private JTextField jTxtGroupName;

    public SecurityAddGroupPanel(GroupTableModel groupTableModel) {
        this.groupModel = groupTableModel;
        this.groupName = null;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getGrouplName() {
        return this.groupName;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLblRequiredMark = new JLabel();
        this.jLblGroupName = new JLabel();
        this.jTxtGroupName = new JTextField();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.customizerBundle.getString("LBL_GroupEntryDesc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLblRequiredMark.setLabelFor(this.jTxtGroupName);
        this.jLblRequiredMark.setText("*");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 30, 0, 0);
        this.add((Component)this.jLblRequiredMark, gridBagConstraints);
        this.jLblGroupName.setLabelFor(this.jTxtGroupName);
        this.jLblGroupName.setText(this.customizerBundle.getString("LBL_GroupName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblGroupName, gridBagConstraints);
        this.jTxtGroupName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SecurityAddGroupPanel.this.jTxtGroupNameKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtGroupName, gridBagConstraints);
        this.jTxtGroupName.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_GroupName"));
        this.jTxtGroupName.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_GroupName"));
        this.jLabel2.setText(this.customizerBundle.getString("LBL_GroupTableDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void jTxtGroupNameKeyReleased(KeyEvent keyEvent) {
        this.groupName = this.jTxtGroupName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        this.initialPreferredSize = this.getPreferredSize();
        this.existingGroupsTable = new FixedHeightJTable();
        this.existingGroupsTable.setSelectionMode(0);
        this.existingGroupsTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.existingGroupsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 30, 11, 11);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_AddGroupName"));
        this.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_AddGroupName"));
    }

    private void initFields() {
        this.existingGroupsModel = SecurityMasterListModel.getGroupMasterModel();
        this.existingGroupsTable.setModel(this.existingGroupsModel);
        this.updateTextFields();
        this.setPreferredSize(new Dimension(this.initialPreferredSize.width, this.initialPreferredSize.height + 148));
    }

    private void updateTextFields() {
        this.jTxtGroupName.setText(this.groupName);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        int n;
        ListSelectionModel listSelectionModel = this.existingGroupsTable.getSelectionModel();
        if (!listSelectionModel.getValueIsAdjusting() && (n = this.existingGroupsTable.getSelectedRow()) != -1 && (object = this.existingGroupsModel.getRow(n)) instanceof String) {
            this.groupName = (String)object;
            this.updateTextFields();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    Collection getErrors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getGrouplName();
        if (!Utils.notEmpty(string)) {
            arrayList.add(this.customizerBundle.getString("ERR_BlankGroupName"));
        }
        if (string != null && this.groupModel.contains(string)) {
            arrayList.add(MessageFormat.format(this.customizerBundle.getString("ERR_GroupExists"), string));
        }
        return arrayList;
    }

    private void commit() {
        String string = this.getGrouplName();
        this.groupModel.addElement(string);
        if (!this.existingGroupsModel.contains(string)) {
            this.existingGroupsModel.addElement(string);
        }
    }

    static void addGroupName(JPanel jPanel, GroupTableModel groupTableModel) {
        SecurityAddGroupPanel securityAddGroupPanel = new SecurityAddGroupPanel(groupTableModel);
        securityAddGroupPanel.displayDialog(jPanel, NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle").getString("TITLE_AddGroup"), "AS_CFG_SecurityRoleNewGroup");
    }

    private void displayDialog(JPanel jPanel, String string, String string2) {
        BetterInputDialog betterInputDialog = new BetterInputDialog(jPanel, string, string2, this);
        do {
            int n = betterInputDialog.display();
            if (n == 0) break;
            if (n != 1) continue;
            Collection collection = this.getErrors();
            if (betterInputDialog.hasErrors()) {
                betterInputDialog.showErrors();
                continue;
            }
            this.commit();
        } while (betterInputDialog.hasErrors());
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityAddGroupPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel jPanel, String string, String string2, SecurityAddGroupPanel securityAddGroupPanel) {
            super(jPanel, string);
            this.dialogPanel = securityAddGroupPanel;
            this.panelHelpId = string2;
            this.dialogPanel.setPreferredSize(new Dimension(jPanel.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)securityAddGroupPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(jPanel);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.dialogPanel.getErrors());
            this.setErrors(arrayList);
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

