/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.core;

import java.util.List;
import org.netbeans.modules.xml.search.api.SearchException;
import org.netbeans.modules.xml.search.api.SearchOption;
import org.netbeans.modules.xml.search.api.SearchTarget;
import org.netbeans.modules.xml.search.spi.SearchEngine;
import org.netbeans.modules.xml.search.spi.SearchProvider;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;

public final class Engine
extends SearchEngine.Adapter {
    private SearchProvider myProvider;
    private Class<? extends Object> myClazz;

    public void search(SearchOption searchOption) throws SearchException {
        this.myProvider = searchOption.getProvider();
        SearchTarget searchTarget = searchOption.getTarget();
        this.myClazz = searchTarget == null ? null : searchTarget.getClazz();
        this.fireSearchStarted(searchOption);
        this.search(this.myProvider.getRoot(), "");
        this.fireSearchFinished(searchOption);
    }

    private void search(Object object, String string) {
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        this.process(component, string);
        List list = component.getChildren();
        for (Object e : list) {
            this.search(e, string + "    ");
        }
    }

    private void process(Component component, String string) {
        if (this.checkClazz(component) && this.checkName(component)) {
            this.fireSearchFound(this.myProvider.getElement(component));
        }
    }

    private boolean checkClazz(Object object) {
        if (this.myClazz == null) {
            return true;
        }
        return this.myClazz.isAssignableFrom(object.getClass());
    }

    private boolean checkName(Component component) {
        String string = "";
        if (component instanceof Named) {
            string = ((Named)component).getName();
        }
        return this.accepts(string);
    }

    public boolean isApplicable(Object object) {
        return object instanceof Component;
    }

    public String getDisplayName() {
        return UI.i18n(Engine.class, "LBL_Engine_Display_Name");
    }

    public String getShortDescription() {
        return UI.i18n(Engine.class, "LBL_Engine_Short_Description");
    }
}

