/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.output;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import org.netbeans.modules.xml.ui.UI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Wrapper
extends JPanel {
    private JTree myTree;
    private JTextField myTextField;
    private static final int TEXT_WIDTH = 60;

    Wrapper(JTree jTree) {
        this.myTree = jTree;
        this.myTree.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                int n = keyEvent.getModifiers();
                char c = keyEvent.getKeyChar();
                if (c == '\u001b') {
                    return;
                }
                if (c == '\u007f') {
                    return;
                }
                if (UI.isCtrl(n)) {
                    return;
                }
                if (UI.isAlt(n)) {
                    return;
                }
                keyEvent.consume();
                Wrapper.this.myTextField.setText(String.valueOf(c));
                Wrapper.this.showPanel();
            }
        });
        JLabel jLabel = new JLabel(" " + UI.i18n(Wrapper.class, "LBL_Quick_Search"));
        this.setLayout(new BoxLayout(this, 0));
        this.add(jLabel);
        this.myTextField = new JTextField(){

            public void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    Wrapper.this.hidePanel();
                    keyEvent.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Wrapper.this.myTree.requestFocus();
                        }
                    });
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        };
        UI.setWidth(this.myTextField, 60);
        this.setVisible(false);
        MultiListener multiListener = new MultiListener();
        this.myTextField.addKeyListener(multiListener);
        this.myTextField.addFocusListener(multiListener);
        this.myTextField.getDocument().addDocumentListener(multiListener);
        this.add(this.myTextField);
        jLabel.setLabelFor(this.myTextField);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
    }

    private void showPanel() {
        this.setVisible(true);
        this.myTextField.requestFocus();
    }

    private void hidePanel() {
        this.setVisible(false);
    }

    private List<TreePath> doSearch(String string) {
        TreePath treePath;
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        int[] nArray = this.myTree.getSelectionRows();
        int n = this.myTree.getRowCount();
        int n2 = nArray == null || nArray.length == 0 ? 0 : nArray[0];
        if (n == 0) {
            return linkedList;
        }
        while ((treePath = this.myTree.getNextMatch(string, n2 %= n, Position.Bias.Forward)) != null && !linkedList.contains(treePath)) {
            n2 = this.myTree.getRowForPath(treePath);
            linkedList.add(treePath);
            ++n2;
        }
        return linkedList;
    }

    private class MultiListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        private int myIndex;
        private List<TreePath> myResults = new LinkedList<TreePath>();

        public void changedUpdate(DocumentEvent documentEvent) {
            this.searchForNode();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.searchForNode();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.searchForNode();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 38) {
                --this.myIndex;
                this.showResult();
            } else if (n == 40) {
                ++this.myIndex;
                this.showResult();
            } else if (n == 27) {
                Wrapper.this.hidePanel();
                Wrapper.this.myTree.requestFocus();
            }
        }

        private void searchForNode() {
            this.myIndex = 0;
            this.myResults.clear();
            String string = Wrapper.this.myTextField.getText().toUpperCase();
            if (string.length() > 0) {
                this.myResults = Wrapper.this.doSearch(string);
                this.showResult();
            }
        }

        private void showResult() {
            int n = this.myResults.size();
            if (n > 0) {
                if (this.myIndex < 0) {
                    this.myIndex = n - 1;
                } else if (this.myIndex >= n) {
                    this.myIndex = 0;
                }
                TreePath treePath = this.myResults.get(this.myIndex);
                Wrapper.this.myTree.setSelectionPath(treePath);
                Wrapper.this.myTree.scrollPathToVisible(treePath);
            } else {
                Wrapper.this.myTree.clearSelection();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Wrapper.this.hidePanel();
        }
    }
}

