/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.xml.search.api.SearchException;
import org.netbeans.modules.xml.search.api.SearchMatch;
import org.netbeans.modules.xml.search.api.SearchOption;
import org.netbeans.modules.xml.search.api.SearchTarget;
import org.netbeans.modules.xml.search.impl.output.View;
import org.netbeans.modules.xml.search.impl.ui.Field;
import org.netbeans.modules.xml.search.impl.ui.Progress;
import org.netbeans.modules.xml.search.spi.SearchEngine;
import org.netbeans.modules.xml.search.spi.SearchProvider;
import org.netbeans.modules.xml.ui.UI;
import org.openide.DialogDescriptor;

public final class Search
extends UI.Dialog {
    private Field myName;
    private JButton mySearchButton;
    private JCheckBox myMatchCase;
    private JCheckBox myPatternMatch;
    private JCheckBox myRegularExpression;
    private UI.MyComboBox myTarget;
    private SearchProvider myProvider;
    private SearchTarget[] myTargets;
    private SearchEngine mySearchEngine;
    private DialogDescriptor myDescriptor;
    private static final int TEXT_WIDTH = 200;
    private static final String ASTERISK = "*";

    public void show(SearchEngine searchEngine, SearchProvider searchProvider) {
        if (searchEngine == null) {
            return;
        }
        this.myTargets = searchProvider.getTargets();
        this.myProvider = searchProvider;
        this.mySearchEngine = searchEngine;
        this.mySearchEngine.removeSearchListeners();
        this.mySearchEngine.addSearchListener(new View());
        this.mySearchEngine.addSearchListener(new Progress());
        this.show();
        UI.a11y(this.getUIComponent(), this.i18n("ACS_Advanced_Search"));
    }

    protected void updated() {
        UI.setItems(this.myTarget, this.myTargets);
        this.myTarget.init();
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this.createTextPanel(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)UI.createSeparator(this.i18n("LBL_Options")), gridBagConstraints);
        jPanel.add((Component)this.createOptionPanel(), gridBagConstraints);
        return jPanel;
    }

    private JComponent createTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        JLabel jLabel = UI.createLabel(this.i18n("LBL_Name"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.myName = new Field(ASTERISK);
        UI.setWidth(this.myName.getUIComponent(), 200);
        jLabel.setLabelFor(this.myName.getUIComponent());
        jPanel.add((Component)this.myName.getUIComponent(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        jLabel = UI.createLabel(this.i18n("LBL_Target"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.weightx = 1.0;
        this.myTarget = UI.createComboBox(this.myTargets);
        UI.a11y(this.myTarget, this.i18n("ACS_Target"));
        jLabel.setLabelFor(this.myTarget);
        jPanel.add((Component)this.myTarget, gridBagConstraints);
        return jPanel;
    }

    private JComponent createOptionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        this.myMatchCase = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Match_Case")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.myMatchCase, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.myPatternMatch = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Match_Pattern")){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.exclusion(Search.this.myPatternMatch, Search.this.myRegularExpression);
            }
        });
        this.myPatternMatch.setSelected(true);
        this.myPatternMatch.setEnabled(true);
        jPanel.add((Component)this.myPatternMatch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.myRegularExpression = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Regular_Expression")){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.exclusion(Search.this.myRegularExpression, Search.this.myPatternMatch);
            }
        });
        this.myRegularExpression.setSelected(false);
        this.myRegularExpression.setEnabled(false);
        jPanel.add((Component)this.myRegularExpression, gridBagConstraints);
        return jPanel;
    }

    private void exclusion(JCheckBox jCheckBox, JCheckBox jCheckBox2) {
        jCheckBox.setEnabled(!jCheckBox2.isSelected());
        if (jCheckBox2.isSelected()) {
            jCheckBox.setSelected(false);
        }
        jCheckBox2.setEnabled(!jCheckBox.isSelected());
        if (jCheckBox.isSelected()) {
            jCheckBox2.setSelected(false);
        }
    }

    private SearchMatch getMatch() {
        if (this.myPatternMatch.isSelected()) {
            return SearchMatch.PATTERN;
        }
        if (this.myRegularExpression.isSelected()) {
            return SearchMatch.REGULAR_EXPRESSION;
        }
        return null;
    }

    private void search() {
        this.myDescriptor.setClosingOptions(new Object[]{this.mySearchButton, DialogDescriptor.CANCEL_OPTION});
        SearchOption.Adapter adapter = new SearchOption.Adapter(this.myName.getText().trim(), this.myProvider, (SearchTarget)this.myTarget.getSelectedItem(), this.getMatch(), this.myMatchCase.isSelected(), false);
        try {
            this.mySearchEngine.search(adapter);
        }
        catch (SearchException searchException) {
            this.myDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            UI.printError(this.i18n("ERR_Pattern_Error", searchException.getMessage()));
        }
    }

    private void close() {
        this.myName.save();
        this.mySearchEngine = null;
        this.myProvider = null;
        this.myTargets = null;
    }

    protected DialogDescriptor createDescriptor() {
        Object[] objectArray = this.getButtons();
        this.myDescriptor = new DialogDescriptor((Object)UI.getResizable(this.createPanel()), this.i18n("LBL_Advanced_Search"), true, objectArray, (Object)this.mySearchButton, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Search.this.mySearchButton == actionEvent.getSource()) {
                    Search.this.search();
                    Search.this.close();
                }
            }
        });
        return this.myDescriptor;
    }

    private Object[] getButtons() {
        this.mySearchButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Search"), this.i18n("TLT_Search")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        return new Object[]{this.mySearchButton, DialogDescriptor.CANCEL_OPTION};
    }
}

