/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import javax.faces.context.ExternalContext;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.jsfsupport.container.RaveFacesContext;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.services.RefreshService;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class RefreshServiceImpl
extends RefreshService {
    public void refresh(Project project) {
        FacesModelSet facesModelSet = FacesModelSet.getInstance((Project)project);
        if (facesModelSet != null) {
            RaveFacesContext raveFacesContext = facesModelSet.getFacesContainer().getFacesContext();
            ExternalContext externalContext = raveFacesContext.getExternalContext();
            if ("1.5".equals(JsfProjectUtils.getJ2eePlatformVersion((Project)project))) {
                externalContext.getApplicationMap().remove("com.sun.webui.ThemeManager");
                externalContext.getSessionMap().remove("com.sun.webui.jsf.Theme");
            } else {
                externalContext.getApplicationMap().remove("com.sun.rave.web.ui.ThemeManager");
                externalContext.getSessionMap().remove("com.sun.rave.web.ui.Theme");
            }
        }
        RefreshServiceImpl.refreshProject(project, false);
    }

    static void refreshProject(Project project, boolean bl) {
        FileObject fileObject = JsfProjectUtils.getDocumentRoot((Project)project);
        RefreshServiceImpl.refreshFolder(fileObject, bl);
    }

    private static void refreshDataObject(DataObject dataObject, boolean bl) {
        JsfForm jsfForm = JsfForm.findJsfForm(dataObject);
        if (jsfForm != null) {
            jsfForm.refreshModel(bl);
        }
    }

    private static void refreshFolder(FileObject fileObject, boolean bl) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (fileObject2.isFolder()) {
                RefreshServiceImpl.refreshFolder(fileObject2, bl);
                continue;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                RefreshServiceImpl.refreshDataObject(dataObject, bl);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            }
        }
    }
}

