/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.palette;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.complib.api.ComplibEvent;
import org.netbeans.modules.visualweb.complib.api.ComplibListener;
import org.netbeans.modules.visualweb.complib.api.ComplibService;
import org.netbeans.modules.visualweb.designer.jsf.palette.JsfPaletteActions;
import org.netbeans.modules.visualweb.designer.jsf.palette.MergedPaletteActions;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class PaletteControllerFactory {
    private static final String PALETTE_DIRECTORY_1_4 = "CreatorDesignerPalette";
    private static final String PALETTE_DIRECTORY_5 = "CreatorDesignerPalette5";
    private static final PaletteControllerFactory INSTANCE = new PaletteControllerFactory();

    private PaletteControllerFactory() {
    }

    public static PaletteControllerFactory getDefault() {
        return INSTANCE;
    }

    public static PaletteController getJsfPaletteController_5() {
        return PaletteControllerFactory.getJsfPaletteController(PALETTE_DIRECTORY_5);
    }

    public static PaletteController getJsfPaletteController_1_4() {
        return PaletteControllerFactory.getJsfPaletteController(PALETTE_DIRECTORY_1_4);
    }

    private static PaletteController getJsfPaletteController(String string) {
        try {
            JsfPaletteActions jsfPaletteActions = new JsfPaletteActions(string);
            PaletteController paletteController = PaletteFactory.createPalette((String)string, (PaletteActions)jsfPaletteActions, null, null);
            return paletteController;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public PaletteController createJsfPaletteController(Project project) {
        if (project == null) {
            return null;
        }
        String string = "1.5".equals(JsfProjectUtils.getJ2eePlatformVersion((Project)project)) ? PALETTE_DIRECTORY_5 : PALETTE_DIRECTORY_1_4;
        try {
            PaletteActions paletteActions;
            PaletteFilter paletteFilter;
            ComplibService complibService = PaletteControllerFactory.getComplibService();
            if (complibService == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("There is no ComplibService available!"));
                paletteFilter = null;
                paletteActions = null;
            } else {
                paletteFilter = complibService.createComplibPaletteFilter(project);
                JsfPaletteActions jsfPaletteActions = new JsfPaletteActions(string);
                PaletteActions paletteActions2 = complibService.createComplibPaletteActions();
                paletteActions = paletteActions2 != null ? new MergedPaletteActions(jsfPaletteActions, paletteActions2) : jsfPaletteActions;
            }
            PaletteController paletteController = PaletteFactory.createPalette((String)string, (PaletteActions)paletteActions, (PaletteFilter)paletteFilter, null);
            JsfComplibListener.getDefault().install();
            JsfComplibListener.getDefault().setPaletteController(paletteController);
            return paletteController;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            PaletteController paletteController = null;
            return paletteController;
        }
    }

    private static ComplibService getComplibService() {
        return (ComplibService)Lookup.getDefault().lookup(ComplibService.class);
    }

    private static class JsfComplibListener
    implements ComplibListener {
        private static JsfComplibListener INSTANCE = new JsfComplibListener();
        private WeakReference<PaletteController> paletteControllerWRef = new WeakReference<Object>(null);
        private boolean installed;

        private JsfComplibListener() {
        }

        public static JsfComplibListener getDefault() {
            return INSTANCE;
        }

        public void install() {
            if (this.installed) {
                return;
            }
            ComplibService complibService = PaletteControllerFactory.getComplibService();
            if (complibService == null) {
                return;
            }
            complibService.addComplibListener((ComplibListener)this);
            this.installed = true;
        }

        public void uninstall() {
            ComplibService complibService = PaletteControllerFactory.getComplibService();
            if (complibService == null) {
                return;
            }
            complibService.removeComplibListener((ComplibListener)this);
            this.installed = false;
        }

        public void setPaletteController(PaletteController paletteController) {
            this.paletteControllerWRef = new WeakReference<PaletteController>(paletteController);
        }

        public void paletteChanged(ComplibEvent complibEvent) {
            PaletteController paletteController = (PaletteController)this.paletteControllerWRef.get();
            if (paletteController == null) {
                return;
            }
            paletteController.refresh();
        }
    }
}

