/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public class JBPluginProperties {
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_DEPLOY_DIR = "deploy-dir";
    public static final String PROPERTY_SERVER_DIR = "server-dir";
    public static final String PROPERTY_ROOT_DIR = "root-dir";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_JAVA_OPTS = "java_opts";
    private static JBPluginProperties pluginProperties = null;
    private String installLocation;
    private String domainLocation;
    private static final String INSTALL_ROOT_KEY = "installRoot";
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private FileObject propertiesFile = null;

    public static JBPluginProperties getInstance() {
        if (pluginProperties == null) {
            pluginProperties = new JBPluginProperties();
        }
        return pluginProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JBPluginProperties() {
        InputStream inputStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inputStream = this.propertiesFile.getInputStream();
                }
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
                {
                    catch (Throwable throwable) {
                        this.loadPluginProperties(inputStream);
                        if (null == inputStream) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                return;
            }
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
    }

    void loadPluginProperties(InputStream inputStream) {
        String string;
        Properties properties = new Properties();
        if (null != inputStream) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        if ((string = properties.getProperty(INSTALL_ROOT_KEY)) != null) {
            this.setInstallLocation(string);
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("J2EE");
        FileObject fileObject2 = null;
        if (null != fileObject && null == (fileObject2 = fileObject.getFileObject("jb", "properties"))) {
            fileObject2 = fileObject.createData("jb", "properties");
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        block11: {
            Properties properties = new Properties();
            String string = this.getInstallLocation();
            if (string != null) {
                properties.setProperty(INSTALL_ROOT_KEY, string);
            }
            FileLock fileLock = null;
            OutputStream outputStream = null;
            try {
                if (null == this.propertiesFile) break block11;
                try {
                    fileLock = this.propertiesFile.lock();
                    outputStream = this.propertiesFile.getOutputStream(fileLock);
                    if (null != outputStream) {
                        properties.store(outputStream, "");
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                }
                finally {
                    if (null != outputStream) {
                        outputStream.close();
                    }
                    if (null != fileLock) {
                        fileLock.releaseLock();
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
    }

    public boolean isCurrentServerLocationValid() {
        if (this.getInstallLocation() != null) {
            return JBPluginUtils.isGoodJBServerLocation(new File(this.getInstallLocation()));
        }
        return false;
    }

    public void setInstallLocation(String string) {
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        this.installLocation = string;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public void setDomainLocation(String string) {
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        this.domainLocation = string;
    }

    public String getDomainLocation() {
        return this.domainLocation;
    }
}

