/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTargetImpl;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class Deployment {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(Deployment.class.getName());
    private static boolean alsoStartTargets = true;
    private static Deployment instance = null;

    public static synchronized Deployment getDefault() {
        if (instance == null) {
            instance = new Deployment();
        }
        return instance;
    }

    private Deployment() {
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, String string, String string2, boolean bl2) throws DeploymentException {
        return this.deploy(j2eeModuleProvider, bl, string, string2, bl2, null);
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, String string, String string2, boolean bl2, Logger logger) throws DeploymentException {
        DeploymentTargetImpl deploymentTargetImpl = new DeploymentTargetImpl(j2eeModuleProvider, string);
        TargetModuleID[] targetModuleIDArray = null;
        J2eeModule j2eeModule = deploymentTargetImpl.getModule();
        String string3 = NbBundle.getMessage(Deployment.class, (String)"LBL_Deploying", (Object)j2eeModuleProvider.getDeploymentName());
        ProgressUI progressUI = new ProgressUI(string3, false, logger);
        try {
            Object object;
            ServerTarget[] serverTargetArray;
            JDBCDriverDeployer jDBCDriverDeployer;
            progressUI.start();
            ServerString serverString = deploymentTargetImpl.getServer();
            if (j2eeModule == null) {
                String string4 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(string4);
            }
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = serverString.getServerInstance();
            if (serverString == null || serverInstance == null) {
                String string5 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(string5);
            }
            Set<Datasource> set = j2eeModuleProvider.getModuleDatasources();
            if (set != null && set.size() > 0 && (jDBCDriverDeployer = serverString.getServerInstance().getJDBCDriverDeployer()) != null && (serverTargetArray = serverInstance.getTargets()).length > 0 && jDBCDriverDeployer.supportsDeployJDBCDrivers((Target)(object = serverTargetArray[0].getTarget()))) {
                ProgressObject progressObject = jDBCDriverDeployer.deployJDBCDrivers((Target)object, set);
                ProgressObjectUtil.trackProgressObject(progressUI, progressObject, Long.MAX_VALUE);
            }
            boolean bl3 = false;
            serverTargetArray = new TargetServer(deploymentTargetImpl);
            if (alsoStartTargets || bl) {
                serverTargetArray.startTargets(bl, progressUI);
            } else {
                serverString.getServerInstance().start(progressUI);
            }
            j2eeModuleProvider.deployDatasources();
            Deployment.deployMessageDestinations(j2eeModuleProvider);
            targetModuleIDArray = serverTargetArray.deploy(progressUI, bl2);
            serverTargetArray.notifyIncrementalDeployment(targetModuleIDArray);
            if (serverTargetArray.supportsDeployOnSave((TargetModule[])targetModuleIDArray)) {
                DeployOnSaveManager.getDefault().notifyInitialDeployment(j2eeModuleProvider);
            }
            if (targetModuleIDArray == null || targetModuleIDArray.length <= 0) {
                object = NbBundle.getMessage(Deployment.class, (String)"MSG_ModuleNotDeployed");
                throw new DeploymentException((String)object);
            }
            deploymentTargetImpl.setTargetModules((TargetModule[])targetModuleIDArray);
            object = deploymentTargetImpl.getClientUrl(string2);
            return object;
        }
        catch (ServerException serverException) {
            String string6 = NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)serverException.getLocalizedMessage());
            java.util.logging.Logger.getLogger("global").log(Level.INFO, null, serverException);
            if (null != serverException.getCause()) {
                throw new DeploymentException(string6, serverException);
            }
            throw new DeploymentException(string6);
        }
        catch (DeploymentException deploymentException) {
            throw deploymentException;
        }
        catch (Exception exception) {
            String string7 = NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)exception.getLocalizedMessage());
            LOGGER.log(Level.INFO, null, exception);
            throw new DeploymentException(string7, exception);
        }
        finally {
            if (progressUI != null) {
                progressUI.finish();
            }
        }
    }

    public void undeploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, Logger logger) throws DeploymentException {
        DeploymentTargetImpl deploymentTargetImpl = new DeploymentTargetImpl(j2eeModuleProvider, null);
        J2eeModule j2eeModule = deploymentTargetImpl.getModule();
        String string = NbBundle.getMessage(Deployment.class, (String)"LBL_Undeploying", (Object)j2eeModuleProvider.getDeploymentName());
        ProgressUI progressUI = new ProgressUI(string, false, logger);
        try {
            progressUI.start();
            ServerString serverString = deploymentTargetImpl.getServer();
            if (j2eeModule == null) {
                String string2 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(string2);
            }
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = serverString.getServerInstance();
            if (serverString == null || serverInstance == null) {
                String string3 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(string3);
            }
            TargetServer targetServer = new TargetServer(deploymentTargetImpl);
            targetServer.undeploy(progressUI, bl);
        }
        catch (Exception exception) {
            String string4 = NbBundle.getMessage(Deployment.class, (String)"MSG_UndeployFailed", (Object)exception.getLocalizedMessage());
            LOGGER.log(Level.INFO, null, exception);
            throw new DeploymentException(string4, exception);
        }
        finally {
            if (progressUI != null) {
                progressUI.finish();
            }
        }
    }

    public void enableCompileOnSaveSupport(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager.getDefault().startListening(j2eeModuleProvider);
    }

    public void disableCompileOnSaveSupport(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager.getDefault().stopListening(j2eeModuleProvider);
    }

    private static void deployMessageDestinations(J2eeModuleProvider j2eeModuleProvider) throws ConfigurationException {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(j2eeModuleProvider.getServerInstanceID());
        if (serverInstance != null) {
            serverInstance.deployMessageDestinations(j2eeModuleProvider.getConfigSupport().getMessageDestinations());
        } else {
            java.util.logging.Logger.getLogger("global").log(Level.WARNING, "The message destinations cannot be deployed because the server instance cannot be found.");
        }
    }

    public String[] getServerInstanceIDs() {
        return InstanceProperties.getInstanceList();
    }

    public String[] getServerInstanceIDs(Object[] objectArray) {
        return this.getServerInstanceIDs(objectArray, null, null);
    }

    public String[] getServerInstanceIDs(Object[] objectArray, String string) {
        return this.getServerInstanceIDs(objectArray, string, null);
    }

    public String[] getServerInstanceIDs(Object[] objectArray, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getServerInstanceIDs();
        for (int i = 0; i < stringArray2.length; ++i) {
            Set set;
            J2eePlatform j2eePlatform = this.getJ2eePlatform(stringArray2[i]);
            if (j2eePlatform == null) continue;
            boolean bl = true;
            if (objectArray != null) {
                set = j2eePlatform.getSupportedModuleTypes();
                for (int j = 0; j < objectArray.length; ++j) {
                    if (set.contains(objectArray[j])) continue;
                    bl = false;
                }
            }
            if (bl && string != null) {
                set = j2eePlatform.getSupportedSpecVersions();
                bl = string.equals("1.3") ? set.contains("1.3") || set.contains("1.4") : set.contains(string);
            }
            if (bl && stringArray != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j2eePlatform.isToolSupported(stringArray[j])) continue;
                    bl = false;
                }
            }
            if (!bl) continue;
            arrayList.add(stringArray2[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getServerInstanceDisplayName(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance != null) {
            return serverInstance.getDisplayName();
        }
        return null;
    }

    public String getServerID(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance != null) {
            return serverInstance.getServer().getShortName();
        }
        return null;
    }

    public String getDefaultServerInstanceID() {
        return null;
    }

    public boolean canFileDeploy(String string, J2eeModule j2eeModule) {
        boolean bl = false;
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (null != serverInstance) {
            IncrementalDeployment incrementalDeployment = serverInstance.getIncrementalDeployment();
            try {
                if (null != incrementalDeployment && null != j2eeModule.getContentDirectory()) {
                    bl = incrementalDeployment.canFileDeploy(null, j2eeModule);
                }
            }
            catch (IOException iOException) {
                java.util.logging.Logger.getLogger("global").log(Level.FINER, "", iOException);
            }
        }
        return bl;
    }

    public String[] getInstancesOfServer(String string) {
        Server server;
        if (string != null && (server = ServerRegistry.getInstance().getServer(string)) != null) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance[] serverInstanceArray = ServerRegistry.getInstance().getServer(string).getInstances();
            String[] stringArray = new String[serverInstanceArray.length];
            for (int i = 0; i < serverInstanceArray.length; ++i) {
                stringArray[i] = serverInstanceArray[i].getUrl();
            }
            return stringArray;
        }
        return new String[0];
    }

    public ServerInstance getServerInstance(String string) {
        Parameters.notNull((CharSequence)"serverInstanceId", (Object)string);
        return new ServerInstance(string);
    }

    public String[] getServerIDs() {
        Collection<Server> collection = ServerRegistry.getInstance().getServers();
        String[] stringArray = new String[collection.size()];
        Iterator<Server> iterator = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            Server server = iterator.next();
            stringArray[i] = server.getShortName();
        }
        return stringArray;
    }

    public J2eePlatform getJ2eePlatform(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return null;
        }
        return J2eePlatform.create(serverInstance);
    }

    public String getServerDisplayName(String string) {
        Server server = ServerRegistry.getInstance().getServer(string);
        if (server == null) {
            return null;
        }
        return server.getDisplayName();
    }

    public boolean isRunning(String string) {
        Parameters.notNull((CharSequence)"serverInstanceID", (Object)string);
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return false;
        }
        return serverInstance.isReallyRunning() || serverInstance.isSuspended();
    }

    public final void addInstanceListener(InstanceListener instanceListener) {
        ServerRegistry.getInstance().addInstanceListener(instanceListener);
    }

    public final void removeInstanceListener(InstanceListener instanceListener) {
        ServerRegistry.getInstance().removeInstanceListener(instanceListener);
    }

    public static interface Logger {
        public void log(String var1);
    }

    public static final class DeploymentException
    extends Exception {
        private DeploymentException(String string) {
            super(string);
        }

        private DeploymentException(Throwable throwable) {
            super(throwable);
        }

        private DeploymentException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public String toString() {
            String string = this.getClass().getName();
            String string2 = this.getLocalizedMessage();
            return string2 != null ? string2 : string;
        }
    }
}

