/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.awt.Image;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RefreshAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RestartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StopAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class UISupport {
    private static final WeakHashMap ioWeakMap = new WeakHashMap();

    private UISupport() {
    }

    public static Image getIcon(ServerIcon serverIcon) {
        switch (serverIcon) {
            case EJB_ARCHIVE: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ejb.png");
            }
            case WAR_ARCHIVE: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/war.png");
            }
            case EAR_ARCHIVE: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ear.png");
            }
        }
        return UISupport.computeIcon(serverIcon);
    }

    private static Image computeIcon(ServerIcon serverIcon) {
        Image image;
        Node node = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        Image image2 = serverIcon == ServerIcon.EJB_OPENED_FOLDER || serverIcon == ServerIcon.WAR_OPENED_FOLDER || serverIcon == ServerIcon.EAR_OPENED_FOLDER ? node.getOpenedIcon(1) : node.getIcon(1);
        if (serverIcon == ServerIcon.EJB_FOLDER || serverIcon == ServerIcon.EJB_OPENED_FOLDER) {
            image = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ejbBadge.png");
        } else if (serverIcon == ServerIcon.WAR_FOLDER || serverIcon == ServerIcon.WAR_OPENED_FOLDER) {
            image = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/warBadge.png");
        } else if (serverIcon == ServerIcon.EAR_FOLDER || serverIcon == ServerIcon.EAR_OPENED_FOLDER) {
            image = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/earBadge.png");
        } else {
            return null;
        }
        return ImageUtilities.mergeImages((Image)image2, (Image)image, (int)7, (int)7);
    }

    public static InputOutput getServerIO(String string) {
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return null;
        }
        InputOutput inputOutput = (InputOutput)ioWeakMap.get(serverInstance);
        if (inputOutput != null) {
            return inputOutput;
        }
        Action[] actionArray = new Action[]{new StartAction.OutputAction(serverInstance), new DebugAction.OutputAction(serverInstance), new RestartAction.OutputAction(serverInstance), new StopAction.OutputAction(serverInstance), new RefreshAction.OutputAction(serverInstance)};
        InputOutput inputOutput2 = IOProvider.getDefault().getIO(serverInstance.getDisplayName(), actionArray);
        ioWeakMap.put(serverInstance, inputOutput2);
        return inputOutput2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerIcon {
        EJB_ARCHIVE,
        WAR_ARCHIVE,
        EAR_ARCHIVE,
        EJB_FOLDER,
        EAR_FOLDER,
        WAR_FOLDER,
        EJB_OPENED_FOLDER,
        EAR_OPENED_FOLDER,
        WAR_OPENED_FOLDER;

    }
}

