/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.EOFException;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.file.DefaultFileHandler;
import org.netbeans.lib.cvsclient.file.FileDetails;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.GzippedFileHandler;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.GzipFileContentsRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.UnconfiguredRequestException;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.request.ValidResponsesRequest;
import org.netbeans.lib.cvsclient.request.WrapperSendRequest;
import org.netbeans.lib.cvsclient.response.ErrorMessageResponse;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseFactory;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.DefaultIgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.IgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.netbeans.lib.cvsclient.util.Logger;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class Client
implements ClientServices,
ResponseServices {
    private Connection connection;
    private FileHandler transmitFileHandler;
    private FileHandler gzipFileHandler = new GzippedFileHandler();
    private FileHandler uncompFileHandler = new DefaultFileHandler();
    private boolean dontUseGzipFileHandler;
    private Date modifiedDate;
    private AdminHandler adminHandler;
    private String localPath;
    private boolean isFirstCommand = true;
    private final EventManager eventManager = new EventManager(this);
    private GlobalOptions globalOptions;
    private PrintStream stderr = System.err;
    private boolean abort;
    private ResponseFactory responseFactory;
    private IgnoreFileFilter ignoreFileFilter;
    private Map validRequests = new HashMap();
    private Map wrappersMap = null;
    private boolean initialRequestsSent = false;
    private boolean printConnectionReuseWarning = false;
    private static final Set ALLOWED_CONNECTION_REUSE_REQUESTS;
    private LoggedDataInputStream loggedDataInputStream;
    private LoggedDataOutputStream loggedDataOutputStream;
    private boolean warned;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Client(Connection connection, AdminHandler adminHandler) {
        this.setConnection(connection);
        this.setAdminHandler(adminHandler);
        this.ignoreFileFilter = new DefaultIgnoreFileFilter();
        this.dontUseGzipFileHandler = false;
    }

    public void setErrorStream(PrintStream printStream) {
        this.stderr = printStream;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.initialRequestsSent = false;
        this.setIsFirstCommand(true);
    }

    public AdminHandler getAdminHandler() {
        return this.adminHandler;
    }

    public void setAdminHandler(AdminHandler adminHandler) {
        this.adminHandler = adminHandler;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String string) {
        string = string.replace('\\', '/');
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.localPath = string;
    }

    public boolean isFirstCommand() {
        return this.isFirstCommand;
    }

    public void setIsFirstCommand(boolean bl) {
        this.isFirstCommand = bl;
    }

    public FileHandler getUncompressedFileHandler() {
        return this.uncompFileHandler;
    }

    public void setUncompressedFileHandler(FileHandler fileHandler) {
        this.uncompFileHandler = fileHandler;
    }

    public FileHandler getGzipFileHandler() {
        return this.gzipFileHandler;
    }

    public void setGzipFileHandler(FileHandler fileHandler) {
        this.gzipFileHandler = fileHandler;
    }

    public void dontUseGzipFileHandler() {
        this.setGzipFileHandler(new DefaultFileHandler());
        this.dontUseGzipFileHandler = true;
    }

    public boolean isAborted() {
        return this.abort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ensureConnection() throws AuthenticationException {
        BugLog.getInstance().assertNotNull(this.getConnection());
        if (this.getConnection().isOpen()) {
            return;
        }
        final Throwable[] throwableArray = new Throwable[1];
        final boolean[] blArray = new boolean[]{false};
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    Client.this.getConnection().open();
                    boolean[] blArray2 = blArray;
                    synchronized (blArray) {
                        blArray[0] = true;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Throwable[] throwableArray2 = throwableArray;
                    synchronized (throwableArray) {
                        throwableArray[0] = throwable;
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                        return;
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "CVS Server Probe");
        thread.start();
        try {
            thread.join(60000L);
            Throwable[] throwableArray2 = throwableArray;
            synchronized (throwableArray) {
                Throwable throwable = throwableArray[0];
                // ** MonitorExit[var6_5] (shouldn't be in output)
                if (throwable != null) {
                    if (throwable instanceof CommandAbortedException) {
                        this.abort();
                        return;
                    }
                    if (throwable instanceof AuthenticationException) {
                        throw (AuthenticationException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)throwable);
                    }
                }
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    boolean bl = blArray[0];
                    // ** MonitorExit[var7_10] (shouldn't be in output)
                    if (bl) return;
                    thread.interrupt();
                    throw new AuthenticationException("Timeout, no response from server.", "Timeout, no response from server.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
            this.abort();
        }
    }

    public void processRequests(List list) throws IOException, UnconfiguredRequestException, ResponseException, CommandAbortedException {
        Object object;
        Object object2;
        Object object3;
        int n;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("[processRequests] requests was either null or empty.");
        }
        if (this.abort) {
            throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
        }
        this.loggedDataInputStream = null;
        this.loggedDataOutputStream = null;
        boolean bl = true;
        if (this.isFirstCommand()) {
            this.setIsFirstCommand(false);
            n = 0;
            if (!this.initialRequestsSent) {
                n = this.fillInitialRequests(list);
                this.initialRequestsSent = true;
                bl = false;
            }
            if (this.globalOptions != null) {
                Iterator iterator = this.globalOptions.createRequestList().iterator();
                while (iterator.hasNext()) {
                    object3 = (Request)iterator.next();
                    list.add(n++, object3);
                }
                if (this.globalOptions.isUseGzip() && this.globalOptions.getCompressionLevel() != 0) {
                    list.add(n++, new GzipFileContentsRequest(this.globalOptions.getCompressionLevel()));
                }
            }
        } else if (this.printConnectionReuseWarning && System.getProperty("javacvs.multiple_commands_warning") == null) {
            System.err.println("WARNING TO DEVELOPERS:");
            System.err.println("Please be warned that attempting to reuse one open connection for more commands is not supported by cvs servers very well.");
            System.err.println("You are advised to open a new Connection each time.");
            System.err.println("If you still want to proceed, please do: System.setProperty(\"javacvs.multiple_commands_warning\", \"false\")");
            System.err.println("That will disable this message.");
        }
        if (!ALLOWED_CONNECTION_REUSE_REQUESTS.contains(list.get(list.size() - 1).getClass())) {
            this.printConnectionReuseWarning = true;
        }
        n = this.getEventManager().isFireEnhancedEventSet() ? 1 : 0;
        int n2 = 0;
        if (n != 0) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Request)object3.next();
                object = ((Request)object2).getFileForTransmission();
                if (object == null || !((FileDetails)object).getFile().exists()) continue;
                ++n2;
            }
            object3 = new EnhancedMessageEvent((Object)this, "Requests_Count", new Integer(n2));
            this.getEventManager().fireCVSEvent((CVSEvent)object3);
        }
        this.loggedDataOutputStream = object3 = this.connection.getOutputStream();
        object2 = new LinkedList();
        this.transmitFileHandler = this.getUncompressedFileHandler();
        object = list.iterator();
        while (object.hasNext()) {
            Object object4;
            Object object5;
            if (this.abort) {
                throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
            }
            Request request = (Request)object.next();
            if (request instanceof GzipFileContentsRequest && this.dontUseGzipFileHandler) {
                this.stderr.println("Warning: The server is not supporting gzip-file-contents request, no compression is used.");
                continue;
            }
            if (request instanceof RootRequest) {
                if (bl) continue;
                bl = true;
            }
            String string = request.getRequestString();
            ((LoggedDataOutputStream)object3).writeBytes(string);
            request.modifyOutputStream(this.connection);
            if (request.modifiesInputStream()) {
                object2.add(request);
            }
            object3 = this.connection.getOutputStream();
            FileDetails fileDetails = request.getFileForTransmission();
            if (fileDetails != null && ((File)(object5 = fileDetails.getFile())).exists()) {
                Logger.logOutput(new String("<Sending file: " + ((File)object5).getAbsolutePath() + ">\n").getBytes("utf8"));
                if (n != 0) {
                    object4 = new EnhancedMessageEvent((Object)this, "File_Sent_To_Server", object5);
                    this.getEventManager().fireCVSEvent((CVSEvent)object4);
                    --n2;
                }
                if (fileDetails.isBinary()) {
                    this.transmitFileHandler.transmitBinaryFile((File)object5, (LoggedDataOutputStream)object3);
                } else {
                    this.transmitFileHandler.transmitTextFile((File)object5, (LoggedDataOutputStream)object3);
                }
                if (n != 0 && n2 == 0) {
                    object4 = new EnhancedMessageEvent((Object)this, "All_Requests_Were_Sent", "Ok");
                    this.getEventManager().fireCVSEvent((CVSEvent)object4);
                }
            }
            if (!request.isResponseExpected()) continue;
            ((FilterOutputStream)object3).flush();
            object5 = object2.iterator();
            while (object5.hasNext()) {
                System.err.println("Modifying the inputstream...");
                object4 = (Request)object5.next();
                System.err.println("Request is a: " + object4.getClass().getName());
                ((Request)object4).modifyInputStream(this.connection);
            }
            object2.clear();
            this.handleResponse();
        }
        ((FilterOutputStream)object3).flush();
        this.transmitFileHandler = null;
    }

    private ResponseFactory getResponseFactory() {
        if (this.responseFactory == null) {
            this.responseFactory = new ResponseFactory();
        }
        return this.responseFactory;
    }

    private void handleResponse() throws ResponseException, CommandAbortedException {
        try {
            CharSequence charSequence;
            LoggedDataInputStream loggedDataInputStream;
            this.loggedDataInputStream = loggedDataInputStream = this.connection.getInputStream();
            int n = -1;
            try {
                n = loggedDataInputStream.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                this.abort();
            }
            while (!this.abort && n != -1) {
                charSequence = new StringBuffer();
                while (n != -1 && (char)n != '\n' && (char)n != ' ') {
                    ((StringBuffer)charSequence).append((char)n);
                    try {
                        n = loggedDataInputStream.read();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.abort();
                        break;
                    }
                }
                String string = ((StringBuffer)charSequence).toString();
                Response response = this.getResponseFactory().createResponse(string);
                response.process(loggedDataInputStream, this);
                boolean bl = response.isTerminalResponse();
                if (bl && response instanceof ErrorMessageResponse) {
                    ErrorMessageResponse errorMessageResponse = (ErrorMessageResponse)response;
                    String string2 = errorMessageResponse.getMessage();
                    throw new CommandAbortedException(string2, string2);
                }
                if (bl || this.abort) break;
                try {
                    n = loggedDataInputStream.read();
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.abort();
                    break;
                }
            }
            if (this.abort) {
                charSequence = CommandException.getLocalMessage("Client.commandAborted", null);
                throw new CommandAbortedException("Aborted during request processing", (String)charSequence);
            }
        }
        catch (EOFException eOFException) {
            throw new ResponseException(eOFException, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(Command command, GlobalOptions globalOptions) throws CommandException, CommandAbortedException, AuthenticationException {
        BugLog.getInstance().assertNotNull(command);
        BugLog.getInstance().assertNotNull(globalOptions);
        this.globalOptions = globalOptions;
        this.getUncompressedFileHandler().setGlobalOptions(globalOptions);
        this.getGzipFileHandler().setGlobalOptions(globalOptions);
        try {
            this.eventManager.addCVSListener(command);
            command.execute(this, this.eventManager);
        }
        finally {
            this.eventManager.removeCVSListener(command);
        }
        return !command.hasFailed();
    }

    public long getCounter() {
        long l = 0L;
        if (this.loggedDataInputStream != null) {
            l += this.loggedDataInputStream.getCounter();
        }
        if (this.loggedDataOutputStream != null) {
            l += this.loggedDataOutputStream.getCounter();
        }
        return l;
    }

    public String convertPathname(String string, String string2) {
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(n + 1);
        if (string.startsWith("./")) {
            string = string.substring(1);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return this.getLocalPath() + '/' + string + string3;
    }

    public String getRepository() {
        return this.connection.getRepository();
    }

    public void updateAdminData(String string, String string2, Entry entry) throws IOException {
        String string3 = this.localPath + '/' + string;
        if (string2.startsWith(this.getRepository())) {
            string2 = string2.substring(this.getRepository().length() + 1);
        } else if (!this.warned) {
            String string4 = "#65188 warning C/S protocol error (section 5.10). It's regurarly observed with cvs 1.12.xx servers.\n";
            string4 = string4 + "  unexpected pathname=" + string2 + " missing root prefix=" + this.getRepository() + "\n";
            string4 = string4 + "  relaxing, but who knows all consequences....";
            System.err.println(string4);
            this.warned = true;
        }
        this.adminHandler.updateAdminData(string3, string2, entry, this.globalOptions);
    }

    public void setNextFileDate(Date date) {
        this.modifiedDate = date;
    }

    public Date getNextFileDate() {
        Date date = this.modifiedDate;
        this.modifiedDate = null;
        return date;
    }

    public Entry getEntry(File file) throws IOException {
        return this.adminHandler.getEntry(file);
    }

    public Iterator getEntries(File file) throws IOException {
        return this.adminHandler.getEntries(file);
    }

    public boolean exists(File file) {
        return this.adminHandler.exists(file);
    }

    public String getRepositoryForDirectory(String string) throws IOException {
        try {
            String string2 = this.adminHandler.getRepositoryForDirectory(string, this.getRepository());
            return string2;
        }
        catch (IOException iOException) {
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            string = string.replace('\\', '/');
            while (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String string3 = this.getLocalPath();
            try {
                string3 = new File(this.getLocalPath()).getCanonicalPath();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            string3 = string3.replace('\\', '/');
            while (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            int n = string3.length();
            String string4 = string.length() >= n ? this.getRepository() + string.substring(n) : this.getRepository();
            return string4;
        }
    }

    public String getRepositoryForDirectory(File file) throws IOException {
        return this.adminHandler.getRepositoryForDirectory(file.getAbsolutePath(), this.getRepository());
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.adminHandler.setEntry(file, entry);
    }

    public void removeEntry(File file) throws IOException {
        this.adminHandler.removeEntry(file);
    }

    public void removeLocalFile(String string) throws IOException {
        this.transmitFileHandler.removeLocalFile(string);
    }

    public void removeLocalFile(String string, String string2) throws IOException {
        int n = string2.lastIndexOf(47);
        if (n <= 0) {
            return;
        }
        String string3 = string2.substring(n + 1);
        String string4 = string + string3;
        File file = new File(this.getLocalPath(), string4);
        this.removeLocalFile(file.getAbsolutePath());
        this.removeEntry(file);
    }

    public void copyLocalFile(String string, String string2) throws IOException {
        this.transmitFileHandler.copyLocalFile(string, string2);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public GlobalOptions getGlobalOptions() {
        return this.globalOptions;
    }

    public synchronized void abort() {
        this.abort = true;
    }

    public Set getAllFiles(File file) throws IOException {
        return this.adminHandler.getAllFiles(file);
    }

    public void setIgnoreFileFilter(IgnoreFileFilter ignoreFileFilter) {
        this.ignoreFileFilter = ignoreFileFilter;
    }

    public IgnoreFileFilter getIgnoreFileFilter() {
        return this.ignoreFileFilter;
    }

    public boolean shouldBeIgnored(File file, String string) {
        if (this.ignoreFileFilter != null) {
            return this.ignoreFileFilter.shouldBeIgnored(file, string);
        }
        return false;
    }

    public String getStickyTagForDirectory(File file) {
        return this.adminHandler.getStickyTagForDirectory(file);
    }

    public void setValidRequests(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.validRequests.put(string2, this);
        }
    }

    private int fillInitialRequests(List list) {
        int n = 0;
        list.add(n++, new RootRequest(this.getRepository()));
        list.add(n++, new UseUnchangedRequest());
        list.add(n++, new ValidRequestsRequest());
        list.add(n++, new ValidResponsesRequest());
        return n;
    }

    public void addWrapper(StringPattern stringPattern, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (this.wrappersMap == null) {
            throw new IllegalArgumentException("This method should be called by WrapperSendResponse only.");
        }
        this.wrappersMap.put(stringPattern, keywordSubstitutionOptions);
    }

    public Map getWrappersMap() throws CommandException {
        if (this.wrappersMap == null) {
            this.wrappersMap = new HashMap();
            ArrayList<WrapperSendRequest> arrayList = new ArrayList<WrapperSendRequest>();
            arrayList.add(new WrapperSendRequest());
            boolean bl = this.isFirstCommand();
            try {
                this.processRequests(arrayList);
            }
            catch (Exception exception) {
                throw new CommandException(exception, "An error during obtaining server wrappers.");
            }
            finally {
                this.setIsFirstCommand(bl);
            }
            this.wrappersMap = Collections.unmodifiableMap(this.wrappersMap);
        }
        return this.wrappersMap;
    }

    static {
        $assertionsDisabled = !Client.class.desiredAssertionStatus();
        ALLOWED_CONNECTION_REUSE_REQUESTS = new HashSet<Class>(Arrays.asList(ExpandModulesRequest.class, WrapperSendRequest.class));
    }

    public static interface Factory {
        public Client createClient();
    }
}

