/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private static final String ANT_NAME = "platform.ant.name";
    private static final String J2SE = "j2se";
    private final PropertyEvaluator evaluator;
    private JavaPlatformManager platformManager;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List<PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private long eventId;

    public BootClassPathImplementation(PropertyEvaluator propertyEvaluator) {
        assert (propertyEvaluator != null);
        this.evaluator = propertyEvaluator;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        Object object;
        long l;
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            if (this.resourcesCache != null) {
                return this.resourcesCache;
            }
            l = this.eventId;
        }
        bootClassPathImplementation = this.findActivePlatform();
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        if (bootClassPathImplementation != null) {
            object = bootClassPathImplementation.getBootstrapLibraries();
            assert (object != null) : bootClassPathImplementation;
            for (ClassPath.Entry entry : object.entries()) {
                arrayList.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
        }
        object = this;
        synchronized (object) {
            if (l == this.eventId) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(arrayList);
                }
                return this.resourcesCache;
            }
            return Collections.unmodifiableList(arrayList);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private JavaPlatform findActivePlatform() {
        if (this.platformManager == null) {
            this.platformManager = JavaPlatformManager.getDefault();
            this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
        }
        this.activePlatformName = this.evaluator.getProperty(PLATFORM_ACTIVE);
        JavaPlatform javaPlatform = J2SEProjectUtil.getActivePlatform(this.activePlatformName);
        this.isActivePlatformValid = javaPlatform != null;
        return javaPlatform;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.evaluator && propertyChangeEvent.getPropertyName().equals(PLATFORM_ACTIVE)) {
            this.resetCache();
        } else if (propertyChangeEvent.getSource() == this.platformManager && "installedPlatforms".equals(propertyChangeEvent.getPropertyName()) && this.activePlatformName != null) {
            if (this.isActivePlatformValid) {
                if (J2SEProjectUtil.getActivePlatform(this.activePlatformName) == null) {
                    this.resetCache();
                }
            } else if (J2SEProjectUtil.getActivePlatform(this.activePlatformName) != null) {
                this.resetCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
            ++this.eventId;
        }
        this.support.firePropertyChange("resources", null, null);
    }
}

