/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.j2seproject.classpath.J2SEProjectClassPathModifier;
import org.netbeans.modules.java.j2seproject.ui.ActionFilterNode;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.J2SELogicalViewProvider;
import org.netbeans.modules.java.j2seproject.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.j2seproject.ui.PlatformNode;
import org.netbeans.modules.java.j2seproject.ui.ProjectNode;
import org.netbeans.modules.java.j2seproject.ui.customizer.AntArtifactChooser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class LibrariesNode
extends AbstractNode {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final Image ICON_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/libraries-badge.png");
    static final RequestProcessor rp = new RequestProcessor();
    private static Image folderIconCache;
    private static Image openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;

    LibrariesNode(String string, Project project, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string2, String[] stringArray, String string3, Action[] actionArray) {
        super((Children)new LibrariesChildren(project, propertyEvaluator, updateHelper, referenceHelper, string2, stringArray, string3), Lookups.singleton((Object)project));
        this.displayName = string;
        this.librariesNodeActions = actionArray;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public Action[] getActions(boolean bl) {
        return this.librariesNodeActions;
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(J2SEProject j2SEProject, boolean bl) {
        if (bl) {
            return new AddProjectAction(j2SEProject, j2SEProject.getSourceRoots());
        }
        return new AddProjectAction(j2SEProject, j2SEProject.getTestSourceRoots());
    }

    public static Action createAddLibraryAction(J2SEProject j2SEProject, boolean bl) {
        if (bl) {
            return new AddLibraryAction(j2SEProject, j2SEProject.getSourceRoots());
        }
        return new AddLibraryAction(j2SEProject, j2SEProject.getTestSourceRoots());
    }

    public static Action createAddFolderAction(J2SEProject j2SEProject, boolean bl) {
        if (bl) {
            return new AddFolderAction(j2SEProject, j2SEProject.getSourceRoots());
        }
        return new AddFolderAction(j2SEProject, j2SEProject.getTestSourceRoots());
    }

    static synchronized Image getFolderIcon(boolean bl) {
        if (bl) {
            if (openedFolderIconCache == null) {
                openedFolderIconCache = LibrariesNode.getTreeFolderIcon(bl);
            }
            return openedFolderIconCache;
        }
        if (folderIconCache == null) {
            folderIconCache = LibrariesNode.getTreeFolderIcon(bl);
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean bl, int n) {
        Image image = LibrariesNode.getFolderIcon(bl);
        image = ImageUtilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    private static Image getTreeFolderIcon(boolean bl) {
        Image image;
        Node node = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        Image image2 = image = bl ? node.getOpenedIcon(1) : node.getIcon(1);
        assert (image != null);
        return image;
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class AddFolderAction
    extends AbstractAction {
        private final J2SEProject project;
        private final SourceRoots projectSourcesArtifact;

        public AddFolderAction(J2SEProject j2SEProject, SourceRoots sourceRoots) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddFolder_Action"));
            assert (j2SEProject != null);
            assert (sourceRoots != null);
            this.project = j2SEProject;
            this.projectSourcesArtifact = sourceRoots;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassPathProviderImpl classPathProviderImpl = this.project.getClassPathProvider();
            assert (classPathProviderImpl != null);
            J2SEProjectClassPathModifier j2SEProjectClassPathModifier = this.project.getProjectClassPathModifier();
            assert (j2SEProjectClassPathModifier != null);
            FileChooser fileChooser = this.project.getAntProjectHelper().isSharableProject() ? new FileChooser(this.project.getAntProjectHelper(), true) : new FileChooser(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), null);
            fileChooser.enableVariableBasedSelection(true);
            fileChooser.setFileHidingEnabled(false);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
            fileChooser.setFileSelectionMode(2);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddJar_DialogTitle"));
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter((FileFilter)simpleFileFilter);
            File file = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
            fileChooser.setCurrentDirectory(file);
            int n = fileChooser.showOpenDialog((Component)WindowManager.getDefault().getMainWindow());
            if (n == 0) {
                String[] stringArray;
                try {
                    stringArray = fileChooser.getSelectedPaths();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
                String string = classPathProviderImpl.getPropertyName(this.projectSourcesArtifact, "classpath/compile");
                this.addJarFiles(stringArray, fileChooser.getSelectedPathVariables(), simpleFileFilter, FileUtil.toFile((FileObject)this.project.getProjectDirectory()), j2SEProjectClassPathModifier, string);
                file = FileUtil.normalizeFile((File)fileChooser.getCurrentDirectory());
                FoldersListSettings.getDefault().setLastUsedClassPathFolder(file);
            }
        }

        private void addJarFiles(String[] stringArray, String[] stringArray2, FileFilter fileFilter, File file, J2SEProjectClassPathModifier j2SEProjectClassPathModifier, String string) {
            assert (stringArray != null);
            assert (fileFilter != null);
            assert (j2SEProjectClassPathModifier != null);
            assert (string != null);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    URI uRI;
                    File file2 = PropertyUtils.resolveFile((File)file, (String)stringArray[i]);
                    FileObject fileObject = FileUtil.toFileObject((File)file2);
                    assert (fileObject != null) : file2;
                    if (fileObject == null || !fileFilter.accept(file2)) continue;
                    boolean bl = FileUtil.isArchiveFile((FileObject)fileObject);
                    if (stringArray2 == null) {
                        uRI = LibrariesSupport.convertFilePathToURI((String)stringArray[i]);
                    } else {
                        try {
                            String string2 = stringArray2[i];
                            if (!bl && !string2.endsWith("/")) {
                                string2 = string2 + "/";
                            }
                            uRI = new URI(null, null, string2, null);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                            uRI = LibrariesSupport.convertFilePathToURI((String)stringArray[i]);
                        }
                    }
                    if (bl) {
                        uRI = LibrariesSupport.getArchiveRoot((URI)uRI);
                    } else if (!uRI.toString().endsWith("/")) {
                        try {
                            uRI = new URI(uRI.toString() + "/");
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new AssertionError((Object)uRISyntaxException);
                        }
                    }
                    j2SEProjectClassPathModifier.handleRoots(new URI[]{uRI}, string, 1, false);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }

    private static class AddLibraryAction
    extends AbstractAction {
        private final J2SEProject project;
        private final SourceRoots projectSourcesArtifact;

        public AddLibraryAction(J2SEProject j2SEProject, SourceRoots sourceRoots) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddLibrary_Action"));
            assert (j2SEProject != null);
            assert (sourceRoots != null);
            this.project = j2SEProject;
            this.projectSourcesArtifact = sourceRoots;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassPathProviderImpl classPathProviderImpl = this.project.getClassPathProvider();
            assert (classPathProviderImpl != null);
            J2SEProjectClassPathModifier j2SEProjectClassPathModifier = this.project.getProjectClassPathModifier();
            assert (j2SEProjectClassPathModifier != null);
            Set set = LibraryChooser.showDialog((LibraryManager)this.project.getReferenceHelper().getProjectLibraryManager(), (LibraryChooser.Filter)new LibraryChooser.Filter(){

                public boolean accept(Library library) {
                    return "j2se".equals(library.getType());
                }
            }, (LibraryChooser.LibraryImportHandler)this.project.getReferenceHelper().getLibraryChooserImportHandler());
            if (set != null) {
                String string = classPathProviderImpl.getPropertyName(this.projectSourcesArtifact, "classpath/compile");
                this.addLibraries(set.toArray(new Library[set.size()]), j2SEProjectClassPathModifier, string);
            }
        }

        private void addLibraries(Library[] libraryArray, J2SEProjectClassPathModifier j2SEProjectClassPathModifier, String string) {
            assert (libraryArray != null);
            assert (j2SEProjectClassPathModifier != null);
            assert (string != null);
            for (int i = 0; i < libraryArray.length; ++i) {
                try {
                    j2SEProjectClassPathModifier.handleLibraries(new Library[]{libraryArray[i]}, string, 1);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }

    private static class AddProjectAction
    extends AbstractAction {
        private final J2SEProject project;
        private final SourceRoots projectSourcesArtifact;

        public AddProjectAction(J2SEProject j2SEProject, SourceRoots sourceRoots) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddProject_Action"));
            assert (j2SEProject != null);
            assert (sourceRoots != null);
            this.project = j2SEProject;
            this.projectSourcesArtifact = sourceRoots;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassPathProviderImpl classPathProviderImpl = this.project.getClassPathProvider();
            assert (classPathProviderImpl != null);
            J2SEProjectClassPathModifier j2SEProjectClassPathModifier = (J2SEProjectClassPathModifier)((Object)this.project.getLookup().lookup(J2SEProjectClassPathModifier.class));
            assert (j2SEProjectClassPathModifier != null);
            AntArtifactChooser.ArtifactItem[] artifactItemArray = AntArtifactChooser.showDialog(new String[]{"jar", "folder"}, this.project, null);
            if (artifactItemArray != null) {
                String string = classPathProviderImpl.getPropertyName(this.projectSourcesArtifact, "classpath/compile");
                this.addArtifacts(artifactItemArray, j2SEProjectClassPathModifier, string);
            }
        }

        private void addArtifacts(AntArtifactChooser.ArtifactItem[] artifactItemArray, J2SEProjectClassPathModifier j2SEProjectClassPathModifier, String string) {
            assert (artifactItemArray != null);
            assert (j2SEProjectClassPathModifier != null);
            assert (string != null);
            for (int i = 0; i < artifactItemArray.length; ++i) {
                try {
                    j2SEProjectClassPathModifier.handleAntArtifacts(new AntArtifact[]{artifactItemArray[i].getArtifact()}, new URI[]{artifactItemArray[i].getArtifactURI()}, string, 1);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }

    private static class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_PROJECT = 2;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;

        Key() {
            this.type = 0;
        }

        Key(SourceGroup sourceGroup, String string, String string2) {
            this.type = 1;
            this.sg = sourceGroup;
            this.classPathId = string;
            this.entryId = string2;
        }

        Key(AntArtifact antArtifact, URI uRI, String string, String string2) {
            this.type = 2;
            this.antArtifact = antArtifact;
            this.uri = uRI;
            this.classPathId = string;
            this.entryId = string2;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public int hashCode() {
            int n = this.type << 16;
            switch (this.type) {
                case 1: {
                    n ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 2: {
                    n ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (key.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return (this.sg == null ? key.sg == null : this.sg.equals(key.sg)) && (this.classPathId == null ? key.classPathId == null : this.classPathId.equals(key.classPathId)) && (this.entryId == null ? key.entryId == null : this.entryId.equals(key.entryId));
                }
                case 2: {
                    return (this.antArtifact == null ? key.antArtifact == null : this.antArtifact.equals(key.antArtifact)) && (this.classPathId == null ? key.classPathId == null : this.classPathId.equals(key.classPathId)) && (this.entryId == null ? key.entryId == null : this.entryId.equals(key.entryId));
                }
                case 0: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class LibrariesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/jar.gif";
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathProperty;
        private final String platformProperty;
        private final Set classPathIgnoreRef;
        private ClassPath fsListener;

        LibrariesChildren(Project project, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string, String[] stringArray, String string2) {
            this.project = project;
            this.eval = propertyEvaluator;
            this.helper = updateHelper;
            this.refHelper = referenceHelper;
            this.classPathProperty = string;
            this.classPathIgnoreRef = new HashSet<String>(Arrays.asList(stringArray));
            this.platformProperty = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            final boolean bl = "roots".equals(string);
            if (this.classPathProperty.equals(string) || bl || "libraries".equals(string)) {
                LibrariesChildren librariesChildren = this;
                synchronized (librariesChildren) {
                    if (this.fsListener != null) {
                        this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                rp.post(new Runnable(){

                    public void run() {
                        J2SELogicalViewProvider j2SELogicalViewProvider;
                        LibrariesChildren.this.setKeys(LibrariesChildren.this.getKeys());
                        if (bl && (j2SELogicalViewProvider = (J2SELogicalViewProvider)LibrariesChildren.this.project.getLookup().lookup(J2SELogicalViewProvider.class)) != null) {
                            j2SELogicalViewProvider.testBroken();
                        }
                    }
                });
            }
        }

        protected void addNotify() {
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                LibraryManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            this.eval.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().removePropertyChangeListener((PropertyChangeListener)this);
            } else {
                LibraryManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray = null;
            if (object instanceof Key) {
                Key key = (Key)object;
                switch (key.getType()) {
                    case 0: {
                        nodeArray = new Node[]{PlatformNode.create(this.eval, this.platformProperty)};
                        break;
                    }
                    case 2: {
                        nodeArray = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, this.refHelper, key.getClassPathId(), key.getEntryId())};
                        break;
                    }
                    case 1: {
                        nodeArray = new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)key.getSourceGroup()), this.helper, this.refHelper, key.getClassPathId(), key.getEntryId())};
                    }
                }
            }
            if (nodeArray == null) {
                assert (false) : "Unknown key type";
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getKeys() {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            EditableProperties editableProperties2 = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties editableProperties3 = PropertyUtils.getGlobalProperties();
            ArrayList arrayList = new ArrayList();
            List list = this.getKeys(editableProperties, editableProperties2, editableProperties3, this.classPathProperty, arrayList);
            FileObject fileObject = this.helper.getAntProjectHelper().getProjectDirectory();
            if (this.platformProperty != null && fileObject != null && fileObject.isValid() && !fileObject.isVirtual()) {
                list.add(new Key());
            }
            ClassPath classPath = ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
            classPath.addPropertyChangeListener((PropertyChangeListener)this);
            classPath.getRoots();
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = classPath;
            }
            return list;
        }

        private List getKeys(EditableProperties editableProperties, EditableProperties editableProperties2, EditableProperties editableProperties3, String string, List list) {
            ArrayList<Key> arrayList = new ArrayList<Key>();
            String string2 = editableProperties.getProperty(string);
            if (string2 == null) {
                string2 = editableProperties2.getProperty(string);
            }
            if (string2 == null) {
                string2 = editableProperties3.getProperty(string);
            }
            if (string2 == null) {
                return arrayList;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)string2)));
            while (arrayList2.size() > 0) {
                Object object;
                Object object2;
                Object object3;
                String string3 = (String)arrayList2.remove(0);
                String string4 = org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport.getAntPropertyName(string3);
                if (this.classPathIgnoreRef.contains(string4)) continue;
                if (string3.startsWith(LIBRARY_PREFIX)) {
                    object3 = string3.substring(LIBRARY_PREFIX.length(), string3.lastIndexOf(46));
                    object2 = this.refHelper.findLibrary((String)object3);
                    if (object2 == null) continue;
                    object = object2.getContent("classpath");
                    ImageIcon imageIcon = new ImageIcon(ImageUtilities.loadImage((String)LIBRARIES_ICON));
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string5;
                        Object object4;
                        URL uRL = (URL)iterator.next();
                        list.add(uRL);
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        if (fileObject == null) continue;
                        if ("jar".equals(uRL.getProtocol())) {
                            object4 = FileUtil.getArchiveFile((FileObject)fileObject);
                            string5 = object4.getNameExt();
                        } else {
                            object4 = FileUtil.toFile((FileObject)fileObject);
                            string5 = object4 != null ? ((File)object4).getAbsolutePath() : fileObject.getNameExt();
                        }
                        string5 = MessageFormat.format(NbBundle.getMessage(LibrariesNode.class, (String)"TXT_LibraryPartFormat"), object2.getDisplayName(), string5);
                        object4 = new LibrariesSourceGroup(fileObject, string5, imageIcon, imageIcon);
                        arrayList.add(new Key((SourceGroup)object4, string, string4));
                    }
                    continue;
                }
                if (string3.startsWith(ANT_ARTIFACT_PREFIX)) {
                    object3 = this.refHelper.findArtifactAndLocation(string3);
                    if (object3[0] == null || object3[1] == null) continue;
                    object2 = (AntArtifact)object3[0];
                    object = (URI)object3[1];
                    arrayList.add(new Key((AntArtifact)object2, (URI)object, string, string4));
                    continue;
                }
                if (string3.startsWith(FILE_REF_PREFIX)) {
                    object3 = this.eval.getProperty(string4);
                    if (object3 == null || (object = LibrariesChildren.createFileSourceGroup((File)(object2 = this.helper.getAntProjectHelper().resolveFile((String)object3)), list)) == null) continue;
                    arrayList.add(new Key((SourceGroup)object, string, string4));
                    continue;
                }
                if (string3.startsWith(REF_PREFIX)) {
                    arrayList.addAll(this.getKeys(editableProperties, editableProperties2, editableProperties3, string4, list));
                    continue;
                }
                object3 = this.helper.getAntProjectHelper().resolveFile(string3);
                object2 = LibrariesChildren.createFileSourceGroup((File)object3, list);
                if (object2 == null) continue;
                arrayList.add(new Key((SourceGroup)object2, string, string4));
            }
            return arrayList;
        }

        private static SourceGroup createFileSourceGroup(File file, List list) {
            try {
                String string;
                String string2;
                ImageIcon imageIcon;
                ImageIcon imageIcon2;
                URL uRL = file.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    imageIcon = imageIcon2 = new ImageIcon(ImageUtilities.loadImage((String)ARCHIVE_ICON));
                    string2 = file.getName();
                } else {
                    string = uRL.toExternalForm();
                    if (!string.endsWith("/")) {
                        uRL = new URL(string + "/");
                    }
                    imageIcon = new ImageIcon(LibrariesNode.getFolderIcon(false));
                    imageIcon2 = new ImageIcon(LibrariesNode.getFolderIcon(true));
                    string2 = file.getAbsolutePath();
                }
                list.add(uRL);
                string = URLMapper.findFileObject((URL)uRL);
                if (string != null) {
                    return new LibrariesSourceGroup((FileObject)string, string2, imageIcon, imageIcon2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
            return null;
        }
    }
}

