/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxrs.glassfish.v2;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishV2JaxRsStack
implements WSStackImplementation<JaxRs> {
    private static final String ASM_31_JAR = "lib/asm-3.1.jar";
    private static final String JERSEY_BUNDLE_10_JAR = "lib/jersey-bundle-1.0.jar";
    private static final String JETTISON_10_JAR = "lib/jettison-1.0.1.jar";
    private static final String JSR311_API_JAR = "lib/jsr311-api-1.0.jar";
    private File root;
    private JaxRs jaxRs;

    public GlassFishV2JaxRsStack(File file) {
        this.root = file;
        this.jaxRs = new JaxRs();
    }

    public JaxRs get() {
        return this.jaxRs;
    }

    public WSStackVersion getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (tool == JaxRs.Tool.JAXRS) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxRsTool(JaxRs.Tool.JAXRS));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature != JaxRs.Feature.JAXRS) return false;
        WSTool wSTool = this.getWSTool(JaxRs.Tool.JAXRS);
        if (wSTool == null) return false;
        URL[] uRLArray = wSTool.getLibraries();
        try {
            for (URL uRL : uRLArray) {
                if (new File(uRL.toURI()).exists()) continue;
                return false;
            }
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private class JaxRsTool
    implements WSToolImplementation {
        JaxRs.Tool tool;

        JaxRsTool(JaxRs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            try {
                return new URL[]{new File(GlassFishV2JaxRsStack.this.root, GlassFishV2JaxRsStack.ASM_31_JAR).toURI().toURL(), new File(GlassFishV2JaxRsStack.this.root, GlassFishV2JaxRsStack.JERSEY_BUNDLE_10_JAR).toURI().toURL(), new File(GlassFishV2JaxRsStack.this.root, GlassFishV2JaxRsStack.JETTISON_10_JAR).toURI().toURL(), new File(GlassFishV2JaxRsStack.this.root, GlassFishV2JaxRsStack.JSR311_API_JAR).toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                return new URL[0];
            }
        }
    }
}

