/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Dialog;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ui.BrokenDatasourceAlertPanel;
import org.netbeans.modules.j2ee.common.ui.J2EEUISettings;
import org.netbeans.modules.j2ee.common.ui.MissingDatabaseConnectionWarning;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokenDatasourceSupport {
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private BrokenDatasourceSupport() {
    }

    public static void fixDatasources(Project project) {
        MissingDatabaseConnectionWarning.selectDatasources(NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"LBL_Resolve_Missing_Datasources_Title"), NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"ACSD_Resolve_Missing_Datasources"), project);
    }

    public static synchronized void showAlert() {
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !J2EEUISettings.getDefault().isShowAgainBrokenDatasourceAlert()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                try {
                    object = new BrokenDatasourceAlertPanel();
                    JButton jButton = new JButton(NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"LBL_BrokenDatasourcesCustomizer_Close"));
                    jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenDatasourceSupport.class, (String)"ACSD_BrokenDatasourcesCustomizer_Close"));
                    DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(BrokenDatasourceAlertPanel.class, (String)"MSG_Broken_Datasources_Title"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
                    dialogDescriptor.setMessageType(2);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
                finally {
                    object = BrokenDatasourceSupport.class;
                    synchronized (BrokenDatasourceSupport.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }

    public static Set<Datasource> getBrokenDatasources(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet hashSet = null;
        try {
            hashSet = j2eeModuleProvider.getModuleDatasources();
        }
        catch (ConfigurationException configurationException) {
            hashSet = new HashSet();
        }
        HashSet<Datasource> hashSet2 = new HashSet<Datasource>();
        for (Datasource datasource : hashSet) {
            if (BrokenDatasourceSupport.isFound(datasource)) continue;
            hashSet2.add(datasource);
        }
        return hashSet2;
    }

    private static boolean isFound(Datasource datasource) {
        boolean bl = false;
        String string = datasource.getUrl();
        String string2 = datasource.getUsername();
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            DatabaseConnection databaseConnection = databaseConnectionArray[i];
            String string3 = databaseConnection.getDatabaseURL();
            String string4 = databaseConnection.getUser();
            if (!BrokenDatasourceSupport.matchURL(string, string3, true) || !Utilities.compareObjects((Object)string2, (Object)string4)) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean matchURL(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.contains("derby") && (string3 = string.substring(0, string.lastIndexOf(":")) + string.substring(string.lastIndexOf("/"))).equals(string2)) {
            return true;
        }
        int n = 0;
        if (string != null && string2 != null) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = string2.toCharArray();
            if (cArray2.length == cArray.length) {
                for (int i = 0; i < cArray.length - 1; ++i) {
                    if (cArray[i] != cArray2[i] && cArray[i] == ':') {
                        n = 1;
                        continue;
                    }
                    if (cArray[i + n] == cArray2[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

