/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dialog;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class JSFPageFlowMultiviewDescriptor
implements MultiViewDescription,
Serializable {
    private static final long serialVersionUID = -3101808890387485990L;
    private JSFConfigEditorContext context;
    private static final String PAGEFLOW = NbBundle.getMessage(JSFPageFlowMultiviewDescriptor.class, (String)"LBL_PageFlow");
    private static final Image JSFConfigIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/resources/JSFConfigIcon.png");
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");

    public JSFPageFlowMultiviewDescriptor() {
    }

    public JSFPageFlowMultiviewDescriptor(JSFConfigEditorContext jSFConfigEditorContext) {
        this.context = jSFConfigEditorContext;
    }

    public int getPersistenceType() {
        return 1;
    }

    public String getDisplayName() {
        return PAGEFLOW;
    }

    public Image getIcon() {
        return JSFConfigIcon;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String preferredID() {
        return PAGEFLOW;
    }

    public MultiViewElement createElement() {
        return new PageFlowElement(this.context);
    }

    static class PageFlowElement
    implements MultiViewElement,
    Serializable {
        private transient PageFlowView tc;
        private transient JComponent toolbar;
        private static final long serialVersionUID = 5454879177214643L;
        private JSFConfigEditorContext context;
        private MultiViewElementCallback callback;

        public PageFlowElement(JSFConfigEditorContext jSFConfigEditorContext) {
            this.context = jSFConfigEditorContext;
            this.init();
        }

        private void init() {
            this.getTopComponent().setName(this.context.getFacesConfigFile().getName());
        }

        public JComponent getVisualRepresentation() {
            return this.tc;
        }

        public JComponent getToolbarRepresentation() {
            if (this.toolbar == null) {
                this.toolbar = this.getTopComponent().getToolbarRepresentation();
            }
            return this.toolbar;
        }

        private PageFlowView getTopComponent() {
            if (this.tc == null) {
                this.tc = new PageFlowView(this, this.context);
            }
            return this.tc;
        }

        public Action[] getActions() {
            Action[] actionArray = this.tc.getActions();
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<SystemAction> clazz = Class.forName("org.openide.actions.FileSystemAction", true, classLoader).asSubclass(SystemAction.class);
                SystemAction systemAction = (SystemAction)SystemAction.findObject(clazz, (boolean)true);
                Action[] actionArray2 = new Action[actionArray.length + 1];
                System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
                actionArray2[actionArray.length] = systemAction;
                return actionArray2;
            }
            catch (Exception exception) {
                return new Action[0];
            }
        }

        public Lookup getLookup() {
            return this.tc.getLookup();
        }

        public void componentOpened() {
            WindowManager windowManager = WindowManager.getDefault();
            TopComponent topComponent = windowManager.findTopComponent("properties");
            if (topComponent != null && !topComponent.isOpened()) {
                topComponent.open();
            }
            this.tc.registerListeners();
            LOG.finest("PageFlowEditor componentOpened");
        }

        public void componentClosed() {
            FileObject fileObject = PageFlowView.getStorageFile(this.context.getFacesConfigFile());
            if (fileObject != null && fileObject.isValid()) {
                this.tc.serializeNodeLocations(fileObject);
            } else {
                DialogDescriptor dialogDescriptor = fileObject != null ? new DialogDescriptor((Object)NbBundle.getMessage(JSFPageFlowMultiviewDescriptor.class, (String)"MSG_NoFileToSave", (Object)fileObject), NbBundle.getMessage(JSFPageFlowMultiviewDescriptor.class, (String)"TLE_NoFileToSave")) : new DialogDescriptor((Object)NbBundle.getMessage(JSFPageFlowMultiviewDescriptor.class, (String)"MSG_NoProjectToSave"), NbBundle.getMessage(JSFPageFlowMultiviewDescriptor.class, (String)"TLE_NoFileToSave"));
                dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
            this.tc.unregstierListeners();
            PageFlowToolbarUtilities.removePageFlowView(this.tc);
            this.tc.destroyScene();
            this.toolbar = null;
            this.tc = null;
            LOG.finest("PageFlowEditor componentClosed");
        }

        public void componentShowing() {
            LOG.finest("PageFlowEditor componentShowing");
            this.tc.getPageFlowController().flushGraphIfDirty();
        }

        public void componentHidden() {
            LOG.finest("PageFlowEditor componentHidden");
        }

        public void componentActivated() {
            LOG.finest("PageFlowView componentActivated");
            this.tc.requestActive();
        }

        public void componentDeactivated() {
            LOG.finest("PageFlowView Deactivated");
        }

        public MultiViewElementCallback getMultiViewCallback() {
            return this.callback;
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            this.callback = multiViewElementCallback;
            this.context.setMultiViewTopComponent(multiViewElementCallback.getTopComponent());
        }

        public CloseOperationState canCloseElement() {
            return MultiViewFactory.createUnsafeCloseState((String)"ID_FACES_CONFIG_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.tc.serializeNodeLocations(PageFlowView.getStorageFile(this.context.getFacesConfigFile()));
            objectOutputStream.writeObject(this.context);
            LOG.finest("writeObject");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Object object = objectInputStream.readObject();
            if (!(object instanceof JSFConfigEditorContext)) {
                throw new ClassNotFoundException("JSFConfigEditorContext expected but not found");
            }
            this.context = (JSFConfigEditorContext)object;
            this.init();
            LOG.finest("readObject");
        }

        public UndoRedo getUndoRedo() {
            return this.context.getUndoRedo();
        }
    }
}

