/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.FacesModelPropertyChangeListener;
import org.netbeans.modules.web.jsf.navigation.FacesModelUtility;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.NotWebFolder;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.WebFolderListener;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.netbeans.modules.xml.xam.Component;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowController {
    private PageFlowView view;
    private JSFConfigModel configModel;
    private DataObject configDataObj;
    private final Map<NavigationCase, NavigationCaseEdge> navCase2NavCaseEdge = new WeakHashMap<NavigationCase, NavigationCaseEdge>();
    private final Map<NavigationRule, String> navRule2String = new WeakHashMap<NavigationRule, String>();
    private final HashMap<String, WeakReference<Page>> pageName2Page = new HashMap();
    private static final String NO_WEB_FOLDER_WARNING = NbBundle.getMessage(PageFlowController.class, (String)"MSG_NoWebFolder");
    private static final String NO_WEB_FOLDER_TITLE = NbBundle.getMessage(PageFlowController.class, (String)"TLE_NoWebFolder");
    private FileObject webFolder;
    private Collection<FileObject> webFiles;
    private static final String PROP_SHOW_NO_WEB_FOLDER = "showNoWebFolder";
    private PropertyChangeListener pcl;
    private FileChangeListener fcl;
    private boolean isWellFormed = true;
    private boolean isGraphDirty = false;
    private boolean isFilesDirty = false;
    private static final String CASE_STRING = "case";
    private PropertyChangeListener otherFacesConfigListener = null;
    public Stack<String> PageFlowCreationStack = new Stack();
    private int PageFlowCreationCount = 0;
    public Stack<String> PageFlowDestroyStack = new Stack();
    private int PageFlowDestroyCount = 0;
    private static final Logger LOGGER = Logger.getLogger(PageFlowController.class.getName());

    public PageFlowController(JSFConfigEditorContext jSFConfigEditorContext, PageFlowView pageFlowView) {
        this.view = pageFlowView;
        FileObject fileObject = jSFConfigEditorContext.getFacesConfigFile();
        try {
            this.configDataObj = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        this.configModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
        assert (this.configModel != null);
        this.webFolder = PageFlowView.getWebFolder(fileObject);
        this.webFiles = this.setupWebFiles(this.webFolder);
    }

    private Collection<FileObject> setupWebFiles(FileObject fileObject) {
        Collection<FileObject> collection;
        if (fileObject == null) {
            this.ifNecessaryShowNoWebFolderDialog();
            collection = new LinkedList<FileObject>();
        } else {
            collection = this.getAllProjectRelevantFilesObjects();
        }
        return collection;
    }

    protected void ifNecessaryShowNoWebFolderDialog() {
        if (this.isShowNoWebFolderDialog()) {
            NotWebFolder notWebFolder = new NotWebFolder(NO_WEB_FOLDER_WARNING);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)notWebFolder, NO_WEB_FOLDER_TITLE, true, -1, NotifyDescriptor.YES_OPTION, null);
            dialogDescriptor.setMessageType(-1);
            dialogDescriptor.setClosingOptions(new Object[]{NotifyDescriptor.OK_OPTION});
            dialogDescriptor.setOptionsAlign(0);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setSize(380, 180);
            dialog.setVisible(true);
            this.setShowNoWebFolderDialog(notWebFolder.getShowDialog());
        }
    }

    public void destroy() {
        this.webFolder = null;
        this.configModel = null;
        this.view = null;
        this.webFiles.clear();
        this.navCase2NavCaseEdge.clear();
        this.navRule2String.clear();
        this.pageName2Page.clear();
    }

    public final void setShowNoWebFolderDialog(boolean bl) {
        PageFlowController.getPreferences().putBoolean(PROP_SHOW_NO_WEB_FOLDER, bl);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(PageFlowController.class);
    }

    public final boolean isShowNoWebFolderDialog() {
        return PageFlowController.getPreferences().getBoolean(PROP_SHOW_NO_WEB_FOLDER, true);
    }

    public void registerListeners() {
        if (this.pcl == null) {
            this.pcl = new FacesModelPropertyChangeListener(this);
            if (this.configModel != null) {
                this.configModel.addPropertyChangeListener(this.pcl);
            }
        }
        FileObject fileObject = this.getWebFolder();
        if (this.fcl == null) {
            this.fcl = new WebFolderListener(this);
            if (fileObject != null) {
                try {
                    FileSystem fileSystem = fileObject.getFileSystem();
                    fileSystem.addFileChangeListener(this.fcl);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
        }
    }

    public void unregisterListeners() {
        if (this.pcl != null) {
            if (this.configModel != null) {
                this.configModel.removePropertyChangeListener(this.pcl);
            }
            this.pcl = null;
        }
        FileObject fileObject = this.getWebFolder();
        if (this.fcl != null && fileObject != null) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                fileSystem.removeFileChangeListener(this.fcl);
                this.fcl = null;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
    }

    FileChangeListener getFCL() {
        return this.fcl;
    }

    void flushGraphIfDirty() {
        if (this.isFilesDirty) {
            this.webFiles = this.setupWebFiles(this.webFolder);
            this.isFilesDirty = false;
        }
        if (this.isGraphDirty) {
            if (this.isWellFormed) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (PageFlowController.this.view == null) {
                            return;
                        }
                        PageFlowController.this.view.removeUserMalFormedFacesConfig();
                        PageFlowController.this.setupGraph();
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (PageFlowController.this.view == null) {
                            return;
                        }
                        PageFlowController.this.view.clearGraph();
                        PageFlowController.this.view.warnUserMalFormedFacesConfig();
                    }
                });
            }
            this.isGraphDirty = false;
        }
    }

    protected void setGraphDirtyWellFormed(boolean bl) {
        this.isGraphDirty = true;
        this.isWellFormed = bl;
    }

    protected void setGraphDirty() {
        this.isGraphDirty = true;
    }

    protected void setFilesDirty() {
        this.isFilesDirty = true;
        this.isGraphDirty = true;
    }

    public boolean isCurrentScope(PageFlowToolbarUtilities.Scope scope) {
        return PageFlowToolbarUtilities.getInstance(this.view).getCurrentScope().equals((Object)scope);
    }

    public NavigationCase createLink(Page page, Page page2, Pin pin) {
        if (page == null) {
            throw new NullPointerException("Source page should not be null.");
        }
        if (page2 == null) {
            throw new NullPointerException("Target page should not be null");
        }
        String string = page.getDisplayName();
        int n = 1;
        this.configModel.startTransaction();
        FacesConfig facesConfig = this.configModel.getRootComponent();
        NavigationRule navigationRule = this.getRuleWithFromViewID(facesConfig, page.getDisplayName());
        NavigationCase navigationCase = this.configModel.getFactory().createNavigationCase();
        if (navigationRule == null) {
            navigationRule = this.configModel.getFactory().createNavigationRule();
            FacesModelUtility.setFromViewId(navigationRule, page.getDisplayName());
            facesConfig.addNavigationRule(navigationRule);
            this.navRule2String.put(navigationRule, FacesModelUtility.getFromViewIdFiltered(navigationRule));
        } else {
            n = this.getNewCaseNumber(navigationRule);
        }
        String string2 = CASE_STRING + Integer.toString(n);
        if (pin != null) {
            pin.setFromOutcome(string2);
        }
        navigationCase.setFromOutcome(string2);
        FacesModelUtility.setToViewId(navigationCase, page2.getDisplayName());
        navigationRule.addNavigationCase(navigationCase);
        this.configModel.endTransaction();
        try {
            this.configModel.sync();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return navigationCase;
    }

    public void updatePageItems(Page page) {
        this.view.resetNodeWidget(page, true);
        this.view.validateGraph();
    }

    private int getNewCaseNumber(NavigationRule navigationRule) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = navigationRule.getNavigationCases();
        for (NavigationCase navigationCase : list) {
            hashSet.add(navigationCase.getFromOutcome());
        }
        int n = 1;
        while (hashSet.contains(CASE_STRING + Integer.toString(n))) {
            ++n;
        }
        return n;
    }

    private NavigationRule getRuleWithFromViewID(FacesConfig facesConfig, String string) {
        for (NavigationRule navigationRule : facesConfig.getNavigationRules()) {
            String string2 = FacesModelUtility.getFromViewIdFiltered(navigationRule);
            if (string2 == null || !string2.equals(string)) continue;
            return navigationRule;
        }
        return null;
    }

    private final Collection<FileObject> getAllProjectRelevantFilesObjects() {
        return this.getProjectKnownFileOjbects(this.getWebFolder());
    }

    private Collection<FileObject> getProjectKnownFileOjbects(FileObject fileObject) {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        FileObject[] fileObjectArray = new FileObject[]{};
        if (fileObject != null) {
            fileObjectArray = fileObject.getChildren();
        }
        for (FileObject fileObject2 : fileObjectArray) {
            if (!fileObject2.isFolder()) {
                if (!this.isKnownFile(fileObject2)) continue;
                linkedList.add(fileObject2);
                continue;
            }
            if (!this.isKnownFolder(fileObject2)) continue;
            linkedList.addAll(this.getProjectKnownFileOjbects(fileObject2));
        }
        return linkedList;
    }

    public final boolean isKnownFile(FileObject fileObject) {
        if (fileObject.getMIMEType().equals("text/x-jsp") && !fileObject.getExt().equals("jspf")) {
            return true;
        }
        return fileObject.getMIMEType().equals("text/html");
    }

    public final boolean isKnownFolder(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        if (!fileObject.getPath().contains(this.getWebFolder().getPath())) {
            return false;
        }
        return !fileObject.getPath().contains("WEB-INF") && !fileObject.getPath().contains("META-INF");
    }

    public boolean setupGraph() {
        this.view.saveLocations();
        return this.setupGraphNoSaveData();
    }

    private PropertyChangeListener getOtherFacesConfigListener() {
        if (this.otherFacesConfigListener == null) {
            return new OtherFacesModelListener();
        }
        return this.otherFacesConfigListener;
    }

    private void removeOtherFacesConfigListener() {
        FileObject[] fileObjectArray;
        WebModule webModule = WebModule.getWebModule((FileObject)this.getWebFolder());
        for (FileObject fileObject : fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            jSFConfigModel.removePropertyChangeListener(this.otherFacesConfigListener);
        }
        this.otherFacesConfigListener = null;
    }

    protected void releaseGraphInfo() {
        if (this.otherFacesConfigListener != null) {
            this.removeOtherFacesConfigListener();
        }
        this.view.clearGraph();
        this.clearPageName2Page();
        this.navCase2NavCaseEdge.clear();
        this.navRule2String.clear();
    }

    public boolean setupGraphNoSaveData() {
        LOGGER.entering(PageFlowController.class.toString(), "setupGraphNoSaveData()");
        assert (this.configModel != null);
        assert (this.webFiles != null);
        this.releaseGraphInfo();
        FacesConfig facesConfig = this.configModel.getRootComponent();
        if (facesConfig == null) {
            return false;
        }
        try {
            ArrayList<NavigationRule> arrayList = null;
            if (this.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG)) {
                arrayList = facesConfig.getNavigationRules();
                for (NavigationRule navigationRule : arrayList) {
                    this.navRule2String.put(navigationRule, FacesModelUtility.getFromViewIdFiltered(navigationRule));
                }
                Collection<String> collection = this.getFacesConfigPageNames((Collection<NavigationRule>)arrayList);
                this.createFacesConfigPages(collection);
            } else if (this.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                arrayList = facesConfig.getNavigationRules();
                for (NavigationRule navigationRule : arrayList) {
                    this.navRule2String.put(navigationRule, FacesModelUtility.getFromViewIdFiltered(navigationRule));
                }
                Collection<String> collection = this.getFacesConfigPageNames((Collection<NavigationRule>)arrayList);
                this.createAllProjectPages(collection);
            } else if (this.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG)) {
                ArrayList<NavigationRule> arrayList2 = new ArrayList<NavigationRule>();
                FileObject fileObject = this.getWebFolder();
                if (fileObject != null) {
                    WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
                    FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule);
                    for (FileObject fileObject2 : fileObjectArray) {
                        JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject2, (boolean)true);
                        arrayList2.addAll(jSFConfigModel.getRootComponent().getNavigationRules());
                        if (this.configModel.equals(jSFConfigModel)) continue;
                        jSFConfigModel.addPropertyChangeListener(this.getOtherFacesConfigListener());
                    }
                    for (NavigationRule navigationRule : arrayList2) {
                        this.navRule2String.put(navigationRule, FacesModelUtility.getFromViewIdFiltered(navigationRule));
                    }
                    Collection<String> collection = this.getFacesConfigPageNames(arrayList2);
                    this.createFacesConfigPages(collection);
                    arrayList = arrayList2;
                } else {
                    arrayList = facesConfig.getNavigationRules();
                    for (NavigationRule navigationRule : arrayList) {
                        this.navRule2String.put(navigationRule, FacesModelUtility.getFromViewIdFiltered(navigationRule));
                    }
                    Collection<String> collection = this.getFacesConfigPageNames((Collection<NavigationRule>)arrayList);
                    this.createAllProjectPages(collection);
                }
            }
            this.createAllEdges((List<NavigationRule>)arrayList);
            this.view.validateGraph();
            LOGGER.log(new LogRecord(Level.FINE, "PageFlowEditor # Rules: " + arrayList.size() + "\n" + "               # WebPages: " + this.webFiles.size() + "\n" + "               # TotalPages: " + this.pageName2Page.size()));
        }
        catch (IllegalStateException illegalStateException) {
            this.view.warnUserMalFormedFacesConfig();
            this.view.validateGraph();
            LOGGER.log(new LogRecord(Level.FINE, "Illegal SateException thrown: " + illegalStateException.toString()));
        }
        LOGGER.exiting(PageFlowController.class.toString(), "setupGraphNoSaveData()");
        return true;
    }

    private void createAllEdges(List<NavigationRule> list) {
        List list2 = this.configModel.getRootComponent().getNavigationRules();
        for (NavigationRule navigationRule : list) {
            List list3 = navigationRule.getNavigationCases();
            boolean bl = list2.contains(navigationRule);
            for (NavigationCase navigationCase : list3) {
                NavigationCaseEdge navigationCaseEdge = new NavigationCaseEdge(this, navigationCase);
                this.navCase2NavCaseEdge.put(navigationCase, navigationCaseEdge);
                navigationCaseEdge.setModifiable(bl);
                if (navigationCaseEdge.getFromViewId() == null || navigationCaseEdge.getToViewId() == null) continue;
                this.createEdge(navigationCaseEdge);
            }
        }
    }

    protected void createEdge(NavigationCaseEdge navigationCaseEdge) {
        String string = navigationCaseEdge.getFromViewId();
        String string2 = navigationCaseEdge.getToViewId();
        if (this.getPageName2Page(string) == null || this.getPageName2Page(string2) == null) {
            System.err.println("Why is this node null? CaseNode: " + navigationCaseEdge);
            System.err.println("FromPage: " + string);
            System.err.println("ToPage: " + string2);
            Thread.dumpStack();
        } else {
            this.view.createEdge(navigationCaseEdge, this.getPageName2Page(string), this.getPageName2Page(string2));
        }
    }

    private Collection<String> getFacesConfigPageNames(Collection<NavigationRule> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (NavigationRule navigationRule : collection) {
            String string = FacesModelUtility.getFromViewIdFiltered(navigationRule);
            hashSet.add(string);
            List list = navigationRule.getNavigationCases();
            for (NavigationCase navigationCase : list) {
                String string2 = FacesModelUtility.getToViewIdFiltered(navigationCase);
                if (string2 == null) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public Page createPage(Node node) {
        Page page = new Page(this, node);
        Calendar calendar = Calendar.getInstance();
        this.PageFlowCreationStack.push("\n" + this.PageFlowCreationCount + ". " + calendar.get(12) + ":" + calendar.get(13) + " -  " + page);
        ++this.PageFlowCreationCount;
        return page;
    }

    public Page createPage(String string) {
        Page page = null;
        if (string == null) {
            throw new NullPointerException("Page name string is null");
        }
        assert (string.length() != 0);
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(string);
        page = this.createPage((Node)abstractNode);
        return page;
    }

    private void destroyPageFlowNode(Page page) {
        if (page != null) {
            page.destroy2();
            Calendar calendar = Calendar.getInstance();
            this.PageFlowDestroyStack.push("\n" + this.PageFlowDestroyCount + ". " + calendar.get(12) + ":" + calendar.get(13) + " -  " + page);
            ++this.PageFlowDestroyCount;
        }
    }

    private void createAllProjectPages(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        FileObject[] fileObjectArray = this.webFiles.toArray(new FileObject[0]);
        for (Object object : fileObjectArray) {
            String string = Page.getFolderDisplayName(this.getWebFolder(), object);
            Page page = null;
            try {
                page = this.createPage(DataObject.find((FileObject)object).getNodeDelegate());
                this.view.createNode(page, null, null);
                hashSet.remove(string);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                this.webFiles.remove(object);
            }
        }
        for (String string : hashSet) {
            Object object;
            if (string == null) continue;
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName(string);
            object = this.createPage((Node)abstractNode);
            this.view.createNode((Page)object, null, null);
        }
    }

    private FileObject getFileObject(String string) {
        for (FileObject fileObject : this.webFiles) {
            String string2 = Page.getFolderDisplayName(this.getWebFolder(), fileObject);
            if (!string2.equals(string)) continue;
            return fileObject;
        }
        return null;
    }

    private void createFacesConfigPages(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        for (String string : hashSet) {
            if (string == null) continue;
            FileObject fileObject = this.getFileObject(string);
            AbstractNode abstractNode = null;
            if (fileObject == null) {
                abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName(string);
            } else {
                try {
                    abstractNode = DataObject.find((FileObject)fileObject).getNodeDelegate();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            Page page = this.createPage((Node)abstractNode);
            this.view.createNode(page, null, null);
        }
    }

    public Page removePageName2Page(Page page, boolean bl) {
        return this.removePageName2Page(page.getDisplayName(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page removePageName2Page(String string, boolean bl) {
        LOGGER.finest("PageName2Page: remove " + string);
        this.checkAWTThread();
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            Page page = null;
            WeakReference<Page> weakReference = this.pageName2Page.remove(string);
            if (weakReference != null) {
                page = (Page)weakReference.get();
                if (bl) {
                    this.destroyPageFlowNode(page);
                }
            }
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replacePageName2Page(Page page, String string, String string2) {
        LOGGER.finest("PageName2Page: replace " + string2 + " to " + string);
        if (page == null) {
            throw new NullPointerException("Page can not be null.");
        }
        this.checkAWTThread();
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            WeakReference<Page> weakReference = this.pageName2Page.remove(string2);
            if (weakReference != null) {
                Page page2 = (Page)weakReference.get();
                if (page2 != null) {
                    LOGGER.finest("Trying to replace page in map, but page not found:" + page);
                }
                this.pageName2Page.put(string, new WeakReference<Page>(page));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPageName2Page() {
        HashSet<String> hashSet;
        LOGGER.finest("PageName2Page: clear");
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            hashSet = new HashSet<String>(this.pageName2Page.keySet());
        }
        for (String string : hashSet) {
            this.removePageName2Page(string, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putPageName2Page(String string, Page page) {
        LOGGER.finest("PageName2Page: put " + string);
        if (page == null) {
            throw new NullPointerException("putPageName2Page does not accept null pages.");
        }
        this.checkAWTThread();
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            this.pageName2Page.put(string, new WeakReference<Page>(page));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page getPageName2Page(String string) {
        this.checkAWTThread();
        if (string == null) {
            throw new NullPointerException("Displayname should not be null. You may be using this method incorrectly.");
        }
        HashMap<String, WeakReference<Page>> hashMap = this.pageName2Page;
        synchronized (hashMap) {
            Page page = null;
            WeakReference<Page> weakReference = this.pageName2Page.get(string);
            if (weakReference != null) {
                page = (Page)weakReference.get();
            }
            return page;
        }
    }

    private void checkAWTThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
            throw new RuntimeException("Not a Dispatched Thread");
        }
    }

    public void renamePageInModel(String string, String string2) {
        FacesModelUtility.renamePageInModel(this.configModel, string, string2);
    }

    public void removeSceneNodeEdges(Page page) {
        Collection<NavigationCaseEdge> collection = this.view.getNodeEdges(page);
        for (NavigationCaseEdge navigationCaseEdge : collection) {
            try {
                navigationCaseEdge.destroy();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void removePageInModel(String string) {
        this.configModel.startTransaction();
        FacesConfig facesConfig = this.configModel.getRootComponent();
        List list = facesConfig.getNavigationRules();
        for (NavigationRule navigationRule : list) {
            String string2 = FacesModelUtility.getFromViewIdFiltered(navigationRule);
            if (string2 != null && string2.equals(string)) {
                facesConfig.removeNavigationRule(navigationRule);
                continue;
            }
            List list2 = navigationRule.getNavigationCases();
            for (NavigationCase navigationCase : list2) {
                String string3 = FacesModelUtility.getToViewIdFiltered(navigationCase);
                if (string3 == null || !string3.equals(string)) continue;
                navigationRule.removeNavigationCase(navigationCase);
            }
        }
        this.configModel.endTransaction();
        try {
            this.configModel.sync();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public FileObject getWebFolder() {
        return this.webFolder;
    }

    public boolean isPageInAnyFacesConfig(String string) {
        FileObject[] fileObjectArray;
        WebModule webModule = WebModule.getWebModule((FileObject)this.getWebFolder());
        for (FileObject fileObject : fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)webModule)) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            List list = jSFConfigModel.getRootComponent().getNavigationRules();
            Collection<String> collection = this.getFacesConfigPageNames(list);
            if (!collection.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isNavCaseInFacesConfig(NavigationCaseEdge navigationCaseEdge) {
        NavigationCase navigationCase = this.getNavCase2NavCaseEdge(navigationCaseEdge);
        JSFConfigComponent jSFConfigComponent = (JSFConfigComponent)navigationCase.getParent();
        return this.configModel.getRootComponent().getNavigationRules().contains(jSFConfigComponent);
    }

    public void changeToAbstractNode(Page page, String string) {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(string);
        page.replaceWrappedNode((Node)abstractNode);
        this.view.resetNodeWidget(page, true);
    }

    public DataObject getConfigDataObject() {
        return this.configDataObj;
    }

    public void saveLocation(String string, String string2) {
        this.view.saveLocation(string, string2);
    }

    public final boolean removeWebFile(FileObject fileObject) {
        return this.webFiles.remove(fileObject);
    }

    public final boolean addWebFile(FileObject fileObject) {
        return this.webFiles.add(fileObject);
    }

    public final boolean containsWebFile(FileObject fileObject) {
        return this.webFiles.contains(fileObject);
    }

    public final void putNavCase2NavCaseEdge(NavigationCase navigationCase, NavigationCaseEdge navigationCaseEdge) {
        this.navCase2NavCaseEdge.put(navigationCase, navigationCaseEdge);
    }

    public final NavigationCaseEdge getNavCase2NavCaseEdge(NavigationCase navigationCase) {
        return this.navCase2NavCaseEdge.get(navigationCase);
    }

    private final NavigationCase getNavCase2NavCaseEdge(NavigationCaseEdge navigationCaseEdge) {
        Set<Map.Entry<NavigationCase, NavigationCaseEdge>> set = this.navCase2NavCaseEdge.entrySet();
        for (Map.Entry<NavigationCase, NavigationCaseEdge> entry : set) {
            if (!((Object)entry.getValue()).equals(navigationCaseEdge)) continue;
            return entry.getKey();
        }
        return null;
    }

    public final NavigationCaseEdge removeNavCase2NavCaseEdge(NavigationCase navigationCase) {
        return this.navCase2NavCaseEdge.remove(navigationCase);
    }

    public final String removeNavRule2String(NavigationRule navigationRule) {
        return this.navRule2String.remove(navigationRule);
    }

    public final String putNavRule2String(NavigationRule navigationRule, String string) {
        return this.navRule2String.put(navigationRule, string);
    }

    public PageFlowView getView() {
        return this.view;
    }

    public void setModelNavigationCaseName(NavigationCase navigationCase, String string) {
        this.configModel.startTransaction();
        if (navigationCase.getFromOutcome() != null) {
            navigationCase.setFromOutcome(string);
        }
        if (navigationCase.getFromAction() != null) {
            navigationCase.setFromAction(string);
        }
        this.configModel.endTransaction();
        try {
            this.configModel.sync();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void removeModelNavigationCase(NavigationCase navigationCase) throws IOException {
        this.configModel.startTransaction();
        NavigationRule navigationRule = (NavigationRule)navigationCase.getParent();
        if (navigationRule != null && navigationRule.getNavigationCases().contains(navigationCase)) {
            navigationRule.removeNavigationCase(navigationCase);
            if (navigationRule.getNavigationCases().size() < 1) {
                this.configModel.removeChildComponent((Component)navigationRule);
            }
        }
        this.configModel.endTransaction();
        this.configModel.sync();
    }

    public void serializeNodeLocations() {
        this.view.serializeNodeLocations(PageFlowView.getStorageFile(this.configDataObj.getPrimaryFile()));
    }

    public void openNavigationCase(NavigationCaseEdge navigationCaseEdge) {
        EditorCookie.Observable observable;
        EditCookie editCookie;
        final NavigationCase navigationCase = this.getNavCase2NavCaseEdge(navigationCaseEdge);
        DataObject dataObject = this.getConfigDataObject();
        if (dataObject != null && (editCookie = (EditCookie)dataObject.getCookie(EditCookie.class)) != null && (observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class)) != null) {
            StatusDisplayer.getDefault().setStatusText("otvirani");
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    editCookie.edit();
                    JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                    if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                        PageFlowController.this.openPane(jEditorPaneArray[0], navigationCase);
                    } else {
                        observable.addPropertyChangeListener(new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                if ("openedPanes".equals(propertyChangeEvent.getPropertyName())) {
                                    JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                                    if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                        PageFlowController.this.openPane(jEditorPaneArray[0], navigationCase);
                                    }
                                    observable.removePropertyChangeListener((PropertyChangeListener)this);
                                }
                            }
                        });
                        observable.open();
                    }
                }
            });
        }
    }

    private void openPane(JEditorPane jEditorPane, NavigationCase navigationCase) {
        Cursor cursor = jEditorPane.getCursor();
        jEditorPane.setCursor(Cursor.getPredefinedCursor(3));
        jEditorPane.setCaretPosition(navigationCase.findPosition() + 2);
        jEditorPane.setCursor(cursor);
        StatusDisplayer.getDefault().setStatusText("");
    }

    public static final Collection<? extends PageContentModelProvider> getPageContentModelProviders() {
        Lookup.Template template = new Lookup.Template(PageContentModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        return collection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestAccessor {
        TestAccessor() {
        }

        static Collection<String> getPagesInFacesConfig(PageFlowController pageFlowController) {
            Set<NavigationRule> set = TestAccessor.getAllNavigationRules(pageFlowController);
            return pageFlowController.getFacesConfigPageNames(set);
        }

        static Collection<FileObject> getAllRelevantFiles(PageFlowController pageFlowController) {
            return pageFlowController.getAllProjectRelevantFilesObjects();
        }

        static Set<NavigationRule> getAllNavigationRules(PageFlowController pageFlowController) {
            return pageFlowController.navRule2String.keySet();
        }

        static Set<NavigationCase> getAllNavigationCases(PageFlowController pageFlowController) {
            return pageFlowController.navCase2NavCaseEdge.keySet();
        }
    }

    private class OtherFacesModelListener
    implements PropertyChangeListener {
        private OtherFacesModelListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (PageFlowController.this.view == null) {
                        return;
                    }
                    PageFlowController.this.setupGraph();
                }
            });
        }
    }
}

