/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PFENodeWidget;
import org.netbeans.modules.web.jsf.navigation.graph.PFENotModifiableScheme;
import org.netbeans.modules.web.jsf.navigation.graph.PFObjectSceneListener;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.graph.actions.LinkCreateProvider;
import org.netbeans.modules.web.jsf.navigation.graph.actions.MapActionUtility;
import org.netbeans.modules.web.jsf.navigation.graph.actions.MyActionMapAction;
import org.netbeans.modules.web.jsf.navigation.graph.actions.PageFlowDeleteAction;
import org.netbeans.modules.web.jsf.navigation.graph.actions.PageFlowPopupProvider;
import org.netbeans.modules.web.jsf.navigation.graph.layout.ConnectionWrapperLayout;
import org.netbeans.modules.web.jsf.navigation.graph.layout.FreePlaceNodesLayouter;
import org.openide.actions.DeleteAction;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowScene
extends GraphPinScene<Page, NavigationCaseEdge, Pin> {
    private static final VMDColorScheme scheme = VMDFactory.getNetBeans60Scheme();
    private final LayerWidget backgroundLayer = new LayerWidget((Scene)this);
    private final LayerWidget mainLayer = new LayerWidget((Scene)this);
    private final LayerWidget connectionLayer = new LayerWidget((Scene)this);
    private final LayerWidget upperLayer = new LayerWidget((Scene)this);
    private Router router;
    private static final int MAX_EDGES = 20;
    private static final int MAX_PAGES = 20;
    private static final int MAX_ELEMENTS = 30;
    private final Router routerDirect = RouterFactory.createDirectRouter();
    private final WidgetAction moveControlPointAction = ActionFactory.createOrthogonalMoveControlPointAction();
    private final WidgetAction moveAction = ActionFactory.createMoveAction();
    private final WidgetAction connectAction = ActionFactory.createConnectAction((LayerWidget)this.connectionLayer, (ConnectProvider)new LinkCreateProvider(this));
    private final WidgetAction selectAction = ActionFactory.createSelectAction((SelectProvider)new PageFlowSelectProvider());
    private final WidgetAction doubleClickAction = ActionFactory.createEditAction((EditProvider)new PageNodeEditAction());
    private final WidgetAction pagePopupAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new PageFlowPopupProvider());
    private WeakReference<PageFlowView> refPageFlowView;
    private PopupMenuProvider popupProvider;
    private PFObjectSceneListener pfObjectSceneListener;
    private static Paint PAINT_BACKGROUND;
    private FreePlaceNodesLayouter fpnl;
    private final LabelWidget malFormedLabel = new LabelWidget((Scene)this, "Your XML is Malformed.");
    private WidgetAction pageSpecificActionMapAction = null;

    public PageFlowScene(PageFlowView pageFlowView) {
        this.refPageFlowView = new WeakReference<PageFlowView>(pageFlowView);
        this.setOpaque(true);
        this.setBackground(PAINT_BACKGROUND);
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.addChild((Widget)this.backgroundLayer);
        this.addChild((Widget)this.mainLayer);
        this.addChild((Widget)this.connectionLayer);
        this.addChild((Widget)this.upperLayer);
        this.router = RouterFactory.createOrthogonalSearchRouter((LayerWidget[])new LayerWidget[]{this.mainLayer, this.connectionLayer});
        WidgetAction.Chain chain = this.getActions();
        chain.addAction(ActionFactory.createZoomAction());
        chain.addAction(ActionFactory.createPanAction());
        chain.addAction(ActionFactory.createRectangularSelectAction((ObjectScene)this, (LayerWidget)this.backgroundLayer));
        chain.addAction(this.pagePopupAction);
        chain.addAction(this.createActionMap());
        this.pfObjectSceneListener = new PFObjectSceneListener();
        this.addObjectSceneListener(this.pfObjectSceneListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.fpnl = new FreePlaceNodesLayouter(this, pageFlowView.getVisibleRect());
    }

    public void destoryPageFlowScene() {
        this.removeObjectSceneListener(this.pfObjectSceneListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.pfObjectSceneListener = null;
        this.popupProvider = null;
        this.fpnl.unregisterListeners(this);
        this.fpnl = null;
        this.router = null;
        WidgetAction.Chain chain = this.getActions();
        for (WidgetAction widgetAction : new ArrayList(chain.getActions())) {
            chain.removeAction(widgetAction);
        }
    }

    private WidgetAction createActionMap() {
        ActionMap actionMap = ((PageFlowView)((Object)this.refPageFlowView.get())).getActionMap();
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(DeleteAction.class);
        actionMap.put(callbackSystemAction.getActionMapKey(), new PageFlowDeleteAction(this));
        return new MyActionMapAction(MapActionUtility.initInputMap(), MapActionUtility.initActionMap());
    }

    public PageFlowView getPageFlowView() {
        return (PageFlowView)((Object)this.refPageFlowView.get());
    }

    public void createMalFormedWidget() {
        List list = this.getChildren();
        if (!list.contains(this.malFormedLabel)) {
            this.addChild((Widget)this.malFormedLabel);
            this.validate();
        }
    }

    public void removeMalFormedWidget() {
        List list = this.getChildren();
        if (list.contains(this.malFormedLabel)) {
            this.removeChild((Widget)this.malFormedLabel);
            this.validate();
        }
    }

    protected Widget attachNodeWidget(Page page) {
        assert (page != null);
        PFENodeWidget pFENodeWidget = new PFENodeWidget(this, scheme);
        String string = page.getDisplayName();
        pFENodeWidget.setNodeName(string);
        Widget widget = pFENodeWidget.getHeader();
        DefaultAnchorWidget defaultAnchorWidget = new DefaultAnchorWidget(this, ImageUtilities.loadImage((String)"org/netbeans/modules/visual/resources/vmd-pin.png"));
        defaultAnchorWidget.getActions().addAction(this.connectAction);
        defaultAnchorWidget.getActions().addAction(this.createWidgetHoverAction());
        widget.addChild((Widget)defaultAnchorWidget);
        widget.getActions().addAction(this.createWidgetHoverAction());
        LabelWidget labelWidget = pFENodeWidget.getNodeNameWidget();
        labelWidget.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new PageNodeTextFieldInplaceEditor(pFENodeWidget)));
        this.mainLayer.addChild((Widget)pFENodeWidget);
        pFENodeWidget.getHeader().getActions().addAction(this.createObjectHoverAction());
        pFENodeWidget.getHeader().getActions().addAction(this.doubleClickAction);
        pFENodeWidget.getActions().addAction(this.selectAction);
        pFENodeWidget.getActions().addAction(this.moveAction);
        pFENodeWidget.setMinimized(true);
        return pFENodeWidget;
    }

    public final void updateNodeWidgetActions(Page page) {
        Widget widget = this.findWidget(page);
        if (widget != null) {
            if (this.pageSpecificActionMapAction != null) {
                widget.getActions().removeAction(this.pageSpecificActionMapAction);
            }
            this.pageSpecificActionMapAction = this.createActionMapAction(page);
            if (this.pageSpecificActionMapAction != null) {
                widget.getActions().addAction(this.pageSpecificActionMapAction);
            }
        }
    }

    private WidgetAction createActionMapAction(Page page) {
        Action[] actionArray;
        InputMap inputMap = new InputMap();
        ActionMap actionMap = new ActionMap();
        for (Action action : actionArray = page.getActions(true)) {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            inputMap.put(keyStroke, action.toString());
            actionMap.put(action.toString(), action);
        }
        if (actionMap.size() < 1) {
            return null;
        }
        return new MyActionMapAction(inputMap, actionMap);
    }

    public Rectangle getVisibleRect() {
        return ((PageFlowView)((Object)this.refPageFlowView.get())).getVisibleRect();
    }

    protected void detachNodeWidget(Page page, Widget widget) {
        super.detachNodeWidget((Object)page, widget);
    }

    public Pin getDefaultPin(Page page) {
        Collection collection = this.getNodePins(page);
        if (collection == null) {
            System.err.println("Node is null?: " + page);
        }
        for (Pin pin : collection) {
            if (!pin.isDefault()) continue;
            return pin;
        }
        System.err.println("Some reason this node: " + page + " does not have a pin.");
        return null;
    }

    protected Widget attachPinWidget(Page page, Pin pin) {
        assert (page != null);
        if (pin.isDefault()) {
            return null;
        }
        VMDPinWidget vMDPinWidget = new VMDPinWidget((Scene)this, scheme);
        VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)this.findWidget(page);
        if (vMDNodeWidget != null) {
            vMDNodeWidget.attachPinWidget((Widget)vMDPinWidget);
            vMDPinWidget.setProperties(pin.getName(), Arrays.asList(pin.getIcon(0)));
            WidgetAction.Chain chain = vMDPinWidget.getActions();
            chain.addAction(this.createObjectHoverAction());
            chain.addAction(this.createSelectAction());
            chain.addAction(this.connectAction);
            chain.addAction(this.doubleClickAction);
        } else {
            System.err.println("Node widget should not be null.");
        }
        return vMDPinWidget;
    }

    protected Widget attachEdgeWidget(NavigationCaseEdge navigationCaseEdge) {
        assert (navigationCaseEdge != null);
        VMDConnectionWidget vMDConnectionWidget = navigationCaseEdge.isModifiable() ? new VMDConnectionWidget((Scene)this, scheme) : new VMDConnectionWidget((Scene)this, (VMDColorScheme)new PFENotModifiableScheme());
        if (this.getEdges().size() > 20 || this.getNodes().size() > 20 || this.getEdges().size() + this.getNodes().size() > 30) {
            vMDConnectionWidget.setRouter(this.routerDirect);
        } else {
            vMDConnectionWidget.setRouter(this.router);
        }
        LabelWidget labelWidget = new LabelWidget((Scene)this, navigationCaseEdge.getName());
        labelWidget.setOpaque(true);
        labelWidget.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new CaseNodeTextFieldInplaceEditor()));
        this.connectionLayer.addChild((Widget)vMDConnectionWidget);
        vMDConnectionWidget.getActions().addAction(this.createObjectHoverAction());
        vMDConnectionWidget.getActions().addAction(this.selectAction);
        vMDConnectionWidget.getActions().addAction(this.moveControlPointAction);
        vMDConnectionWidget.getActions().addAction(this.doubleClickAction);
        vMDConnectionWidget.setLayout((Layout)new ConnectionWrapperLayout((ConnectionWidget)vMDConnectionWidget, labelWidget));
        vMDConnectionWidget.setConstraint((Widget)labelWidget, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT, 10);
        vMDConnectionWidget.addChild((Widget)labelWidget);
        return vMDConnectionWidget;
    }

    public void renameEdgeWidget(NavigationCaseEdge navigationCaseEdge, String string, String string2) {
        VMDConnectionWidget vMDConnectionWidget = (VMDConnectionWidget)this.findWidget(navigationCaseEdge);
        List list = vMDConnectionWidget.getChildren();
        for (Widget widget : list) {
            if (!(widget instanceof LabelWidget) || !((LabelWidget)widget).getLabel().equals(string2)) continue;
            ((LabelWidget)widget).setLabel(string);
            return;
        }
    }

    protected void attachEdgeSourceAnchor(NavigationCaseEdge navigationCaseEdge, Pin pin, Pin pin2) {
        ConnectionWidget connectionWidget = (ConnectionWidget)this.findWidget(navigationCaseEdge);
        Anchor anchor = this.getPinAnchor(pin2);
        connectionWidget.setSourceAnchor(anchor);
    }

    protected void attachEdgeTargetAnchor(NavigationCaseEdge navigationCaseEdge, Pin pin, Pin pin2) {
        ((ConnectionWidget)this.findWidget(navigationCaseEdge)).setTargetAnchor(this.getPinAnchor(pin2));
    }

    private Anchor getPinAnchor(Pin pin) {
        Anchor anchor;
        if (pin == null) {
            return null;
        }
        VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)this.findWidget(this.getPinNode(pin));
        Widget widget = this.findWidget(pin);
        if (widget != null) {
            anchor = AnchorFactory.createDirectionalAnchor((Widget)widget, (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL, (int)8);
            anchor = vMDNodeWidget.createAnchorPin(anchor);
        } else {
            anchor = vMDNodeWidget.getNodeAnchor();
        }
        return anchor;
    }

    public LayerWidget getConnectionLayer() {
        return this.connectionLayer;
    }

    public PopupMenuProvider getPopupMenuProvider() {
        return this.popupProvider;
    }

    static {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/graph/resources/paper_grid.png");
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        PAINT_BACKGROUND = new TexturePaint(bufferedImage, new Rectangle(0, 0, n, n2));
    }

    static class SceneTestAccessor {
        SceneTestAccessor() {
        }

        static FreePlaceNodesLayouter getFreePlaceNodesLayouter(PageFlowScene pageFlowScene) {
            return pageFlowScene.fpnl;
        }

        static PopupMenuProvider getPopupProvider(PageFlowScene pageFlowScene) {
            return pageFlowScene.popupProvider;
        }

        static PFObjectSceneListener getPfObjectSceneListener(PageFlowScene pageFlowScene) {
            return pageFlowScene.pfObjectSceneListener;
        }
    }

    public final class PageNodeTextFieldInplaceEditor
    implements TextFieldInplaceEditor {
        private final VMDNodeWidget nodeWidget;

        public PageNodeTextFieldInplaceEditor(VMDNodeWidget vMDNodeWidget) {
            this.nodeWidget = vMDNodeWidget;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            Page page = (Page)PageFlowScene.this.findObject((Widget)this.nodeWidget);
            return page.getName();
        }

        public void setText(Widget widget, String string) {
            Page page = (Page)PageFlowScene.this.findObject((Widget)this.nodeWidget);
            if (page.canRename() && !string.equals(page.getName())) {
                String string2 = page.getDisplayName();
                page.setName(string);
                String string3 = page.getDisplayName();
                if (widget instanceof LabelWidget) {
                    ((LabelWidget)widget).setLabel(string3);
                } else if (widget instanceof VMDNodeWidget) {
                    ((VMDNodeWidget)widget).getNodeNameWidget().setLabel(string3);
                }
                PageFlowScene.this.validate();
            }
        }
    }

    public final class CaseNodeTextFieldInplaceEditor
    implements TextFieldInplaceEditor {
        public boolean isEnabled(Widget widget) {
            NavigationCaseEdge navigationCaseEdge = (NavigationCaseEdge)PageFlowScene.this.findObject(widget.getParentWidget());
            return navigationCaseEdge.isModifiable();
        }

        public String getText(Widget widget) {
            NavigationCaseEdge navigationCaseEdge = (NavigationCaseEdge)PageFlowScene.this.findObject(widget.getParentWidget());
            return ((LabelWidget)widget).getLabel();
        }

        public void setText(Widget widget, String string) {
            if (string.equals("")) {
                return;
            }
            NavigationCaseEdge navigationCaseEdge = (NavigationCaseEdge)PageFlowScene.this.findObject(widget.getParentWidget());
            String string2 = navigationCaseEdge.getName();
            if (navigationCaseEdge.canRename()) {
                navigationCaseEdge.setName(string);
            }
            ((LabelWidget)widget).setLabel(string);
        }
    }

    public final class PageNodeEditAction
    implements EditProvider {
        public void edit(Widget widget) {
            PageFlowScene pageFlowScene = (PageFlowScene)widget.getScene();
            PageFlowSceneElement pageFlowSceneElement = (PageFlowSceneElement)pageFlowScene.findObject(widget);
            MapActionUtility.openPageFlowSceneElement(pageFlowSceneElement);
        }
    }

    private final class PageFlowSelectProvider
    implements SelectProvider {
        private PageFlowSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            Object object = PageFlowScene.this.findObject(widget);
            return object != null && (bl || !PageFlowScene.this.getSelectedObjects().contains(object));
        }

        public void select(Widget widget, Point point, boolean bl) {
            Object object = PageFlowScene.this.findObject(widget);
            if (object != null) {
                PageFlowScene.this.setFocusedObject(object);
                if (PageFlowScene.this.getSelectedObjects().contains(object)) {
                    return;
                }
                PageFlowScene.this.userSelectionSuggested(Collections.singleton(object), bl);
            } else {
                PageFlowScene.this.userSelectionSuggested(Collections.emptySet(), bl);
            }
        }
    }

    private static class DefaultAnchorWidget
    extends ImageWidget {
        public DefaultAnchorWidget(PageFlowScene pageFlowScene, Image image) {
            super((Scene)pageFlowScene, image);
        }

        protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
            Border border = BorderFactory.createLineBorder(Color.BLACK);
            Border border2 = BorderFactory.createEmptyBorder();
            if (objectState.isHovered() == objectState2.isHovered()) {
                return;
            }
            this.setBorder(objectState2.isHovered() ? border : border2);
        }
    }
}

