/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpInterpreter;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ProjectPropertiesSupport {
    private ProjectPropertiesSupport() {
    }

    public static PropertyEvaluator getPropertyEvaluator(PhpProject phpProject) {
        return phpProject.getEvaluator();
    }

    public static void addWeakPropertyEvaluatorListener(PhpProject phpProject, PropertyChangeListener propertyChangeListener) {
        phpProject.addWeakPropertyEvaluatorListener(propertyChangeListener);
    }

    public static FileObject getProjectDirectory(PhpProject phpProject) {
        return phpProject.getProjectDirectory();
    }

    public static FileObject getSourcesDirectory(PhpProject phpProject) {
        return phpProject.getSourcesDirectory();
    }

    public static FileObject getWebRootDirectory(PhpProject phpProject) {
        return ProjectPropertiesSupport.getSourceSubdirectory(phpProject, phpProject.getEvaluator().getProperty("web.root"));
    }

    public static FileObject getSourceSubdirectory(PhpProject phpProject, String string) {
        FileObject fileObject = phpProject.getSourcesDirectory();
        if (string != null && string.trim().length() > 0 && !string.equals(".")) {
            fileObject = fileObject.getFileObject(string);
        }
        assert (fileObject != null) : "Subdirectory " + string + " must be found";
        return fileObject;
    }

    public static PhpInterpreter getPhpInterpreter(PhpProject phpProject) {
        String string = phpProject.getEvaluator().getProperty("interpreter");
        if (string != null && string.length() > 0) {
            return new PhpInterpreter(string);
        }
        return new PhpInterpreter(PhpOptions.getInstance().getPhpInterpreter());
    }

    public static boolean isCopySourcesEnabled(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "copy.src.files", false);
    }

    public static File getCopySourcesTarget(PhpProject phpProject) {
        String string = phpProject.getEvaluator().getProperty("copy.src.target");
        if (string != null && string.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        return null;
    }

    public static String getEncoding(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("source.encoding");
    }

    public static boolean areShortTagsEnabled(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "tags.short", true);
    }

    public static boolean areAspTagsEnabled(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "tags.asp", false);
    }

    public static boolean isActiveConfigValid(PhpProject phpProject, boolean bl) {
        boolean bl2 = ProjectPropertiesSupport.validateActiveConfig(phpProject);
        if (!bl2 && bl) {
            ((CustomizerProviderImpl)phpProject.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
        }
        return bl2;
    }

    private static boolean validateActiveConfig(PhpProject phpProject) {
        PhpProjectProperties.RunAsType runAsType = ProjectPropertiesSupport.getRunAs(phpProject);
        if (runAsType == null) {
            return false;
        }
        boolean bl = true;
        String string = ProjectPropertiesSupport.getIndexFile(phpProject);
        switch (runAsType) {
            case LOCAL: {
                if (RunAsValidator.validateWebFields(ProjectPropertiesSupport.getUrl(phpProject), FileUtil.toFile((FileObject)ProjectPropertiesSupport.getWebRootDirectory(phpProject)), string, ProjectPropertiesSupport.getArguments(phpProject)) != null) {
                    bl = false;
                    break;
                }
                if (string != null) break;
                bl = false;
                break;
            }
            case REMOTE: {
                if (RunAsValidator.validateWebFields(ProjectPropertiesSupport.getUrl(phpProject), FileUtil.toFile((FileObject)ProjectPropertiesSupport.getWebRootDirectory(phpProject)), ProjectPropertiesSupport.getIndexFile(phpProject), ProjectPropertiesSupport.getArguments(phpProject)) != null) {
                    bl = false;
                    break;
                }
                if (string == null) {
                    bl = false;
                    break;
                }
                if (ProjectPropertiesSupport.getRemoteConnection(phpProject) == null) {
                    bl = false;
                    break;
                }
                if (RunAsValidator.validateUploadDirectory(ProjectPropertiesSupport.getRemoteDirectory(phpProject), true) == null) break;
                bl = false;
                break;
            }
            case SCRIPT: {
                if (RunAsValidator.validateScriptFields(ProjectPropertiesSupport.getPhpInterpreter(phpProject).getInterpreter(), FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(phpProject)), ProjectPropertiesSupport.getIndexFile(phpProject), ProjectPropertiesSupport.getArguments(phpProject)) != null) {
                    bl = false;
                    break;
                }
                if (string != null) break;
                bl = false;
                break;
            }
            default: {
                assert (false) : "Invalid run configuration type: " + (Object)((Object)runAsType);
                break;
            }
        }
        return bl;
    }

    public static PhpProjectProperties.RunAsType getRunAs(PhpProject phpProject) {
        PhpProjectProperties.RunAsType runAsType = null;
        String string = phpProject.getEvaluator().getProperty("run.as");
        if (string == null) {
            return null;
        }
        try {
            runAsType = PhpProjectProperties.RunAsType.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return runAsType;
    }

    public static String getUrl(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("url");
    }

    public static String getIndexFile(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("index.file");
    }

    public static String getArguments(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("script.arguments");
    }

    public static String getRemoteConnection(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("remote.connection");
    }

    public static String getRemoteDirectory(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("remote.directory");
    }

    public static PhpProjectProperties.UploadFiles getRemoteUpload(PhpProject phpProject) {
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String string = phpProject.getEvaluator().getProperty("remote.upload");
        assert (string != null);
        try {
            uploadFiles = PhpProjectProperties.UploadFiles.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uploadFiles;
    }

    private static boolean getBoolean(PhpProject phpProject, String string, boolean bl) {
        String string2 = phpProject.getEvaluator().getProperty(string);
        if (string2 != null && string2.trim().length() > 0) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }
}

