/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.classpath.CommonPhpSourcePath;
import org.netbeans.modules.php.project.classpath.PhpSourcePathImplementation;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpSourcePath {
    public static final String MIME_TYPE = "text/x-php5";
    public static final String DEBUG_SESSION = "netbeans-xdebug";
    private static final DefaultPhpSourcePath DEFAULT_PHP_SOURCE_PATH = new DefaultPhpSourcePath();
    private static FileObject phpStubsFolder = null;

    private PhpSourcePath() {
    }

    public static FileType getFileType(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file", (Object)fileObject);
        PhpSourcePathImplementation phpSourcePathImplementation = PhpSourcePath.getPhpOptionsForProjectFile(fileObject);
        if (phpSourcePathImplementation != null) {
            return phpSourcePathImplementation.getFileType(fileObject);
        }
        return DEFAULT_PHP_SOURCE_PATH.getFileType(fileObject);
    }

    public static List<FileObject> getPreindexedFolders() {
        if (phpStubsFolder == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-project.jar", null, false);
            if (file != null) {
                File file2 = new File(file.getParentFile().getParentFile().getAbsoluteFile(), "phpstubs/phpruntime");
                assert (file2.exists() && file2.isDirectory()) : "No stubs found";
                phpStubsFolder = FileUtil.toFileObject((File)file2);
            } else {
                String string = System.getProperty("xtest.php.home");
                if (string == null) {
                    throw new RuntimeException("xtest.php.home property has to be set when running within binary distribution");
                }
                File file3 = new File(string + File.separator + "phpstubs/phpruntime");
                if (file3.exists()) {
                    phpStubsFolder = FileUtil.toFileObject((File)file3);
                }
            }
        }
        return Collections.singletonList(phpStubsFolder);
    }

    public static List<FileObject> getIncludePath(FileObject fileObject) {
        if (fileObject == null) {
            return DEFAULT_PHP_SOURCE_PATH.getIncludePath();
        }
        PhpSourcePathImplementation phpSourcePathImplementation = PhpSourcePath.getPhpOptionsForProjectFile(fileObject);
        if (phpSourcePathImplementation != null) {
            return phpSourcePathImplementation.getIncludePath();
        }
        return DEFAULT_PHP_SOURCE_PATH.getIncludePath();
    }

    public static FileObject resolveFile(FileObject fileObject, String string) {
        Parameters.notNull((CharSequence)"directory", (Object)fileObject);
        Parameters.notNull((CharSequence)"fileName", (Object)string);
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("valid directory needed");
        }
        PhpSourcePathImplementation phpSourcePathImplementation = PhpSourcePath.getPhpOptionsForProjectFile(fileObject);
        if (phpSourcePathImplementation != null) {
            return phpSourcePathImplementation.resolveFile(fileObject, string);
        }
        return DEFAULT_PHP_SOURCE_PATH.resolveFile(fileObject, string);
    }

    private static PhpSourcePathImplementation getPhpOptionsForProjectFile(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        PhpSourcePathImplementation phpSourcePathImplementation = (PhpSourcePathImplementation)project.getLookup().lookup(PhpSourcePathImplementation.class);
        return phpSourcePathImplementation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPhpSourcePath
    implements PhpSourcePathImplementation {
        private DefaultPhpSourcePath() {
        }

        @Override
        public FileType getFileType(FileObject fileObject) {
            for (FileObject fileObject2 : CommonPhpSourcePath.getInternalPath()) {
                if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                return FileType.INTERNAL;
            }
            for (FileObject fileObject2 : this.getPlatformPath()) {
                if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                return FileType.INCLUDE;
            }
            return FileType.UNKNOWN;
        }

        @Override
        public List<FileObject> getIncludePath() {
            return new ArrayList<FileObject>(this.getPlatformPath());
        }

        @Override
        public FileObject resolveFile(FileObject fileObject, String string) {
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 != null) {
                return fileObject2;
            }
            for (FileObject fileObject3 : this.getPlatformPath()) {
                fileObject2 = fileObject3.getFileObject(string);
                if (fileObject2 == null) continue;
                return fileObject2;
            }
            return null;
        }

        private List<FileObject> getPlatformPath() {
            String string = PhpOptions.getInstance().getPhpGlobalIncludePath();
            assert (string != null);
            String[] stringArray = PropertyUtils.tokenizePath((String)string);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(stringArray.length);
            for (String string2 : stringArray) {
                FileObject fileObject = FileUtil.toFileObject((File)new File(string2));
                if (fileObject == null) continue;
                arrayList.add(fileObject);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        INTERNAL,
        INCLUDE,
        SOURCE,
        UNKNOWN;

    }
}

