/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.project.connections.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.ui.PasswordPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClient
implements Cancellable {
    private static final Logger LOGGER = Logger.getLogger(RemoteClient.class.getName());
    private static final String NB_METADATA_DIR = "nbproject";
    private static final String[] IGNORED_REMOTE_DIRS = new String[]{".", ".."};
    private static final int TRIES_TO_TRANSFER = 3;
    private static final String TMP_NEW_SUFFIX = ".new~";
    private static final String TMP_OLD_SUFFIX = ".old~";
    private static final Map<Integer, String> PASSWORDS = new HashMap<Integer, String>();
    private final RemoteConfiguration configuration;
    private final InputOutput io;
    private final String baseRemoteDirectory;
    private FTPClient ftpClient;
    private volatile boolean cancelled = false;

    public RemoteClient(RemoteConfiguration remoteConfiguration) {
        this(remoteConfiguration, null, null);
    }

    public RemoteClient(RemoteConfiguration remoteConfiguration, InputOutput inputOutput) {
        this(remoteConfiguration, inputOutput, null);
    }

    public RemoteClient(RemoteConfiguration remoteConfiguration, InputOutput inputOutput, String string) {
        assert (remoteConfiguration != null);
        this.configuration = remoteConfiguration;
        this.io = inputOutput;
        StringBuilder stringBuilder = new StringBuilder(remoteConfiguration.getInitialDirectory());
        if (string != null && string.length() > 0) {
            stringBuilder.append(string);
        }
        this.baseRemoteDirectory = stringBuilder.toString().replaceAll("/{2,}", "/");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Remote client created with configuration: " + remoteConfiguration + " and base remote directory: " + this.baseRemoteDirectory);
        }
    }

    public void connect() throws RemoteException {
        this.init();
        try {
            int n = this.configuration.getTimeout() * 1000;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Connecting to " + this.configuration.getHost() + " [timeout: " + n + " ms]");
            }
            String string = this.getPassword();
            this.ftpClient.setDefaultTimeout(n);
            this.ftpClient.connect(this.configuration.getHost(), this.configuration.getPort());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reply is " + this.getReplyString());
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
                LOGGER.fine("Disconnecting because of negative reply");
                this.ftpClient.disconnect();
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpRefusedConnection", (Object)this.configuration.getHost()), this.getReplyString());
            }
            LOGGER.fine("Login as " + this.configuration.getUserName());
            if (!this.ftpClient.login(this.configuration.getUserName(), string)) {
                LOGGER.fine("Login unusuccessful -> logout");
                this.ftpClient.logout();
                PASSWORDS.remove(this.configuration.hashCode());
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpLoginFailed"), this.getReplyString());
            }
            LOGGER.fine("Login successful");
            if (this.configuration.isPassiveMode()) {
                LOGGER.fine("Setting passive mode");
                this.ftpClient.enterLocalPassiveMode();
            }
            LOGGER.fine("Setting file type to BINARY");
            this.ftpClient.setFileType(2);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Remote system is " + this.ftpClient.getSystemName());
            }
            if (!this.cdBaseRemoteDirectory()) {
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)this.baseRemoteDirectory), this.getReplyString());
            }
        }
        catch (IOException iOException) {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException2) {
                    LOGGER.log(Level.FINE, "Exception while disconnecting", iOException);
                }
            }
            LOGGER.log(Level.FINE, "Exception while connecting", iOException);
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotConnect", (Object)this.configuration.getHost()), iOException, this.getReplyString());
        }
    }

    public void disconnect() throws RemoteException {
        this.init();
        LOGGER.log(Level.FINE, "Remote client trying to disconnect");
        if (this.ftpClient.isConnected()) {
            LOGGER.log(Level.FINE, "Remote client connected -> disconnecting");
            try {
                this.ftpClient.logout();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error while disconnecting", iOException);
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotLogout", (Object)this.configuration.getHost()), iOException, this.getReplyString());
            }
            finally {
                try {
                    this.ftpClient.disconnect();
                    LOGGER.log(Level.FINE, "Remote client disconnected");
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Remote client disconnected with exception", iOException);
                }
            }
        }
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    public void reset() {
        this.cancelled = false;
    }

    public Set<TransferFile> prepareUpload(FileObject fileObject, FileObject ... fileObjectArray) throws RemoteException {
        assert (fileObject != null);
        assert (fileObjectArray != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (fileObjectArray.length > 0) : "At least one file to upload must be specified";
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = file.getAbsolutePath();
        LinkedList<TransferFile> linkedList = new LinkedList<TransferFile>();
        for (FileObject fileArray : fileObjectArray) {
            if (RemoteClient.isVisible(FileUtil.toFile((FileObject)fileArray))) {
                LOGGER.fine("File " + fileArray + " added to upload queue");
                linkedList.offer(TransferFile.fromFileObject(fileArray, string));
                continue;
            }
            LOGGER.fine("File " + fileArray + " NOT added to upload queue [invisible]");
        }
        HashSet hashSet = new HashSet();
        while (!linkedList.isEmpty()) {
            File file2;
            File[] fileArray;
            if (this.cancelled) {
                LOGGER.fine("Prepare upload cancelled");
                break;
            }
            TransferFile transferFile = (TransferFile)linkedList.poll();
            if (!hashSet.add(transferFile)) {
                LOGGER.fine("File " + transferFile + " already in queue");
                continue;
            }
            if (!transferFile.isDirectory() || (fileArray = (file2 = this.getLocalFile(transferFile, file)).listFiles()) == null) continue;
            for (File file3 : fileArray) {
                if (RemoteClient.isVisible(file3)) {
                    LOGGER.fine("File " + file3 + " added to upload queue");
                    linkedList.offer(TransferFile.fromFile(file3, string));
                    continue;
                }
                LOGGER.fine("File " + file3 + " NOT added to upload queue [invisible]");
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Prepared for upload: " + hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo upload(FileObject fileObject, Set<TransferFile> set) throws RemoteException {
        assert (fileObject != null);
        assert (set != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (set.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long l = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            for (TransferFile transferFile : set) {
                if (this.cancelled) {
                    LOGGER.fine("Upload cancelled");
                    break;
                }
                try {
                    this.uploadFile(transferInfo, file, transferFile);
                }
                catch (IOException iOException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpErrorReason", (Object)iOException.getMessage().trim()));
                }
                catch (RemoteException remoteException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpErrorReason", (Object)remoteException.getMessage().trim()));
                }
            }
        }
        finally {
            transferInfo.setRuntime(System.currentTimeMillis() - l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadFile(TransferInfo transferInfo, File file, TransferFile transferFile) throws IOException, RemoteException {
        if (transferFile.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Uploading directory: " + transferFile);
            }
            this.cdBaseRemoteDirectory(transferFile.getRelativePath(), true);
            this.transferSucceeded(transferInfo, transferFile);
            return;
        }
        assert (transferFile.getParentRelativePath() != null) : "Must be underneath base remote directory! [" + transferFile + "]";
        if (!this.cdBaseRemoteDirectory(transferFile.getParentRelativePath(), true)) {
            this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)transferFile.getParentRelativePath()));
            return;
        }
        String string2 = transferFile.getName();
        String string = string2 + TMP_NEW_SUFFIX;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Uploading file " + string2 + " => " + this.ftpClient.printWorkingDirectory() + "/" + string);
        }
        FileInputStream fileInputStream = new FileInputStream(new File(file, transferFile.getRelativePath(true)));
        boolean bl = false;
        try {
            for (int i = 1; i <= 3; ++i) {
                if (this.ftpClient.storeFile(string, (InputStream)fileInputStream)) {
                    bl = true;
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine(String.format("The %d. attempt to upload '%s' was successful", i, transferFile.getRelativePath() + TMP_NEW_SUFFIX));
                    break;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("The %d. attempt to upload '%s' was NOT successful", i, transferFile.getRelativePath() + TMP_NEW_SUFFIX));
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((InputStream)fileInputStream).close();
            if (bl) {
                bl = this.moveRemoteFile(string2, string);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("File %s renamed to %s: %s", string, string2, bl));
                }
            }
            if (bl) {
                this.transferSucceeded(transferInfo, transferFile);
                throw throwable;
            } else {
                this.transferFailed(transferInfo, transferFile, this.getFailureMessage(string2, true));
                boolean bl3 = this.ftpClient.deleteFile(string);
                if (!LOGGER.isLoggable(Level.FINE)) throw throwable;
                LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", transferFile.getRelativePath() + TMP_NEW_SUFFIX, bl3));
            }
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        if (bl) {
            bl = this.moveRemoteFile(string2, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("File %s renamed to %s: %s", string, string2, bl));
            }
        }
        if (bl) {
            this.transferSucceeded(transferInfo, transferFile);
            return;
        }
        this.transferFailed(transferInfo, transferFile, this.getFailureMessage(string2, true));
        boolean bl2 = this.ftpClient.deleteFile(string);
        if (!LOGGER.isLoggable(Level.FINE)) return;
        LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", transferFile.getRelativePath() + TMP_NEW_SUFFIX, bl2));
    }

    private boolean moveRemoteFile(String string, String string2) throws IOException {
        String string3 = string + TMP_OLD_SUFFIX;
        boolean bl = this.ftpClient.rename(string2, string);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("File %s directly renamed to %s: %s", string2, string, bl));
        }
        if (bl) {
            return true;
        }
        this.ftpClient.deleteFile(string3);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
        }
        bl = this.ftpClient.rename(string, string3);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(1) File %s renamed to %s: %s", string, string3, bl));
        }
        if (!bl) {
            return false;
        }
        bl = this.ftpClient.rename(string2, string);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(2) File %s renamed to %s: %s", string2, string, bl));
        }
        if (!bl) {
            boolean bl2 = this.ftpClient.rename(string3, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(-) File %s restored to original %s: %s", string3, string, bl2));
            }
        } else {
            boolean bl3 = this.ftpClient.deleteFile(string3);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(3) File %s deleted: %s", string3, bl3));
            }
        }
        return bl;
    }

    public Set<TransferFile> prepareDownload(FileObject fileObject, FileObject ... fileObjectArray) throws RemoteException {
        assert (fileObject != null);
        assert (fileObjectArray != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (fileObjectArray.length > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = file.getAbsolutePath();
        LinkedList<TransferFile> linkedList = new LinkedList<TransferFile>();
        for (Object object : fileObjectArray) {
            if (RemoteClient.isVisible(FileUtil.toFile((FileObject)object))) {
                LOGGER.fine("File " + object + " added to download queue");
                linkedList.offer(TransferFile.fromFileObject(object, string));
                continue;
            }
            LOGGER.fine("File " + object + " NOT added to download queue [invisible]");
        }
        HashSet hashSet = new HashSet();
        while (!linkedList.isEmpty()) {
            if (this.cancelled) {
                LOGGER.fine("Prepare download cancelled");
                break;
            }
            TransferFile transferFile = (TransferFile)linkedList.poll();
            if (!hashSet.add(transferFile)) {
                LOGGER.fine("File " + transferFile + " already in queue");
                continue;
            }
            if (!transferFile.isDirectory()) continue;
            try {
                Object object;
                if (!this.cdBaseRemoteDirectory(transferFile.getRelativePath(), false)) {
                    LOGGER.fine("Remote directory " + transferFile.getRelativePath() + " cannot be entered or does not exist => ignoring");
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(this.baseRemoteDirectory);
                if (transferFile.getRelativePath() != ".") {
                    stringBuilder.append("/");
                    stringBuilder.append(transferFile.getRelativePath());
                }
                object = stringBuilder.toString();
                for (FTPFile fTPFile : this.ftpClient.listFiles()) {
                    if (this.isVisible(fTPFile)) {
                        LOGGER.fine("File " + transferFile + " added to download queue");
                        linkedList.offer(TransferFile.fromFtpFile(fTPFile, this.baseRemoteDirectory, (String)object));
                        continue;
                    }
                    LOGGER.fine("File " + transferFile + " NOT added to download queue [invisible]");
                }
            }
            catch (IOException iOException) {
                LOGGER.fine("Remote directory " + transferFile.getRelativePath() + "/* cannot be entered or does not exist => ignoring");
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Prepared for download: " + hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo download(FileObject fileObject, Set<TransferFile> set) throws RemoteException {
        assert (fileObject != null);
        assert (set != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (set.size() > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        long l = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            for (TransferFile transferFile : set) {
                if (this.cancelled) {
                    LOGGER.fine("Download cancelled");
                    break;
                }
                try {
                    this.downloadFile(transferInfo, file, transferFile);
                }
                catch (IOException iOException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpErrorReason", (Object)iOException.getMessage().trim()));
                }
                catch (RemoteException remoteException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpErrorReason", (Object)remoteException.getMessage().trim()));
                }
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            FileUtil.refreshFor((File[])new File[]{file});
            transferInfo.setRuntime(System.currentTimeMillis() - l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
            throw throwable;
        }
        FileUtil.refreshFor((File[])new File[]{file});
        transferInfo.setRuntime(System.currentTimeMillis() - l);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(transferInfo.toString());
        }
        return transferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(TransferInfo transferInfo, File file, TransferFile transferFile) throws IOException, RemoteException {
        block30: {
            block31: {
                File file2;
                block29: {
                    file2 = this.getLocalFile(transferFile, file);
                    if (!transferFile.isDirectory()) break block29;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Downloading directory: " + transferFile);
                    }
                    if (!this.cdBaseRemoteDirectory(transferFile.getRelativePath(), false)) {
                        LOGGER.fine("Remote directory " + transferFile.getRelativePath() + " does not exist => ignoring");
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)transferFile.getRelativePath()));
                        return;
                    }
                    if (!file2.exists()) {
                        if (!RemoteClient.mkLocalDirs(file2)) {
                            this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)file2));
                            return;
                        }
                    } else if (file2.isFile()) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)transferFile));
                        return;
                    }
                    this.transferSucceeded(transferInfo, transferFile);
                    break block30;
                }
                if (!transferFile.isFile()) break block31;
                File file3 = file2.getParentFile();
                assert (file3 != null) : "File " + file2 + " has no parent file?!";
                if (!file3.exists()) {
                    if (!RemoteClient.mkLocalDirs(file3)) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)file3));
                        return;
                    }
                } else {
                    if (file3.isFile()) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)transferFile));
                        return;
                    }
                    if (file2.exists() && !file2.canWrite()) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotWritable", (Object)file2));
                        return;
                    }
                }
                assert (file3.isDirectory()) : "Parent file of " + file2 + " must be a directory";
                File file4 = new File(file2.getAbsolutePath() + TMP_NEW_SUFFIX);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Downloading " + transferFile.getRelativePath() + " => " + file4.getAbsolutePath());
                }
                if (!this.cdBaseRemoteDirectory(transferFile.getParentRelativePath(), false)) {
                    LOGGER.fine("Remote directory " + transferFile.getParentRelativePath() + " does not exist => ignoring file " + transferFile.getRelativePath());
                    this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)transferFile.getParentRelativePath()));
                    return;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                boolean bl = false;
                try {
                    for (int i = 1; i <= 3; ++i) {
                        if (this.ftpClient.retrieveFile(transferFile.getName(), (OutputStream)fileOutputStream)) {
                            bl = true;
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine(String.format("The %d. attempt to download '%s' was successful", i, transferFile.getRelativePath()));
                            break;
                        }
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine(String.format("The %d. attempt to download '%s' was NOT successful", i, transferFile.getRelativePath()));
                    }
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    ((OutputStream)fileOutputStream).close();
                    if (bl) {
                        bl = this.moveLocalFile(file2, file4);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("File %s renamed to %s: %s", file4, file2, bl));
                        }
                    }
                    if (bl) {
                        this.transferSucceeded(transferInfo, transferFile);
                    } else {
                        this.transferFailed(transferInfo, transferFile, this.getFailureMessage(transferFile.getName(), false));
                        boolean bl2 = file4.delete();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Unsuccessfully downloaded file %s deleted: %s", file4, bl2));
                        }
                    }
                    throw throwable;
                }
                ((OutputStream)fileOutputStream).close();
                if (bl) {
                    bl = this.moveLocalFile(file2, file4);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s renamed to %s: %s", file4, file2, bl));
                    }
                }
                if (bl) {
                    this.transferSucceeded(transferInfo, transferFile);
                } else {
                    this.transferFailed(transferInfo, transferFile, this.getFailureMessage(transferFile.getName(), false));
                    boolean bl3 = file4.delete();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Unsuccessfully downloaded file %s deleted: %s", file4, bl3));
                    }
                }
                break block30;
            }
            this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpUnknownFileType", (Object)transferFile.getRelativePath()));
        }
    }

    private boolean moveLocalFile(final File file, final File file2) {
        final boolean[] blArray = new boolean[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            public void run() {
                File file3 = new File(file.getAbsolutePath() + RemoteClient.TMP_OLD_SUFFIX);
                String string = file2.getName();
                String string2 = file.getName();
                String string3 = file3.getName();
                if (!file.exists()) {
                    blArray[0] = RemoteClient.renameLocalFileTo(file2, file);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s directly renamed to %s: %s", string, string2, blArray[0]));
                    }
                    if (blArray[0]) {
                        return;
                    }
                }
                RemoteClient.this.deleteLocalFile(file3, "");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
                }
                blArray[0] = file.renameTo(file3);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("(1) File %s renamed to %s: %s", string2, string3, blArray[0]));
                }
                if (!blArray[0]) {
                    return;
                }
                blArray[0] = RemoteClient.renameLocalFileTo(file2, file);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("(2) File %s renamed to %s: %s", string, string2, blArray[0]));
                }
                if (!blArray[0] && file3.exists() && !file.exists()) {
                    boolean bl = RemoteClient.renameLocalFileTo(file3, file);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("(-) File %s restored to original %s: %s", string3, string2, bl));
                    }
                    return;
                }
                RemoteClient.this.deleteLocalFile(file3, "(3) ");
            }
        });
        assert (blArray[0] || !blArray[0]);
        return blArray[0];
    }

    private File getLocalFile(TransferFile transferFile, File file) {
        if (transferFile.getRelativePath() == ".") {
            return file;
        }
        return new File(file, transferFile.getRelativePath(true));
    }

    private void transferSucceeded(TransferInfo transferInfo, TransferFile transferFile) {
        transferInfo.addTransfered(transferFile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Transfered: " + transferFile);
        }
    }

    private void transferFailed(TransferInfo transferInfo, TransferFile transferFile, String string) {
        if (!transferInfo.isFailed(transferFile)) {
            transferInfo.addFailed(transferFile, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Failed: " + transferFile + ", reason: " + string);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Failed: " + transferFile + ", reason: " + string + " [ignored, failed already]");
        }
    }

    private void transferIgnored(TransferInfo transferInfo, TransferFile transferFile, String string) {
        if (!transferInfo.isIgnored(transferFile)) {
            transferInfo.addIgnored(transferFile, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Ignored: " + transferFile + ", reason: " + string);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Ignored: " + transferFile + ", reason: " + string + " [ignored, ignored already]");
        }
    }

    private String getFailureMessage(String string, boolean bl) {
        String string2 = null;
        int n = this.ftpClient.getReplyCode();
        string2 = FTPReply.isNegativePermanent((int)n) || FTPReply.isNegativeTransient((int)n) ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpErrorReason", (Object)this.getReplyString()) : NbBundle.getMessage(RemoteClient.class, (String)(bl ? "MSG_FtpCannotUploadFile" : "MSG_FtpCannotDownloadFile"), (Object)string);
        return string2;
    }

    private void init() {
        if (this.ftpClient != null) {
            return;
        }
        LOGGER.log(Level.FINE, "FTP client creating");
        this.ftpClient = new FTPClient();
        if (this.io != null) {
            this.ftpClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(this.io));
        }
        LOGGER.log(Level.FINE, "Protocol command listener added");
    }

    private void ensureConnected() throws RemoteException {
        this.init();
        if (!this.ftpClient.isConnected()) {
            LOGGER.fine("Client not connected -> connecting");
            this.connect();
        }
    }

    private boolean cdBaseRemoteDirectory() throws IOException, RemoteException {
        return this.cdRemoteDirectory(this.baseRemoteDirectory, true);
    }

    private boolean cdBaseRemoteDirectory(String string, boolean bl) throws IOException, RemoteException {
        assert (string == null || !string.startsWith("/")) : "Subdirectory must be null or relative [" + string + "]";
        String string2 = this.baseRemoteDirectory;
        if (string != null && !string.equals(".")) {
            string2 = this.baseRemoteDirectory + "/" + string;
        }
        return this.cdRemoteDirectory(string2, bl);
    }

    private boolean cdRemoteDirectory(String string, boolean bl) throws IOException, RemoteException {
        LOGGER.fine("Changing directory to " + string);
        boolean bl2 = this.ftpClient.changeWorkingDirectory(string);
        if (!bl2 && bl) {
            return this.createAndCdRemoteDirectory(string);
        }
        return bl2;
    }

    private boolean createAndCdRemoteDirectory(String string) throws IOException, RemoteException {
        LOGGER.fine("Creating file path " + string);
        if (string.startsWith("/") && !this.ftpClient.changeWorkingDirectory("/")) {
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)"/"), this.getReplyString());
        }
        for (String string2 : string.split("/")) {
            if (string2.length() == 0 || this.ftpClient.changeWorkingDirectory(string2)) continue;
            if (!this.ftpClient.makeDirectory(string2)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cannot create directory: " + this.ftpClient.printWorkingDirectory() + "/" + string2);
                }
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_FtpCannotCreateDirectory", (Object)string2), this.getReplyString());
            }
            if (!this.ftpClient.changeWorkingDirectory(string2)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cannot enter directory: " + this.ftpClient.printWorkingDirectory() + "/" + string2);
                }
                return false;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Directory '" + this.ftpClient.printWorkingDirectory() + "' created and entered");
        }
        return true;
    }

    private String getPassword() {
        String string = this.configuration.getPassword();
        assert (string != null);
        if (string.length() > 0) {
            return string;
        }
        string = PASSWORDS.get(this.configuration.hashCode());
        if (string != null) {
            return string;
        }
        PasswordPanel passwordPanel = new PasswordPanel(this.configuration.getUserName());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)passwordPanel, NbBundle.getMessage(RemoteClient.class, (String)"LBL_EnterPassword", (Object)this.configuration.getDisplayName()));
        dialogDescriptor.setOptions(new Object[]{passwordPanel.getOKButton(), passwordPanel.getCancelButton()});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == passwordPanel.getOKButton()) {
            string = passwordPanel.getPassword();
            PASSWORDS.put(this.configuration.hashCode(), string);
            return string;
        }
        return "";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [remote configuration: ");
        stringBuilder.append(this.configuration);
        stringBuilder.append(", baseRemoteDirectory: ");
        stringBuilder.append(this.baseRemoteDirectory);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static boolean isVisible(File file) {
        assert (file != null);
        if (file.getName().equals(NB_METADATA_DIR)) {
            return false;
        }
        return VisibilityQuery.getDefault().isVisible(file);
    }

    private boolean isVisible(FTPFile fTPFile) {
        if (fTPFile == null) {
            return false;
        }
        if (fTPFile.isDirectory()) {
            String string = fTPFile.getName();
            for (String string2 : IGNORED_REMOTE_DIRS) {
                if (!string.equals(string2)) continue;
                return false;
            }
        }
        return true;
    }

    private String getReplyString() {
        String string = this.ftpClient.getReplyString();
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    private static boolean mkLocalDirs(File file) {
        try {
            FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean renameLocalFileTo(File file, File file2) {
        boolean bl;
        long l;
        block11: {
            l = 0L;
            if (LOGGER.isLoggable(Level.FINE)) {
                l = System.currentTimeMillis();
            }
            assert (file.exists()) : "Source file must exist " + file;
            assert (!file2.exists()) : "Target file cannot exist " + file2;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            assert (fileObject != null) : "Source fileobject must exist " + file;
            String string = RemoteClient.getName(file2.getName());
            String string2 = FileUtil.getExtension((String)file2.getName());
            bl = false;
            try {
                FileLock fileLock = fileObject.lock();
                try {
                    try {
                        fileObject.rename(fileLock, string, string2);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, null, iOException);
                        Object var11_10 = null;
                        fileLock.releaseLock();
                        break block11;
                    }
                    Object var11_9 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                fileLock.releaseLock();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Move %s -> %s took: %sms", file, file2, System.currentTimeMillis() - l));
        }
        return bl;
    }

    private void deleteLocalFile(File file, String string) {
        if (!file.exists()) {
            return;
        }
        boolean bl = file.delete();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format(string + "File %s deleted: %s", file.getName(), bl));
        }
    }

    private static String getName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static class PrintCommandListener
    implements ProtocolCommandListener {
        private final InputOutput io;

        public PrintCommandListener(InputOutput inputOutput) {
            assert (inputOutput != null);
            this.io = inputOutput;
        }

        public void protocolCommandSent(ProtocolCommandEvent protocolCommandEvent) {
            this.processEvent(protocolCommandEvent);
        }

        public void protocolReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
            this.processEvent(protocolCommandEvent);
        }

        private void processEvent(ProtocolCommandEvent protocolCommandEvent) {
            String string = protocolCommandEvent.getMessage();
            if (string.startsWith("PASS ")) {
                string = "PASS ******\n";
            }
            if (protocolCommandEvent.isReply() && (FTPReply.isNegativeTransient((int)protocolCommandEvent.getReplyCode()) || FTPReply.isNegativePermanent((int)protocolCommandEvent.getReplyCode()))) {
                this.io.getErr().print(string);
                this.io.getErr().flush();
            } else {
                this.io.getOut().print(string);
                this.io.getOut().flush();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Command listener: " + string.trim());
            }
        }
    }
}

