/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;

public final class RemoteConfiguration {
    private final String displayName;
    private final String name;
    private final RemoteConnections.ConnectionType connectionType;
    private final String host;
    private final int port;
    private final String userName;
    private final String password;
    private final boolean anonymousLogin;
    private final String initialDirectory;
    private final String pathSeparator;
    private final int timeout;
    private final boolean passiveMode;

    public RemoteConfiguration(String string) {
        this(string, "", RemoteConnections.ConnectionType.FTP, "", 1, "", "", false, "", "/", 0, false);
    }

    public RemoteConfiguration(String string, String string2, RemoteConnections.ConnectionType connectionType, String string3, int n, String string4, String string5, boolean bl, String string6, String string7, int n2, boolean bl2) {
        assert (string != null);
        assert (string2 != null);
        assert (connectionType != null);
        assert (string3 != null);
        assert (n > 0);
        assert (string4 != null);
        assert (string5 != null);
        assert (string6 != null);
        assert (string7 != null);
        assert (n2 >= 0);
        if (string6.trim().length() == 0) {
            string6 = string7;
        }
        this.displayName = string;
        this.name = string2;
        this.connectionType = connectionType;
        this.host = string3;
        this.port = n;
        this.userName = string4;
        this.password = string5;
        this.anonymousLogin = bl;
        this.initialDirectory = string6;
        this.pathSeparator = string7;
        this.timeout = n2;
        this.passiveMode = bl2;
    }

    RemoteConfiguration(ConfigManager.Configuration configuration) {
        assert (configuration.getName() != null);
        this.displayName = configuration.getDisplayName();
        this.name = configuration.getName();
        this.connectionType = RemoteConnections.ConnectionType.valueOf(configuration.getValue("type"));
        this.host = configuration.getValue("host");
        this.port = Integer.parseInt(configuration.getValue("port"));
        this.userName = configuration.getValue("user");
        this.password = configuration.getValue("password", true);
        this.anonymousLogin = Boolean.valueOf(configuration.getValue("anonymousLogin"));
        this.initialDirectory = configuration.getValue("initialDirectory");
        this.pathSeparator = configuration.getValue("pathSeparator");
        this.timeout = Integer.parseInt(configuration.getValue("timeout"));
        this.passiveMode = Boolean.valueOf(configuration.getValue("passiveMode"));
    }

    public boolean isAnonymousLogin() {
        return this.anonymousLogin;
    }

    public RemoteConnections.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHost() {
        return this.host;
    }

    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public String getUserName() {
        if (this.anonymousLogin) {
            return "anonymous";
        }
        return this.userName;
    }

    public String getPassword() {
        if (this.anonymousLogin) {
            return "nobody@nowhere.net";
        }
        return this.password != null ? this.password : "";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [displayName: ");
        stringBuilder.append(this.displayName);
        stringBuilder.append(", name: ");
        stringBuilder.append(this.name);
        stringBuilder.append(", connectionType: ");
        stringBuilder.append((Object)this.connectionType);
        stringBuilder.append(", host: ");
        stringBuilder.append(this.host);
        stringBuilder.append(", port: ");
        stringBuilder.append(this.port);
        stringBuilder.append(", userName: ");
        stringBuilder.append(this.getUserName());
        stringBuilder.append(", password: *****");
        stringBuilder.append(", anonymousLogin: ");
        stringBuilder.append(this.anonymousLogin);
        stringBuilder.append(", initialDirectory: ");
        stringBuilder.append(this.initialDirectory);
        stringBuilder.append(", pathSeparator: ");
        stringBuilder.append(this.pathSeparator);
        stringBuilder.append(", timeout: ");
        stringBuilder.append(this.timeout);
        stringBuilder.append(", passiveMode: ");
        stringBuilder.append(this.passiveMode);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)object;
        if (!(this.name == remoteConfiguration.name || this.name != null && this.name.equals(remoteConfiguration.name))) {
            return false;
        }
        if (!(this.host == remoteConfiguration.host || this.host != null && this.host.equals(remoteConfiguration.host))) {
            return false;
        }
        if (this.port != remoteConfiguration.port) {
            return false;
        }
        if (!(this.userName == remoteConfiguration.userName || this.userName != null && this.userName.equals(remoteConfiguration.userName))) {
            return false;
        }
        return this.password == remoteConfiguration.password || this.password != null && this.password.equals(remoteConfiguration.password);
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 97 * n + (this.host != null ? this.host.hashCode() : 0);
        n = 97 * n + this.port;
        n = 97 * n + (this.userName != null ? this.userName.hashCode() : 0);
        n = 97 * n + (this.password != null ? this.password.hashCode() : 0);
        return n;
    }
}

