/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.ui.TransferFileDownloadModel;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableModel;
import org.netbeans.modules.php.project.connections.ui.TransferFileUnit;
import org.netbeans.modules.php.project.connections.ui.TransferFileUploadModel;
import org.netbeans.modules.php.project.connections.ui.TransferFilterTable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferFilter
extends JPanel {
    private TransferFilterTable table = null;
    private TransferFileTableModel model = null;
    private DocumentListener dlForSearch;
    private FocusListener flForSearch;
    private String filter = "";
    private PopupActionSupport popupActionsSupport;
    private static final RequestProcessor SEARCH_PROCESSOR = new RequestProcessor("search-processor");
    private final RequestProcessor.Task searchTask = SEARCH_PROCESSOR.create(new Runnable(){

        public void run() {
            if (TransferFilter.this.filter != null) {
                int n = TransferFilter.this.getSelectedRow();
                final TransferFileUnit transferFileUnit = n >= 0 ? TransferFilter.this.getModel().getUnitAtRow(n) : null;
                final Map<Integer, Boolean> map = TransferFileTableModel.captureState(TransferFilter.this.model.getData());
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (transferFileUnit != null) {
                            int n = TransferFilter.this.findRow(transferFileUnit.getId());
                            TransferFilter.this.restoreSelectedRow(n);
                        }
                        List<TransferFileUnit> list = TransferFilter.this.model.getData();
                        TransferFilter.this.model;
                        TransferFileTableModel.restoreState(list, map, TransferFileTableModel.isMarkedAsDefault());
                        TransferFilter.this.refreshState();
                    }
                };
                TransferFilter.this.model.setFilter(TransferFilter.this.filter, runnable);
            }
        }
    });
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel lSearch;
    private JLabel lSelectionInfo;
    private JLabel lWarning;
    private JTextField tfSearch;

    public static Set<TransferFile> showUploadDialog(Set<TransferFile> set, long l) {
        return TransferFilter.showTransferDialog(set, TransferFileTableModel.Type.UPLOAD, l);
    }

    public static Set<TransferFile> showDownloadDialog(Set<TransferFile> set) {
        return TransferFilter.showTransferDialog(set, TransferFileTableModel.Type.DOWNLOAD, -1L);
    }

    private static Set<TransferFile> showTransferDialog(Set<TransferFile> set, TransferFileTableModel.Type type, long l) {
        TransferFileUploadModel transferFileUploadModel = null;
        String string = null;
        switch (type) {
            case DOWNLOAD: {
                transferFileUploadModel = new TransferFileDownloadModel(TransferFilter.wrapTransferFiles(set, transferFileUploadModel));
                string = NbBundle.getMessage(TransferFilter.class, (String)"Download_Title");
                break;
            }
            case UPLOAD: {
                transferFileUploadModel = new TransferFileUploadModel(TransferFilter.wrapTransferFiles(set, l));
                string = NbBundle.getMessage(TransferFilter.class, (String)"Upload_Title");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        TransferFilter transferFilter = new TransferFilter(new TransferFilterTable(transferFileUploadModel));
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TransferFilter.class, (String)"LBL_Ok"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)transferFilter, string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton) {
            return TransferFilter.unwrapFileUnits(transferFileUploadModel.getFilteredUnits());
        }
        return Collections.emptySet();
    }

    private static List<TransferFileUnit> wrapTransferFiles(Collection<TransferFile> collection, TransferFileTableModel transferFileTableModel) {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>();
        for (TransferFile transferFile : collection) {
            arrayList.add(new TransferFileUnit(transferFile, transferFileTableModel.isMarkedAsDefault()));
        }
        return arrayList;
    }

    private static List<TransferFileUnit> wrapTransferFiles(Collection<TransferFile> collection, long l) {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>();
        boolean bl = l == -1L;
        for (TransferFile transferFile : collection) {
            if (l != -1L) {
                bl = transferFile.isFile() && transferFile.getTimestamp() > l;
            }
            arrayList.add(new TransferFileUnit(transferFile, bl));
        }
        return arrayList;
    }

    private static Set<TransferFile> unwrapFileUnits(List<TransferFileUnit> list) {
        HashSet<TransferFile> hashSet = new HashSet<TransferFile>();
        for (TransferFileUnit transferFileUnit : list) {
            hashSet.add(transferFileUnit.getTransferFile());
        }
        return hashSet;
    }

    private TransferFilter(TransferFilterTable transferFilterTable) {
        this.table = transferFilterTable;
        TableModel tableModel = transferFilterTable.getModel();
        assert (tableModel instanceof TransferFileTableModel) : tableModel + " instanceof FileConfirmationTableModel.";
        this.model = (TransferFileTableModel)tableModel;
        transferFilterTable.getSelectionModel().setSelectionMode(0);
        this.initComponents();
        this.initTab();
        this.listenOnSelection();
        this.refreshState();
        this.addUpdateUnitListener(new TransferFileTableChangeListener(){

            public void updateUnitsChanged() {
                TransferFilter.this.model.fireTableDataChanged();
                TransferFilter.this.refreshState();
            }

            public void buttonsChanged() {
            }

            public void filterChanged() {
                TransferFilter.this.model.fireTableDataChanged();
                TransferFilter.this.refreshState();
            }
        });
    }

    void focusTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferFilter.this.table.requestFocusInWindow();
            }
        });
    }

    TransferFileTableModel getModel() {
        return this.model;
    }

    TransferFilterTable getTable() {
        return this.table;
    }

    public String getHelpId() {
        return TransferFilter.class.getName() + '.' + (Object)((Object)this.model.getType());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.focusTable();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
        if (this.flForSearch == null) {
            this.flForSearch = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    TransferFilter.this.tfSearch.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    TransferFilter.this.tfSearch.select(0, 0);
                }
            };
            this.tfSearch.addFocusListener(this.flForSearch);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.dlForSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        }
        this.dlForSearch = null;
        if (this.flForSearch != null) {
            this.tfSearch.removeFocusListener(this.flForSearch);
        }
        this.flForSearch = null;
    }

    public void refreshState() {
        List<TransferFileUnit> list = this.model.getMarkedFileUnits();
        this.popupActionsSupport.tableDataChanged();
        if (list.size() == 0) {
            this.cleanSelectionInfo();
        } else {
            this.setSelectionInfo(list.size());
        }
    }

    private void initTab() {
        TabAction[] tabActionArray = null;
        switch (this.model.getType()) {
            case DOWNLOAD: 
            case UPLOAD: {
                tabActionArray = new TabAction[]{new CheckAllAction(), new UncheckAllAction(), new CheckAction()};
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TransferFilter.this.refreshState();
            }
        });
        this.popupActionsSupport = new PopupActionSupport(tabActionArray);
        this.table.addMouseListener(this.popupActionsSupport);
    }

    private void cleanSelectionInfo() {
        this.lSelectionInfo.setText(" ");
        this.lWarning.setText(" ");
        this.lWarning.setIcon(null);
    }

    private void setSelectionInfo(int n) {
        String string = null;
        switch (this.model.getType()) {
            case UPLOAD: {
                string = "FileConfirmationTableModel_Warning_Upload";
                break;
            }
            case DOWNLOAD: {
                string = "FileConfirmationTableModel_Warning_Download";
            }
        }
        String string2 = n == 1 ? "FileConfirmationPane_lHowManySelected_Single_Text" : "FileConfirmationPane_lHowManySelected_Many_Text";
        this.lSelectionInfo.setText(NbBundle.getMessage(TransferFilter.class, (String)string2, (Object)n));
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/info_icon.png");
        this.lWarning.setIcon(new ImageIcon(image));
        this.lWarning.setText(NbBundle.getMessage(TransferFilter.class, (String)string));
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    TransferFilter.this.popupActionsSupport.rowChanged(-1);
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    TransferFilter.this.popupActionsSupport.rowChanged(n);
                }
            }
        });
    }

    public void addUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.model.addUpdateUnitListener(transferFileTableChangeListener);
    }

    public void removeUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.model.removeUpdateUnitListener(transferFileTableChangeListener);
    }

    void fireUpdataUnitChange() {
        this.model.fireUpdataUnitChange();
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    TransferFilter.this.filter = TransferFilter.this.tfSearch.getText().trim();
                    TransferFilter.this.searchTask.schedule(350);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
        }
        return this.dlForSearch;
    }

    private void initComponents() {
        this.lSelectionInfo = new JLabel();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.table;
        this.lWarning = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return TransferFilter.this.tfSearch;
            }

            public Component getFirstComponent(Container container) {
                return TransferFilter.this.tfSearch;
            }

            public Component getLastComponent(Container container) {
                return TransferFilter.this.tfSearch;
            }

            public Component getComponentAfter(Container container, Component component) {
                return TransferFilter.this.tfSearch;
            }

            public Component getComponentBefore(Container container, Component component) {
                return TransferFilter.this.tfSearch;
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lSelectionInfo, (String)NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSelectionInfo.text"));
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(TransferFilter.class, (String)"lSearch1.text"));
        this.jTable1.setModel(this.table.getModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jTable1.AccessibleContext.accessibleName"));
        this.jTable1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jTable1.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lWarning).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lSearch).add(4, 4, 4).add((Component)this.tfSearch, -2, 114, -2)).add(1, (Component)this.lSelectionInfo).add(1, (Component)this.jScrollPane1, -1, 558, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.tfSearch, -2, -1, -2).add((Component)this.lSearch)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 252, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lSelectionInfo, -1, -1, Short.MAX_VALUE).add((Component)this.lWarning)).addContainerGap()));
        this.lSelectionInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSelectionInfo.AccessibleContext.accessibleName"));
        this.lSelectionInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSelectionInfo.AccessibleContext.accessibleDescription"));
        this.lSearch.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSearch.AccessibleContext.accessibleName"));
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"ACD_Search"));
        this.tfSearch.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.tfSearch.AccessibleContext.accessibleName"));
        this.tfSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.tfSearch.AccessibleContext.accessibleDescription"));
        this.jScrollPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jScrollPane1.AccessibleContext.accessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.lWarning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lWarning.AccessibleContext.accessibleName"));
        this.lWarning.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lWarning.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.AccessibleContext.accessibleDescription"));
    }

    private void showPopup(Point point, Component component) {
        int n = this.table.rowAtPoint(point);
        if (n >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
            JPopupMenu jPopupMenu = this.popupActionsSupport.createPopup();
            if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.show(component, point.x, point.y);
            }
        }
    }

    private int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    private void restoreSelectedRow(int n) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i >= 0; --i) {
            if (i >= this.table.getRowCount() || i <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    int findRow(Integer n) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            TransferFileUnit transferFileUnit = this.model.getUnitAtRow(i);
            if (transferFileUnit == null || !n.equals(transferFileUnit.getId())) continue;
            return i;
        }
        return -1;
    }

    static String textForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TransferFilter.class, (String)string));
        return jButton.getText();
    }

    static int mnemonicForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TransferFilter.class, (String)string));
        return jButton.getMnemonic();
    }

    private class CheckAction
    extends RowTabAction {
        public CheckAction() {
            super("FileConfirmationPane_CheckAction", KeyStroke.getKeyStroke(32, 0), null);
        }

        public void performerImpl(TransferFileUnit transferFileUnit) {
            int n = TransferFilter.this.getSelectedRow();
            if (transferFileUnit != null && transferFileUnit.canBeMarked()) {
                transferFileUnit.setMarked(!transferFileUnit.isMarked());
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(TransferFileUnit transferFileUnit) {
            return transferFileUnit != null && transferFileUnit.canBeMarked();
        }

        protected String getContextName(TransferFileUnit transferFileUnit) {
            return this.getActionName();
        }

        protected boolean isVisible(TransferFileUnit transferFileUnit) {
            return false;
        }

        protected boolean isVisible(int n) {
            return false;
        }
    }

    private class CheckAllAction
    extends RowTabAction {
        public CheckAllAction() {
            super("FileConfirmationPane_CheckAllAction", "Check");
        }

        public void performerImpl(TransferFileUnit transferFileUnit) {
            int n = TransferFilter.this.getSelectedRow();
            List<TransferFileUnit> list = TransferFilter.this.model.getVisibleFileUnits();
            for (TransferFileUnit transferFileUnit2 : list) {
                if (transferFileUnit2 == null || transferFileUnit2.isMarked() || !transferFileUnit2.canBeMarked()) continue;
                transferFileUnit2.setMarked(true);
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(TransferFileUnit transferFileUnit) {
            return true;
        }

        protected String getContextName(TransferFileUnit transferFileUnit) {
            return this.getActionName();
        }
    }

    private class UncheckAllAction
    extends RowTabAction {
        public UncheckAllAction() {
            super("FileConfirmationPane_UncheckAllAction", "Uncheck");
        }

        public void performerImpl(TransferFileUnit transferFileUnit) {
            int n = TransferFilter.this.getSelectedRow();
            List<TransferFileUnit> list = TransferFilter.this.model.getVisibleFileUnits();
            for (TransferFileUnit transferFileUnit2 : list) {
                if (transferFileUnit2 == null || !transferFileUnit2.isMarked() || !transferFileUnit2.canBeMarked()) continue;
                transferFileUnit2.setMarked(false);
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(TransferFileUnit transferFileUnit) {
            return true;
        }

        protected String getContextName(TransferFileUnit transferFileUnit) {
            return this.getActionName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RowTabAction
    extends TabAction {
        private TransferFileUnit u;
        private int row;

        public RowTabAction(String string, String string2) {
            super(string, string2);
        }

        public RowTabAction(String string, KeyStroke keyStroke, String string2) {
            super(string, keyStroke, string2);
        }

        public void unitChanged(int n, TransferFileUnit transferFileUnit) {
            this.u = transferFileUnit;
            this.row = n;
            this.unitChanged();
        }

        public final boolean isVisible() {
            return this.u != null ? this.isVisible(this.u) : this.isVisible(this.row);
        }

        private final void unitChanged() {
            if (this.u != null) {
                this.setEnabled(this.isEnabled(this.u));
                this.setContextName(this.getContextName(this.u));
            } else {
                this.setEnabled(this.isEnabled(this.row));
                this.setContextName(this.getContextName(this.row));
            }
        }

        @Override
        public void tableDataChanged() {
            this.unitChanged();
        }

        @Override
        public void tableDataChanged(Collection<TransferFileUnit> collection) {
            this.unitChanged();
        }

        @Override
        public final void performerImpl() {
            this.performerImpl(this.u);
        }

        protected boolean isVisible(TransferFileUnit transferFileUnit) {
            return transferFileUnit != null;
        }

        protected boolean isVisible(int n) {
            return false;
        }

        public abstract void performerImpl(TransferFileUnit var1);

        protected abstract boolean isEnabled(TransferFileUnit var1);

        protected boolean isEnabled(int n) {
            return false;
        }

        protected abstract String getContextName(TransferFileUnit var1);

        protected String getContextName(int n) {
            return this.getActionName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TabAction
    extends AbstractAction {
        private String name;
        private String actionCategory;

        public TabAction(String string, String string2) {
            super(TransferFilter.textForKey(string));
            this.actionCategory = string2;
            this.putValue("MnemonicKey", TransferFilter.mnemonicForKey(string));
            this.name = (String)this.getValue("Name");
            this.putIntoActionMap(TransferFilter.this.table);
        }

        public TabAction(String string, KeyStroke keyStroke, String string2) {
            this(string, string2);
            this.putValue("AcceleratorKey", keyStroke);
            this.putIntoActionMap(transferFilter.table);
        }

        protected String getActionName() {
            return this.name;
        }

        public String getActionCategory() {
            return this.getActionCategoryImpl();
        }

        protected String getActionCategoryImpl() {
            return this.actionCategory;
        }

        protected void setContextName(String string) {
            this.putValue("Name", string);
        }

        public void putIntoActionMap(JComponent jComponent) {
            KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
            Object object = this.getValue("Name");
            if (keyStroke == null) {
                keyStroke = KeyStroke.getKeyStroke((Integer)this.getValue("MnemonicKey"), 18);
            }
            if (keyStroke != null && object != null) {
                jComponent.getInputMap(0).put(keyStroke, object);
                jComponent.getActionMap().put(object, this);
            }
        }

        public final void performAction() {
            if (this.isEnabled()) {
                this.actionPerformed(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            try {
                this.performerImpl();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }

        public void tableDataChanged() {
            this.tableDataChanged(TransferFilter.this.model.getMarkedUnits());
        }

        public void tableDataChanged(Collection<TransferFileUnit> collection) {
            this.setEnabled(collection.size() > 0);
        }

        public abstract void performerImpl();
    }

    private class PopupActionSupport
    extends MouseAdapter {
        private final TabAction[] actions;

        PopupActionSupport(TabAction[] tabActionArray) {
            this.actions = tabActionArray;
        }

        void rowChanged(int n) {
            TransferFileUnit transferFileUnit = null;
            if (n > -1) {
                transferFileUnit = TransferFilter.this.model.getUnitAtRow(n);
            }
            for (TabAction tabAction : this.actions) {
                if (!(tabAction instanceof RowTabAction)) continue;
                RowTabAction rowTabAction = (RowTabAction)tabAction;
                rowTabAction.unitChanged(n, transferFileUnit);
            }
        }

        void tableDataChanged() {
            List<TransferFileUnit> list = TransferFilter.this.model.getMarkedUnits();
            for (TabAction tabAction : this.actions) {
                tabAction.tableDataChanged(list);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.removeAll();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TabAction tabActionArray : this.actions) {
                String string = tabActionArray.getActionCategory();
                if (!hashSet.add(string)) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                int n = jPopupMenu.getSubElements().length > 0 ? 1 : 0;
                for (TabAction tabAction : this.actions) {
                    String string2 = tabAction.getActionCategory();
                    if ((string == null || !string.equals(string2)) && (string != null || string2 != null)) continue;
                    if (tabAction instanceof RowTabAction) {
                        RowTabAction rowTabAction = (RowTabAction)tabAction;
                        if (!rowTabAction.isVisible()) continue;
                        if (n != 0) {
                            n = 0;
                            jPopupMenu.addSeparator();
                        }
                        jPopupMenu.add(new JMenuItem(tabAction));
                        continue;
                    }
                    if (n != 0) {
                        n = 0;
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(new JMenuItem(tabAction));
                }
            }
            return jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.maybeShowPopup(mouseEvent)) {
                // empty if block
            }
        }

        private boolean maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TransferFilter.this.focusTable();
                TransferFilter.this.showPopup(mouseEvent.getPoint(), mouseEvent.getComponent());
                return true;
            }
            return false;
        }
    }
}

