/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class LocalServerController {
    private final JComboBox localServerComboBox;
    private final JButton localServerBrowseButton;
    private final SourcesFolderProvider sourcesFolderProvider;
    private final String browseDialogTitle;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private MutableComboBoxModel localServerComboBoxModel;
    private final LocalServer.ComboBoxEditor localServerComboBoxEditor;
    private final BrowseHandler browseHandler;

    public static LocalServerController create(JComboBox jComboBox, JButton jButton, SourcesFolderProvider sourcesFolderProvider, BrowseHandler browseHandler, String string, LocalServer ... localServerArray) {
        return new LocalServerController(jComboBox, jButton, sourcesFolderProvider, browseHandler, string, localServerArray);
    }

    public static LocalServerController create(JComboBox jComboBox, JButton jButton, BrowseHandler browseHandler, String string, LocalServer ... localServerArray) {
        return new LocalServerController(jComboBox, jButton, null, browseHandler, string, localServerArray);
    }

    private LocalServerController(JComboBox jComboBox, JButton jButton, SourcesFolderProvider sourcesFolderProvider, BrowseHandler browseHandler, String string, LocalServer ... localServerArray) {
        assert (jComboBox != null);
        assert (jButton != null);
        assert (browseHandler != null);
        assert (string != null);
        assert (jComboBox.isEditable()) : "localServerComboBox has to be editable";
        assert (jComboBox.getEditor().getEditorComponent() instanceof JTextField);
        this.localServerComboBox = jComboBox;
        this.localServerBrowseButton = jButton;
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.browseHandler = browseHandler;
        this.browseDialogTitle = string;
        this.localServerComboBoxModel = new LocalServer.ComboBoxModel(localServerArray);
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        this.localServerComboBoxEditor = new LocalServer.ComboBoxEditor(jTextField);
        jComboBox.setModel(this.localServerComboBoxModel);
        jComboBox.setRenderer(new LocalServer.ComboBoxRenderer());
        jComboBox.setEditor(this.localServerComboBoxEditor);
        this.registerListeners();
    }

    private void registerListeners() {
        this.localServerComboBoxEditor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LocalServerController.this.changeSupport.fireChange();
            }
        });
        this.localServerBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = null;
                if (LocalServerController.this.sourcesFolderProvider != null) {
                    string = LocalServerController.this.sourcesFolderProvider.getSourcesFolderName();
                }
                File file = LocalServerController.this.browseHandler.getCurrentDirectory();
                File file2 = Utils.browseLocalServerAction(LocalServerController.this.localServerBrowseButton.getParent(), LocalServerController.this.localServerComboBox, LocalServerController.this.localServerComboBoxModel, file, string, LocalServerController.this.browseDialogTitle);
                LocalServerController.this.browseHandler.locationChanged(file2);
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public LocalServer getLocalServer() {
        return (LocalServer)this.localServerComboBox.getSelectedItem();
    }

    public MutableComboBoxModel getLocalServerModel() {
        return this.localServerComboBoxModel;
    }

    public void setLocalServerModel(MutableComboBoxModel mutableComboBoxModel) {
        this.localServerComboBoxModel = mutableComboBoxModel;
        this.localServerComboBox.setModel(this.localServerComboBoxModel);
    }

    public void addLocalServer(LocalServer localServer) {
        this.localServerComboBox.addItem(localServer);
    }

    public void selectLocalServer(LocalServer localServer) {
        this.localServerComboBox.setSelectedItem(localServer);
    }

    public void setEnabled(boolean bl) {
        this.localServerComboBox.setEnabled(bl);
        this.localServerBrowseButton.setEnabled(bl);
    }

    public static String validateLocalServer(LocalServer localServer, String string, boolean bl, boolean bl2) {
        if (!localServer.isEditable()) {
            return null;
        }
        String string2 = null;
        String string3 = localServer.getSrcRoot();
        File file = FileUtil.normalizeFile((File)new File(string3));
        string2 = string3.trim().length() == 0 || !Utils.isValidFileName(file) ? NbBundle.getMessage(LocalServerController.class, (String)("MSG_Illegal" + string + "Name")) : Utils.validateProjectDirectory(string3, string, bl, bl2);
        return string2;
    }

    public static interface BrowseHandler {
        public File getCurrentDirectory();

        public void locationChanged(File var1);
    }
}

