/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.Utils;
import org.netbeans.modules.php.project.ui.actions.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.Displayable;
import org.netbeans.modules.php.project.ui.actions.UploadCommand;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class Command {
    private final PhpProject project;

    public Command(PhpProject phpProject) {
        this.project = phpProject;
        assert (phpProject != null);
    }

    public abstract String getCommandId();

    public abstract void invokeAction(Lookup var1) throws IllegalArgumentException;

    public abstract boolean isActionEnabled(Lookup var1) throws IllegalArgumentException;

    public boolean asyncCallRequired() {
        return true;
    }

    public boolean saveRequired() {
        return true;
    }

    public final PhpProject getProject() {
        return this.project;
    }

    protected final void showURL(URL uRL) throws MalformedURLException {
        HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
    }

    protected final void showURLForProjectFile() throws MalformedURLException {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.urlForProjectFile(true));
    }

    protected final void showURLForDebugProjectFile() throws MalformedURLException {
        this.showURLForDebug(this.getURLForDebug(null, true));
    }

    protected final URL getURLForDebug(Lookup lookup, boolean bl) throws MalformedURLException {
        DebugInfo debugInfo = this.getDebugInfo();
        URL uRL = lookup != null ? (debugInfo.debugServer ? this.urlForDebugContext(lookup, bl) : this.urlForContext(lookup, bl)) : (debugInfo.debugServer ? this.urlForDebugProjectFile(bl) : this.urlForProjectFile(bl));
        return uRL;
    }

    private DebugInfo getDebugInfo() {
        boolean bl = WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project);
        boolean bl2 = WebClientToolsProjectUtils.getClientDebugProperty((Project)this.project);
        if (!WebClientToolsSessionStarterService.isAvailable()) {
            bl = true;
            bl2 = false;
        }
        assert (bl || bl2);
        return new DebugInfo(bl2, bl);
    }

    protected final void showURLForDebug(URL uRL) throws MalformedURLException {
        assert (uRL != null);
        if (this.getDebugInfo().debugClient) {
            try {
                this.launchJavaScriptDebugger(uRL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    protected final void launchJavaScriptDebugger(URL uRL) throws MalformedURLException, URISyntaxException {
        HtmlBrowser.Factory factory;
        URI uRI;
        LocationMappersFactory locationMappersFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
        Lookup lookup = null;
        if (locationMappersFactory != null) {
            uRI = this.getBaseURL().toURI();
            factory = Utils.getSourceObjects(this.getProject());
            JSToNbJSLocationMapper jSToNbJSLocationMapper = locationMappersFactory.getJSToNbJSLocationMapper((FileObject[])factory, uRI, null);
            NbJSToJSLocationMapper nbJSToJSLocationMapper = locationMappersFactory.getNbJSToJSLocationMapper((FileObject[])factory, uRI, null);
            lookup = Lookups.fixed((Object[])new Object[]{jSToNbJSLocationMapper, nbJSToJSLocationMapper, this.project});
        } else {
            lookup = Lookups.fixed((Object[])new Object[]{this.project});
        }
        uRI = uRL.toURI();
        factory = null;
        factory = WebClientToolsProjectUtils.isInternetExplorer((Project)this.project) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
        if (factory == null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        } else {
            try {
                WebClientToolsSessionStarterService.startSession((URI)uRI, (HtmlBrowser.Factory)factory, (Lookup)lookup);
            }
            catch (WebClientToolsSessionException webClientToolsSessionException) {
                Exceptions.printStackTrace((Throwable)webClientToolsSessionException);
            }
        }
    }

    protected final URL getBaseURL() throws MalformedURLException {
        String string = ProjectPropertiesSupport.getUrl(this.project);
        if (string == null) {
            throw new MalformedURLException();
        }
        return new URL(string);
    }

    protected final URL appendQuery(URL uRL, String string) throws MalformedURLException {
        try {
            URI uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), string, uRL.getRef());
            return uRI.toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getLocalizedMessage());
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    protected final URL urlForDebugProjectFile(boolean bl) throws MalformedURLException {
        return this.appendQuery(this.urlForProjectFile(bl), this.getDebugArguments());
    }

    protected final URL urlForDebugContext(Lookup lookup, boolean bl) throws MalformedURLException {
        return this.appendQuery(this.urlForContext(lookup, bl), this.getDebugArguments());
    }

    private String getDebugArguments() {
        String string = ProjectPropertiesSupport.getArguments(this.project);
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            stringBuilder.append(string);
            stringBuilder.append("&");
        }
        stringBuilder.append("XDEBUG_SESSION_START=netbeans-xdebug");
        return stringBuilder.toString();
    }

    protected final URL urlForProjectFile(boolean bl) throws MalformedURLException {
        String string = this.relativePathForProject(bl);
        if (string == null) {
            string = "";
        }
        URL uRL = new URL(this.getBaseURL(), string);
        String string2 = ProjectPropertiesSupport.getArguments(this.project);
        return string2 != null ? this.appendQuery(uRL, string2) : uRL;
    }

    protected final URL urlForContext(Lookup lookup, boolean bl) throws MalformedURLException {
        String string = this.relativePathForContext(lookup, bl);
        if (string == null) {
            throw new MalformedURLException();
        }
        URL uRL = new URL(this.getBaseURL(), string);
        String string2 = ProjectPropertiesSupport.getArguments(this.project);
        return string2 != null ? this.appendQuery(uRL, string2) : uRL;
    }

    protected final String relativePathForContext(Lookup lookup, boolean bl) {
        FileObject fileObject = this.fileForContext(lookup);
        if (bl) {
            return this.getCommandUtils().getRelativeWebRootPath(fileObject);
        }
        return this.getCommandUtils().getRelativeSrcPath(fileObject);
    }

    protected final String relativePathForProject(boolean bl) {
        FileObject fileObject = this.fileForProject(bl);
        if (bl) {
            return this.getCommandUtils().getRelativeWebRootPath(fileObject);
        }
        return this.getCommandUtils().getRelativeSrcPath(fileObject);
    }

    protected final FileObject fileForProject(boolean bl) {
        String string = ProjectPropertiesSupport.getIndexFile(this.project);
        if (bl) {
            return ProjectPropertiesSupport.getWebRootDirectory(this.project).getFileObject(string);
        }
        return ProjectPropertiesSupport.getSourcesDirectory(this.project).getFileObject(string);
    }

    protected boolean isRunConfigurationValid() {
        return ProjectPropertiesSupport.isActiveConfigValid(this.project, true);
    }

    protected boolean isScriptSelected() {
        PhpProjectProperties.RunAsType runAsType = ProjectPropertiesSupport.getRunAs(this.project);
        return PhpProjectProperties.RunAsType.SCRIPT.equals((Object)runAsType);
    }

    protected boolean isRemoteConfigSelected() {
        PhpProjectProperties.RunAsType runAsType = ProjectPropertiesSupport.getRunAs(this.project);
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAsType);
    }

    protected boolean isPhpFileSelected(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        return CommandUtils.isPhpFile(fileObject);
    }

    protected String getRemoteConfigurationName() {
        return ProjectPropertiesSupport.getRemoteConnection(this.project);
    }

    protected String getRemoteDirectory() {
        return ProjectPropertiesSupport.getRemoteDirectory(this.project);
    }

    protected final FileObject fileForContext(Lookup lookup) {
        boolean bl;
        CommandUtils commandUtils = this.getCommandUtils();
        FileObject[] fileObjectArray = commandUtils.phpFilesForContext(lookup, bl = this.isScriptSelected());
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            fileObjectArray = commandUtils.phpFilesForSelectedNodes(bl);
        }
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    protected final Command getOtherCommand(String string) {
        PhpActionProvider phpActionProvider = (PhpActionProvider)this.getProject().getLookup().lookup(PhpActionProvider.class);
        assert (phpActionProvider != null);
        return phpActionProvider.getCommand(string);
    }

    private CommandUtils getCommandUtils() {
        CommandUtils commandUtils = new CommandUtils(this.getProject());
        return commandUtils;
    }

    private static OutputWriter getOutputWriter(String string, boolean bl, boolean bl2) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        if (bl2) {
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl ? inputOutput.getErr() : inputOutput.getOut();
    }

    protected final BufferedReader reader(InputStream inputStream, Charset charset) {
        return new BufferedReader(new InputStreamReader(inputStream, charset));
    }

    protected final BufferedWriter outputTabWriter(File file, boolean bl, boolean bl2) {
        String string = this.getOutputTabTitle(file);
        OutputWriter outputWriter = Command.getOutputWriter(string, bl, bl2);
        return new BufferedWriter((Writer)outputWriter);
    }

    protected final String getOutputTabTitle(File file) {
        return this.getOutputTabTitle(((Displayable)((Object)this)).getDisplayName(), file);
    }

    protected String getOutputTabTitle(String string, File file) {
        assert (this instanceof Displayable);
        return MessageFormat.format("{0} - {1}", string, file.getName());
    }

    protected static final BufferedWriter writer(OutputStream outputStream, Charset charset) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void rewriteAndClose(StringConvertor stringConvertor, BufferedReader bufferedReader, BufferedWriter ... bufferedWriterArray) throws IOException {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                string = stringConvertor != null ? stringConvertor.convert(string) : string;
                for (BufferedWriter bufferedWriter : bufferedWriterArray) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
            }
        }
        finally {
            bufferedReader.close();
            for (BufferedWriter bufferedWriter : bufferedWriterArray) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
    }

    protected void eventuallyUploadFiles() {
        this.eventuallyUploadFiles(null);
    }

    protected void eventuallyUploadFiles(FileObject ... fileObjectArray) {
        if (!this.isRemoteConfigSelected()) {
            return;
        }
        UploadCommand uploadCommand = (UploadCommand)this.getOtherCommand("upload");
        if (!uploadCommand.isActionEnabled(null)) {
            return;
        }
        PhpProjectProperties.UploadFiles uploadFiles = ProjectPropertiesSupport.getRemoteUpload(this.getProject());
        assert (uploadFiles != null);
        if (PhpProjectProperties.UploadFiles.ON_RUN.equals((Object)uploadFiles)) {
            uploadCommand.uploadFiles(new FileObject[]{ProjectPropertiesSupport.getSourcesDirectory(this.getProject())}, fileObjectArray);
        }
    }

    private static class DebugInfo {
        final boolean debugClient;
        final boolean debugServer;

        public DebugInfo(boolean bl, boolean bl2) {
            this.debugClient = bl;
            this.debugServer = bl2;
        }
    }

    public static interface StringConvertor {
        public String convert(String var1);
    }
}

