/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandUtils {
    private static final String HTML_MIME_TYPE = "text/html";
    private PhpProject project;

    public CommandUtils(PhpProject phpProject) {
        this.project = phpProject;
    }

    public FileObject[] phpFilesForContext(Lookup lookup, boolean bl) {
        FileObject fileObject = bl ? ProjectPropertiesSupport.getSourcesDirectory(this.getProject()) : ProjectPropertiesSupport.getWebRootDirectory(this.getProject());
        return CommandUtils.filter(this.filesForContext(lookup), fileObject);
    }

    public FileObject[] phpFilesForSelectedNodes(boolean bl) {
        FileObject fileObject = bl ? ProjectPropertiesSupport.getSourcesDirectory(this.getProject()) : ProjectPropertiesSupport.getWebRootDirectory(this.getProject());
        return CommandUtils.filter(Arrays.asList(CommandUtils.filesForSelectedNodes()), fileObject);
    }

    public Collection<? extends FileObject> filesForContext(Lookup lookup) {
        return lookup.lookupAll(FileObject.class);
    }

    public static FileObject[] filesForSelectedNodes() {
        Node[] nodeArray = CommandUtils.getSelectedNodes();
        if (nodeArray == null) {
            return new FileObject[0];
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        for (Node node : nodeArray) {
            FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                fileObject = CommandUtils.getFileObject(node);
            }
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public static Node[] getSelectedNodes() {
        return TopComponent.getRegistry().getCurrentNodes();
    }

    public String getRelativeSrcPath(FileObject fileObject) {
        return this.getRelativePhpPath(ProjectPropertiesSupport.getSourcesDirectory(this.getProject()), fileObject);
    }

    public String getRelativeWebRootPath(FileObject fileObject) {
        return this.getRelativePhpPath(ProjectPropertiesSupport.getWebRootDirectory(this.getProject()), fileObject);
    }

    private String getRelativePhpPath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2 != null) {
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
                return FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            }
            if (fileObject.equals(fileObject2)) {
                return "";
            }
        }
        return null;
    }

    private static boolean isUnderSourceRoot(FileObject fileObject, FileObject fileObject2) {
        return FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) && FileUtil.toFile((FileObject)fileObject2) != null;
    }

    public static boolean isPhpFile(FileObject fileObject) {
        assert (fileObject != null);
        return "text/x-php5".equals(FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{"text/x-php5"}));
    }

    public static boolean isPhpOrHtmlFile(FileObject fileObject) {
        assert (fileObject != null);
        String string = FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{"text/x-php5", HTML_MIME_TYPE});
        return "text/x-php5".equals(string) || HTML_MIME_TYPE.equals(string);
    }

    private static FileObject[] filter(Collection<? extends FileObject> collection, FileObject fileObject) {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (FileObject fileObject2 : collection) {
            if (!CommandUtils.isUnderSourceRoot(fileObject, fileObject2)) {
                return null;
            }
            linkedHashSet.add(fileObject2);
        }
        return !linkedHashSet.isEmpty() ? linkedHashSet.toArray(new FileObject[linkedHashSet.size()]) : null;
    }

    private static FileObject getFileObject(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    private PhpProject getProject() {
        return this.project;
    }
}

