/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPhpInterpreterPanel
extends JPanel {
    private static final long serialVersionUID = 2632292202688721433L;
    private final RequestProcessor rp = new RequestProcessor("PHP interpreter detection thread", 1, true);
    private List<String> availablePhpInterpreters;
    private DialogDescriptor descriptor;
    private RequestProcessor.Task detectTask;
    private JLabel detectedFilesLabel;
    private JLabel messageLabel;
    private JList phpInterpretersList;
    private JScrollPane phpInterpretersScrollPane;
    private JProgressBar progressBar;

    public SelectPhpInterpreterPanel() {
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        String string = NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"LBL_PhpInterpretersTitle");
        this.descriptor = new DialogDescriptor((Object)this, string, true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectPhpInterpreterPanel.this.cancelDetection();
            }
        });
        if (this.availablePhpInterpreters == null) {
            this.descriptor.setValid(false);
            this.phpInterpretersList.setEnabled(true);
            this.progressBar.setIndeterminate(true);
            this.detectTask = this.rp.create((Runnable)new PhpInterpreterDetector());
            this.detectTask.schedule(0);
        } else {
            this.updateAvailablePhpInterpreters(this.availablePhpInterpreters);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            dialog.setVisible(true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dialog.dispose();
            throw throwable;
        }
        dialog.dispose();
        return this.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public List<String> getAvailablePhpInterpreters() {
        return this.availablePhpInterpreters;
    }

    public String getSelectedPhpInterpreter() {
        return (String)this.phpInterpretersList.getSelectedValue();
    }

    private void cancelDetection() {
        if (this.detectTask != null) {
            this.detectTask.cancel();
        }
    }

    private void updateAvailablePhpInterpreters(List<String> list) {
        this.availablePhpInterpreters = list;
        this.phpInterpretersList.setEnabled(true);
        this.phpInterpretersList.setListData(list.toArray(new String[list.size()]));
        String string = null;
        if (list.size() == 0) {
            string = NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"LBL_NoPhpInterpretersFound");
        } else {
            string = " ";
            this.phpInterpretersList.setSelectedIndex(0);
        }
        this.messageLabel.setText(string);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(this.getBackground());
        this.descriptor.setValid(true);
    }

    private void initComponents() {
        this.detectedFilesLabel = new JLabel();
        this.phpInterpretersScrollPane = new JScrollPane();
        this.phpInterpretersList = new JList();
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.detectedFilesLabel.setLabelFor(this.phpInterpretersList);
        this.detectedFilesLabel.setText(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"LBL_PhpInterpreters"));
        this.phpInterpretersList.setSelectionMode(0);
        this.phpInterpretersList.setEnabled(false);
        this.phpInterpretersScrollPane.setViewportView(this.phpInterpretersList);
        this.phpInterpretersList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersList.AccessibleContext.accessibleName"));
        this.phpInterpretersList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersList.AccessibleContext.accessibleDescription"));
        this.messageLabel.setLabelFor(this.progressBar);
        this.messageLabel.setText(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"LBL_PleaseWait"));
        this.progressBar.setString(" ");
        this.progressBar.setStringPainted(true);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.phpInterpretersScrollPane, -1, 291, Short.MAX_VALUE).add(1, (Component)this.progressBar, -1, 291, Short.MAX_VALUE).add(1, (Component)this.detectedFilesLabel).add(1, (Component)this.messageLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.detectedFilesLabel).addPreferredGap(0).add((Component)this.phpInterpretersScrollPane, -1, 105, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).add(0, 0, 0)));
        this.detectedFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.detectedFilesLabel.AccessibleContext.accessibleName"));
        this.detectedFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.detectedFilesLabel.AccessibleContext.accessibleDescription"));
        this.phpInterpretersScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersScrollPane.AccessibleContext.accessibleName"));
        this.phpInterpretersScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersScrollPane.AccessibleContext.accessibleDescription"));
        this.messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.messageLabel.AccessibleContext.accessibleName"));
        this.messageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.messageLabel.AccessibleContext.accessibleDescription"));
        this.progressBar.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.progressBar.AccessibleContext.accessibleName"));
        this.progressBar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.progressBar.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectPhpInterpreterPanel.class, (String)"SelectPhpInterpreterPanel.AccessibleContext.accessibleDescription"));
    }

    private final class PhpInterpreterDetector
    implements Runnable {
        private PhpInterpreterDetector() {
        }

        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            final List<String> list = PhpEnvironment.get().getAllPhpInterpreters();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectPhpInterpreterPanel.this.updateAvailablePhpInterpreters(list);
                }
            });
        }
    }
}

