/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConfiguration;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.project.ui.wizards.RunAsLocalWeb;
import org.netbeans.modules.php.project.ui.wizards.RunAsRemoteWeb;
import org.netbeans.modules.php.project.ui.wizards.RunAsScript;
import org.netbeans.modules.php.project.ui.wizards.RunConfigurationPanelVisual;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConfigurationPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    static final String VALID = "valid";
    static final String RUN_AS = "run.as";
    static final String URL = "url";
    static final String INDEX_FILE = "indexFile";
    static final String DEFAULT_INDEX_FILE = "index.php";
    static final String COPY_SRC_FILES = "copySrcFiles";
    static final String COPY_SRC_TARGET = "copySrcTarget";
    static final String COPY_SRC_TARGETS = "copySrcTargets";
    static final String REMOTE_CONNECTION = "remoteConnection";
    static final String REMOTE_DIRECTORY = "remoteDirectory";
    static final String REMOTE_UPLOAD = "remoteUpload";
    static final String[] CFG_PROPS = new String[]{"run.as", "url", "indexFile", "remoteConnection", "remoteDirectory", "remoteUpload"};
    private final String[] steps;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final SourcesFolderProvider sourcesFolderProvider;
    private final NewPhpProjectWizardIterator.WizardType wizardType;
    private WizardDescriptor descriptor = null;
    private PropertyChangeListener phpInterpreterListener;
    private ConfigManager.ConfigProvider configProvider;
    private ConfigManager configManager;
    private RunConfigurationPanelVisual runConfigurationPanelVisual = null;
    private RunAsLocalWeb runAsLocalWeb = null;
    private RunAsRemoteWeb runAsRemoteWeb = null;
    private RunAsScript runAsScript = null;
    private String defaultLocalUrl = null;
    private String originalProjectName = null;

    public RunConfigurationPanel(String[] stringArray, SourcesFolderProvider sourcesFolderProvider, NewPhpProjectWizardIterator.WizardType wizardType) {
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.steps = stringArray;
        this.wizardType = wizardType;
    }

    String[] getSteps() {
        return this.steps;
    }

    public Component getComponent() {
        if (this.runConfigurationPanelVisual == null) {
            this.configProvider = new WizardConfigProvider();
            this.configManager = new ConfigManager(this.configProvider);
            this.runAsLocalWeb = new RunAsLocalWeb(this.configManager, this.sourcesFolderProvider);
            this.runAsRemoteWeb = new RunAsRemoteWeb(this.configManager, this.sourcesFolderProvider);
            this.runAsScript = new RunAsScript(this.configManager, this.sourcesFolderProvider);
            switch (this.wizardType) {
                case NEW: {
                    this.runAsLocalWeb.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsRemoteWeb.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsScript.setIndexFile(DEFAULT_INDEX_FILE);
                    this.runAsLocalWeb.hideIndexFile();
                    this.runAsRemoteWeb.hideIndexFile();
                    this.runAsScript.hideIndexFile();
                }
            }
            RunAsPanel.InsidePanel[] insidePanelArray = new RunAsPanel.InsidePanel[]{this.runAsLocalWeb, this.runAsRemoteWeb, this.runAsScript};
            this.runConfigurationPanelVisual = new RunConfigurationPanelVisual(this, this.sourcesFolderProvider, this.configManager, insidePanelArray);
            this.phpInterpreterListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("propPhpInterpreter".equals(propertyChangeEvent.getPropertyName())) {
                        RunConfigurationPanel.this.runAsScript.loadPhpInterpreter();
                    }
                }
            };
            PhpOptions phpOptions = PhpOptions.getInstance();
            phpOptions.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.phpInterpreterListener, (Object)phpOptions));
            this.addListeners();
        }
        return this.runConfigurationPanelVisual;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(RunConfigurationPanel.class);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.getComponent();
        this.descriptor = wizardDescriptor;
        switch (this.wizardType) {
            case EXISTING: {
                this.findIndexFile();
            }
        }
        this.runAsLocalWeb.setLocalServerModel(this.getLocalServerModel());
        this.runAsLocalWeb.setCopyFiles(this.getCopyFiles());
        this.runAsRemoteWeb.setUploadDirectory(this.getUploadDirectory());
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        this.getComponent();
        for (String string : CFG_PROPS) {
            wizardDescriptor.putProperty(string, null);
        }
        PhpProjectProperties.RunAsType runAsType = this.getRunAsType();
        wizardDescriptor.putProperty(RUN_AS, (Object)runAsType);
        wizardDescriptor.putProperty(COPY_SRC_FILES, (Object)this.runAsLocalWeb.isCopyFiles());
        wizardDescriptor.putProperty(COPY_SRC_TARGET, (Object)this.runAsLocalWeb.getLocalServer());
        wizardDescriptor.putProperty(COPY_SRC_TARGETS, (Object)this.runAsLocalWeb.getLocalServerModel());
        switch (runAsType) {
            case LOCAL: {
                this.storeRunAsLocalWeb(wizardDescriptor);
                break;
            }
            case REMOTE: {
                this.storeRunAsRemoteWeb(wizardDescriptor);
                break;
            }
            case SCRIPT: {
                this.storeRunAsScript(wizardDescriptor);
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + runAsType;
                break;
            }
        }
    }

    private MutableComboBoxModel getLocalServerModel() {
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.descriptor.getProperty(COPY_SRC_TARGETS);
        if (mutableComboBoxModel != null) {
            return mutableComboBoxModel;
        }
        List<PhpEnvironment.DocumentRoot> list = PhpEnvironment.get().getDocumentRoots();
        int n = list.size();
        ArrayList<LocalServer> arrayList = new ArrayList<LocalServer>(n);
        for (PhpEnvironment.DocumentRoot documentRoot : list) {
            String string = new File(documentRoot.getDocumentRoot(), this.sourcesFolderProvider.getSourcesFolderName()).getAbsolutePath();
            LocalServer localServer = new LocalServer(null, documentRoot.getUrl(), documentRoot.getDocumentRoot(), string, true);
            arrayList.add(localServer);
        }
        return new LocalServer.ComboBoxModel(arrayList.toArray(new LocalServer[n]));
    }

    private boolean getCopyFiles() {
        Boolean bl = (Boolean)this.descriptor.getProperty(COPY_SRC_FILES);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private String getUploadDirectory() {
        String string = (String)this.descriptor.getProperty(REMOTE_DIRECTORY);
        if (string != null) {
            return string;
        }
        return "/" + this.getProjectName();
    }

    private void findIndexFile() {
        FileObject fileObject;
        String string = (String)this.descriptor.getProperty(INDEX_FILE);
        if ((string == null || string.length() == 0) && (fileObject = FileUtil.toFileObject((File)this.sourcesFolderProvider.getSourcesFolder()).getFileObject(DEFAULT_INDEX_FILE)) != null && fileObject.isValid()) {
            this.runAsLocalWeb.setIndexFile(DEFAULT_INDEX_FILE);
            this.runAsRemoteWeb.setIndexFile(DEFAULT_INDEX_FILE);
            this.runAsScript.setIndexFile(DEFAULT_INDEX_FILE);
        }
    }

    private void storeRunAsLocalWeb(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(URL, (Object)this.runAsLocalWeb.getUrl());
        wizardDescriptor.putProperty(INDEX_FILE, (Object)this.runAsLocalWeb.getIndexFile());
    }

    private void storeRunAsRemoteWeb(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(URL, (Object)this.runAsRemoteWeb.getUrl());
        wizardDescriptor.putProperty(INDEX_FILE, (Object)this.runAsRemoteWeb.getIndexFile());
        wizardDescriptor.putProperty(REMOTE_CONNECTION, (Object)this.runAsRemoteWeb.getRemoteConfiguration());
        wizardDescriptor.putProperty(REMOTE_DIRECTORY, (Object)this.runAsRemoteWeb.getUploadDirectory());
        wizardDescriptor.putProperty(REMOTE_UPLOAD, (Object)this.runAsRemoteWeb.getUploadFiles());
    }

    private void storeRunAsScript(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(INDEX_FILE, (Object)this.runAsScript.getIndexFile());
    }

    public boolean isValid() {
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String string = null;
        switch (this.getRunAsType()) {
            case LOCAL: {
                string = this.validateRunAsLocalWeb();
                break;
            }
            case REMOTE: {
                string = this.validateRunAsRemoteWeb();
                break;
            }
            case SCRIPT: {
                string = this.validateRunAsScript();
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + (Object)((Object)this.getRunAsType());
                break;
            }
        }
        if (string != null) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            this.descriptor.putProperty(VALID, (Object)false);
            return false;
        }
        this.validateAsciiTexts();
        this.descriptor.putProperty(VALID, (Object)true);
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public boolean isFinishPanel() {
        return false;
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private void addListeners() {
        this.runAsLocalWeb.addRunAsLocalWebListener(this);
        this.runAsRemoteWeb.addRunAsRemoteWebListener(this);
        this.runAsScript.addRunAsScriptListener(this);
    }

    private PhpProjectProperties.RunAsType getRunAsType() {
        String string = this.configProvider.getActiveConfig();
        String string2 = this.configManager.configurationFor(string).getValue(RUN_AS);
        if (string2 == null) {
            return PhpProjectProperties.RunAsType.LOCAL;
        }
        return PhpProjectProperties.RunAsType.valueOf(string2);
    }

    private String validateRunAsLocalWeb() {
        String string;
        String string2 = null;
        if (this.wizardType == NewPhpProjectWizardIterator.WizardType.EXISTING) {
            string2 = this.runAsLocalWeb.getIndexFile();
        }
        if ((string = RunAsValidator.validateWebFields(this.runAsLocalWeb.getUrl(), this.sourcesFolderProvider.getSourcesFolder(), string2, null)) != null) {
            return string;
        }
        string = this.validateServerLocation();
        if (string != null) {
            return string;
        }
        return null;
    }

    private String validateRunAsRemoteWeb() {
        String string;
        String string2 = null;
        if (this.wizardType == NewPhpProjectWizardIterator.WizardType.EXISTING) {
            string2 = this.runAsRemoteWeb.getIndexFile();
        }
        if ((string = RunAsValidator.validateWebFields(this.runAsRemoteWeb.getUrl(), this.sourcesFolderProvider.getSourcesFolder(), string2, null)) != null) {
            return string;
        }
        RemoteConfiguration remoteConfiguration = this.runAsRemoteWeb.getRemoteConfiguration();
        assert (remoteConfiguration != null);
        if (remoteConfiguration == RunAsRemoteWeb.NO_REMOTE_CONFIGURATION) {
            return NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NoConfigurationSelected");
        }
        string = RunAsValidator.validateUploadDirectory(this.runAsRemoteWeb.getUploadDirectory(), true);
        if (string != null) {
            return string;
        }
        return null;
    }

    private String validateRunAsScript() {
        String string = null;
        if (this.wizardType == NewPhpProjectWizardIterator.WizardType.EXISTING) {
            string = this.runAsScript.getIndexFile();
        }
        return RunAsValidator.validateScriptFields(this.runAsScript.getPhpInterpreter(), this.sourcesFolderProvider.getSourcesFolder(), string, null);
    }

    private String validateServerLocation() {
        if (!this.runAsLocalWeb.isCopyFiles()) {
            return null;
        }
        LocalServer localServer = this.runAsLocalWeb.getLocalServer();
        String string = localServer.getSrcRoot();
        File file = FileUtil.normalizeFile((File)new File(string));
        if (string == null || !Utils.isValidFileName(file)) {
            return NbBundle.getMessage(RunConfigurationPanel.class, (String)"MSG_IllegalFolderName");
        }
        String string2 = Utils.validateProjectDirectory(string, "Folder", false, true);
        if (string2 != null) {
            return string2;
        }
        string2 = this.validateSourcesAndCopyTarget();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.runAsLocalWeb.getUrl();
        String string4 = NbBundle.getMessage(RunConfigurationPanel.class, (String)"MSG_TargetFolderVisible", (Object)string3);
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string4);
        return null;
    }

    private String validateSourcesAndCopyTarget() {
        LocalServer localServer = (LocalServer)this.descriptor.getProperty("sourcesFolder");
        assert (localServer != null);
        String string = localServer.getSrcRoot();
        File file = FileUtil.normalizeFile((File)new File(this.runAsLocalWeb.getLocalServer().getSrcRoot()));
        String string2 = file.getAbsolutePath();
        return Utils.validateSourcesAndCopyTarget(string, string2);
    }

    private void validateAsciiTexts() {
        String string = null;
        String string2 = null;
        switch (this.getRunAsType()) {
            case LOCAL: {
                string = this.runAsLocalWeb.getUrl();
                string2 = this.runAsLocalWeb.getIndexFile();
                break;
            }
            case REMOTE: {
                string = this.runAsRemoteWeb.getUrl();
                string2 = this.runAsRemoteWeb.getIndexFile();
                break;
            }
            case SCRIPT: {
                return;
            }
        }
        assert (string != null);
        assert (string2 != null);
        String string3 = Utils.validateAsciiText(string, NbBundle.getMessage(ConfigureProjectPanel.class, (String)"LBL_ProjectUrlPure"));
        if (string3 != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)string3);
            return;
        }
        string3 = Utils.validateAsciiText(string2, NbBundle.getMessage(ConfigureProjectPanel.class, (String)"LBL_IndexFilePure"));
        if (string3 != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)string3);
            return;
        }
    }

    private void adjustUrl() {
        String string = this.runAsLocalWeb.getUrl();
        if (this.defaultLocalUrl == null) {
            this.defaultLocalUrl = string;
        }
        if (!this.defaultLocalUrl.equals(string)) {
            return;
        }
        String string2 = null;
        if (this.runAsLocalWeb.isCopyFiles()) {
            LocalServer localServer = this.runAsLocalWeb.getLocalServer();
            String string3 = localServer.getDocumentRoot();
            assert (string3 != null);
            String string4 = localServer.getSrcRoot();
            String string5 = RunConfigurationPanel.getUrlSuffix(string3, string4);
            if (string5 == null) {
                string5 = new File(string4).getName();
            }
            String string6 = localServer.getUrl() != null ? localServer.getUrl() : "http://localhost/";
            string2 = string6 + string5;
        } else {
            string2 = RunConfigurationPanel.getUrlForSources(this.wizardType, this.descriptor);
        }
        if (string2 != null && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (string2 != null && !this.defaultLocalUrl.equals(string2)) {
            this.defaultLocalUrl = string2;
            this.runAsLocalWeb.setUrl(string2);
        }
    }

    static String getUrlForSources(NewPhpProjectWizardIterator.WizardType wizardType, WizardDescriptor wizardDescriptor) {
        String string = null;
        LocalServer localServer = (LocalServer)wizardDescriptor.getProperty("sourcesFolder");
        assert (localServer != null);
        String string2 = localServer.getSrcRoot();
        block0 : switch (wizardType) {
            case NEW: {
                List list = (List)wizardDescriptor.getProperty("roots");
                assert (list != null);
                for (PhpEnvironment.DocumentRoot documentRoot : list) {
                    String string3 = RunConfigurationPanel.getUrlSuffix(documentRoot.getDocumentRoot(), string2);
                    if (string3 == null) continue;
                    string = documentRoot.getUrl() + string3;
                    break block0;
                }
                break;
            }
        }
        if (string == null) {
            string = "http://localhost/" + new File(string2).getName();
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    private static String getUrlSuffix(String string, String string2) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!string2.startsWith(string)) {
            return null;
        }
        string2 = string2.replaceAll(Pattern.quote(File.separator) + "+", "/");
        return string2.substring(string.length());
    }

    private void adjustUploadDirectoryAndCopyFiles() {
        if (this.originalProjectName == null) {
            this.originalProjectName = this.getProjectName();
            return;
        }
        String string = this.getProjectName();
        if (string.equals(this.originalProjectName)) {
            return;
        }
        this.adjustUploadDirectory(this.originalProjectName, string);
        this.adjustCopyFiles(this.originalProjectName, string);
        this.originalProjectName = string;
    }

    private String getProjectName() {
        return (String)this.descriptor.getProperty("projectName");
    }

    private void adjustUploadDirectory(String string, String string2) {
        String string3 = this.runAsRemoteWeb.getUploadDirectory();
        if (!string3.equals("/" + string)) {
            return;
        }
        this.runAsRemoteWeb.setUploadDirectory("/" + string2);
    }

    private void adjustCopyFiles(String string, String string2) {
        LocalServer.ComboBoxModel comboBoxModel = (LocalServer.ComboBoxModel)this.runAsLocalWeb.getLocalServerModel();
        boolean bl = false;
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            LocalServer localServer = comboBoxModel.getElementAt(i);
            File file = new File(localServer.getSrcRoot());
            if (!string.equals(file.getName())) continue;
            File file2 = new File(file.getParentFile(), string2);
            localServer.setSrcRoot(file2.getAbsolutePath());
            bl = true;
        }
        if (bl) {
            comboBoxModel.fireContentsChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.getRunAsType()) {
            case LOCAL: {
                this.adjustUrl();
                this.adjustUploadDirectoryAndCopyFiles();
                break;
            }
            case REMOTE: {
                this.adjustUploadDirectoryAndCopyFiles();
            }
        }
        this.fireChangeEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WizardConfigProvider
    implements ConfigManager.ConfigProvider {
        final Map<String, Map<String, String>> configs = ConfigManager.createEmptyConfigs();

        public WizardConfigProvider() {
            this.configs.put(null, new HashMap());
        }

        @Override
        public String[] getConfigProperties() {
            return CFG_PROPS;
        }

        @Override
        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }

        @Override
        public String getActiveConfig() {
            return null;
        }

        @Override
        public void setActiveConfig(String string) {
        }
    }
}

