/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.data.query.NumberRangeModel;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;

public class AxisLayout
extends Layout {
    private String m_field;
    private int m_scale = 0;
    private int m_axis = 0;
    private int m_type = -1;
    private boolean m_modelSet = false;
    private ValuedRangeModel m_model = null;
    private Predicate m_filter = null;
    private double m_min;
    private double m_range;
    private double[] m_dist = new double[2];

    public AxisLayout(String group, String field) {
        super(group);
        this.m_field = field;
    }

    public AxisLayout(String group, String field, int axis) {
        this(group, field);
        this.setAxis(axis);
    }

    public AxisLayout(String group, String field, int axis, Predicate filter) {
        this(group, field, axis);
        this.setFilter(filter);
    }

    public void setRangeModel(ValuedRangeModel model) {
        this.m_model = model;
        this.m_modelSet = model != null;
    }

    public ValuedRangeModel getRangeModel() {
        return this.m_model;
    }

    public void setFilter(Predicate filter) {
        this.m_filter = filter;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int scale) {
        if (scale < 0 || scale >= 4) {
            throw new IllegalArgumentException("Unrecognized scale value: " + scale);
        }
        this.m_scale = scale;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void setAxis(int axis) {
        if (axis < 0 || axis >= 2) {
            throw new IllegalArgumentException("Unrecognized axis value: " + axis);
        }
        this.m_axis = axis;
    }

    public int getDataType() {
        return this.m_type;
    }

    public void setDataType(int type) {
        if (type < 0 || type >= 3) {
            throw new IllegalArgumentException("Unrecognized data type value: " + type);
        }
        this.m_type = type;
    }

    public void run(double frac) {
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        this.setMinMax();
        switch (this.getDataType(ts)) {
            case 2: {
                this.numericalLayout(ts);
                break;
            }
            default: {
                this.ordinalLayout(ts);
            }
        }
    }

    protected int getDataType(TupleSet ts) {
        if (this.m_type == -1) {
            boolean numbers = true;
            if (ts instanceof Table) {
                numbers = ((Table)ts).canGetDouble(this.m_field);
            } else {
                Iterator it = ts.tuples();
                while (it.hasNext()) {
                    if (((Tuple)it.next()).canGetDouble(this.m_field)) continue;
                    numbers = false;
                    break;
                }
            }
            if (numbers) {
                return 2;
            }
            return 1;
        }
        return this.m_type;
    }

    private void setMinMax() {
        Rectangle2D b = this.getLayoutBounds();
        if (this.m_axis == 0) {
            this.m_min = b.getMinX();
            this.m_range = b.getMaxX() - this.m_min;
        } else {
            this.m_min = b.getMaxY();
            this.m_range = b.getMinY() - this.m_min;
        }
    }

    protected void set(VisualItem item, double frac) {
        double xOrY = this.m_min + frac * this.m_range;
        if (this.m_axis == 0) {
            this.setX(item, null, xOrY);
        } else {
            this.setY(item, null, xOrY);
        }
    }

    protected void numericalLayout(TupleSet ts) {
        if (!this.m_modelSet) {
            this.m_dist[0] = DataLib.min(ts, this.m_field).getDouble(this.m_field);
            this.m_dist[1] = DataLib.max(ts, this.m_field).getDouble(this.m_field);
            double lo = this.m_dist[0];
            double hi = this.m_dist[1];
            if (this.m_model == null) {
                this.m_model = new NumberRangeModel(lo, hi, lo, hi);
            } else {
                ((NumberRangeModel)this.m_model).setValueRange(lo, hi, lo, hi);
            }
        } else {
            this.m_dist[0] = ((Number)this.m_model.getLowValue()).doubleValue();
            this.m_dist[1] = ((Number)this.m_model.getHighValue()).doubleValue();
        }
        Iterator iter = this.m_vis.items(this.m_group, this.m_filter);
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            double v = item.getDouble(this.m_field);
            double f = MathLib.interp(this.m_scale, v, this.m_dist);
            this.set(item, f);
        }
    }

    protected void ordinalLayout(TupleSet ts) {
        if (!this.m_modelSet) {
            Object[] array = DataLib.ordinalArray(ts, this.m_field);
            if (this.m_model == null) {
                this.m_model = new ObjectRangeModel(array);
            } else {
                ((ObjectRangeModel)this.m_model).setValueRange(array);
            }
        }
        ObjectRangeModel model = (ObjectRangeModel)this.m_model;
        int start = model.getValue();
        int end = start + model.getExtent();
        double total = end - start;
        Iterator iter = this.m_vis.items(this.m_group, this.m_filter);
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            int order = model.getIndex(item.get(this.m_field)) - start;
            this.set(item, (double)order / total);
        }
    }
}

