/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.UndefinedMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected RubyModule protectedClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;

    protected DynamicMethod(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration) {
        assert (rubyModule != null);
        this.init(rubyModule, visibility, callConfiguration);
    }

    protected DynamicMethod() {
    }

    protected void init(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration) {
        this.visibility = visibility;
        this.implementationClass = rubyModule;
        this.protectedClass = DynamicMethod.calculateProtectedClass(rubyModule);
        this.callConfig = callConfiguration;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObject2, iRubyObject3, iRubyObject4, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
        return this.call(threadContext, iRubyObject, rubyModule, string, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, block);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, block);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject iRubyObject, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                return this.protectedAccessOk(iRubyObject);
            }
        }
        return true;
    }

    private boolean protectedAccessOk(IRubyObject iRubyObject) {
        return this.getProtectedClass().isInstance(iRubyObject);
    }

    protected static RubyModule calculateProtectedClass(RubyModule rubyModule) {
        if (rubyModule.isSingleton()) {
            rubyModule = rubyModule.getSuperClass();
        }
        while (rubyModule.isIncluded()) {
            rubyModule = rubyModule.getMetaClass();
        }
        if (rubyModule instanceof MetaClass) {
            rubyModule = ((MetaClass)rubyModule).getRealClass();
        }
        return rubyModule;
    }

    protected RubyModule getProtectedClass() {
        return this.protectedClass;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule rubyModule) {
        this.implementationClass = rubyModule;
        this.protectedClass = DynamicMethod.calculateProtectedClass(rubyModule);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public final boolean isUndefined() {
        return this instanceof UndefinedMethod;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfiguration) {
        this.callConfig = callConfiguration;
    }

    public boolean isNative() {
        return false;
    }

    protected IRubyObject handleRedo(Ruby ruby) throws RaiseException {
        throw ruby.newLocalJumpError("redo", ruby.getNil(), "unexpected redo");
    }

    protected IRubyObject handleReturn(ThreadContext threadContext, JumpException.ReturnJump returnJump) {
        if (returnJump.getTarget() == threadContext.getFrameJumpTarget()) {
            return (IRubyObject)returnJump.getValue();
        }
        throw returnJump;
    }
}

