/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyException;
import org.jruby.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.exceptions.MainExitException;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.exceptions.ThreadKill;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.SafePropertyAccessor;
import org.jruby.nb.nb.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig rubyInstanceConfig) {
        this.config = rubyInstanceConfig;
    }

    public Main(final InputStream inputStream, final PrintStream printStream, final PrintStream printStream2) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(inputStream);
                this.setOutput(printStream);
                this.setError(printStream2);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        try {
            int n = main.run(stringArray);
            if (n != 0) {
                System.exit(n);
            }
        }
        catch (RaiseException raiseException) {
            throw raiseException;
        }
        catch (Throwable throwable) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(throwable));
            System.exit(1);
        }
    }

    public int run(String[] stringArray) {
        try {
            this.config.processArguments(stringArray);
            return this.run();
        }
        catch (MainExitException mainExitException) {
            if (!mainExitException.isAborted()) {
                this.config.getOutput().println(mainExitException.getMessage());
                if (mainExitException.isUsageError()) {
                    this.printUsage();
                }
            }
            return mainExitException.getStatus();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            String string = SafePropertyAccessor.getProperty("jruby.memory.max");
            String string2 = "";
            if (string != null) {
                string2 = " of " + string;
            }
            System.err.println("Error: Your application used more memory than the safety cap" + string2 + ".");
            System.err.println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
            if (this.config.getVerbose().booleanValue()) {
                System.err.println("Exception trace follows:");
                outOfMemoryError.printStackTrace();
            } else {
                System.err.println("Specify -w for full OutOfMemoryError stack trace");
            }
            return 1;
        }
        catch (StackOverflowError stackOverflowError) {
            System.gc();
            String string = SafePropertyAccessor.getProperty("jruby.stack.max");
            String string3 = "";
            if (string != null) {
                string3 = " of " + string;
            }
            System.err.println("Error: Your application used more stack memory than the safety cap" + string3 + ".");
            System.err.println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
            if (this.config.getVerbose().booleanValue()) {
                System.err.println("Exception trace follows:");
                stackOverflowError.printStackTrace();
            } else {
                System.err.println("Specify -w for full StackOverflowError stack trace");
            }
            return 1;
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            System.err.println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
            System.err.println("Please use libraries built with the version you intend to use or an earlier one.");
            if (this.config.getVerbose().booleanValue()) {
                System.err.println("Exception trace follows:");
                unsupportedClassVersionError.printStackTrace();
            } else {
                System.err.println("Specify -w for full UnsupportedClassVersionError stack trace");
            }
            return 1;
        }
        catch (ThreadKill threadKill) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int run() {
        Ruby ruby;
        String string;
        InputStream inputStream;
        block17: {
            if (this.config.isShowVersion()) {
                this.showVersion();
            }
            if (this.config.isShowCopyright()) {
                this.showCopyright();
            }
            if (!this.config.shouldRunInterpreter()) {
                if (this.config.shouldPrintUsage()) {
                    this.printUsage();
                }
                if (!this.config.shouldPrintProperties()) return 0;
                this.printProperties();
                return 0;
            }
            inputStream = this.config.getScriptSource();
            string = this.config.displayedFileName();
            ruby = Ruby.newInstance(this.config);
            try {
                Thread.currentThread().setContextClassLoader(ruby.getJRubyClassLoader());
            }
            catch (SecurityException securityException) {
                if (!ruby.getInstanceConfig().isVerbose()) break block17;
                System.err.println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
            }
        }
        if (inputStream == null) return 0;
        if (this.config.isShouldCheckSyntax()) {
            ruby.parseFromMain(inputStream, string);
            this.config.getOutput().println("Syntax OK");
            return 0;
        }
        long l = -1L;
        try {
            if (this.config.isBenchmarking()) {
                l = System.currentTimeMillis();
            }
            if (this.config.isSamplingEnabled()) {
                SimpleSampler.startSampleThread();
            }
            try {
                ruby.runFromMain(inputStream, string);
                Object var7_6 = null;
                ruby.tearDown();
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - l) + " ms");
                }
                if (!this.config.isSamplingEnabled()) return 0;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ruby.tearDown();
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - l) + " ms");
                }
                if (!this.config.isSamplingEnabled()) throw throwable;
                SimpleSampler.report();
                throw throwable;
            }
            SimpleSampler.report();
            return 0;
        }
        catch (RaiseException raiseException) {
            RubyException rubyException = raiseException.getException();
            if (ruby.getSystemExit().isInstance(rubyException)) {
                IRubyObject iRubyObject = rubyException.callMethod(ruby.getCurrentContext(), "status");
                if (iRubyObject == null || iRubyObject.isNil()) return 0;
                return RubyNumeric.fix2int(iRubyObject);
            }
            ruby.printError(rubyException);
            return 1;
        }
    }

    private void showVersion() {
        this.config.getOutput().print(this.config.getVersionString());
    }

    private void showCopyright() {
        this.config.getOutput().print(this.config.getCopyrightString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }
}

