/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.RubyBoolean;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    public static RubyModule createComparable(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Comparable");
        ruby.setComparable(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyComparable.class);
        return rubyModule;
    }

    public static int cmpint(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (iRubyObject.isNil()) {
            RubyComparable.cmperr(iRubyObject2, iRubyObject3);
        }
        if (iRubyObject instanceof RubyFixnum) {
            return RubyNumeric.fix2int((RubyFixnum)iRubyObject);
        }
        if (iRubyObject instanceof RubyBignum) {
            return ((RubyBignum)iRubyObject).getValue().signum() == -1 ? 1 : -1;
        }
        RubyFixnum rubyFixnum = RubyFixnum.zero(threadContext.getRuntime());
        if (iRubyObject.callMethod(threadContext, MethodIndex.OP_GT, ">", rubyFixnum).isTrue()) {
            return 1;
        }
        if (iRubyObject.callMethod(threadContext, MethodIndex.OP_LT, "<", rubyFixnum).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static IRubyObject cmperr(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject2.isImmediate() || !iRubyObject2.isNil() && !iRubyObject2.isTrue() && iRubyObject2 != iRubyObject.getRuntime().getFalse() ? iRubyObject2.inspect() : iRubyObject2.getType();
        throw iRubyObject.getRuntime().newArgumentError("comparison of " + iRubyObject.getType() + " with " + iRubyObject3 + " failed");
    }

    @JRubyMethod(name={"=="}, required=1)
    public static IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject == iRubyObject2) {
            return ruby.getTrue();
        }
        try {
            IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
            return RubyBoolean.newBoolean(ruby, RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) == 0);
        }
        catch (RaiseException raiseException) {
            if (raiseException.getException().kind_of_p(threadContext, ruby.getStandardError()).isTrue()) {
                return ruby.getNil();
            }
            throw raiseException;
        }
    }

    @JRubyMethod(name={">"}, required=1)
    public static RubyBoolean op_gt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(threadContext.getRuntime(), RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) > 0);
    }

    @JRubyMethod(name={">="}, required=1)
    public static RubyBoolean op_ge(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(threadContext.getRuntime(), RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) >= 0);
    }

    @JRubyMethod(name={"<"}, required=1)
    public static RubyBoolean op_lt(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(threadContext.getRuntime(), RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) < 0);
    }

    @JRubyMethod(name={"<="}, required=1)
    public static RubyBoolean op_le(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject2);
        if (iRubyObject3.isNil()) {
            RubyComparable.cmperr(iRubyObject, iRubyObject2);
        }
        return RubyBoolean.newBoolean(threadContext.getRuntime(), RubyComparable.cmpint(threadContext, iRubyObject3, iRubyObject, iRubyObject2) <= 0);
    }

    @JRubyMethod(name={"between?"}, required=2)
    public static RubyBoolean between_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return threadContext.getRuntime().newBoolean(RubyComparable.op_lt(threadContext, iRubyObject, iRubyObject2).isFalse() && RubyComparable.op_gt(threadContext, iRubyObject, iRubyObject3).isFalse());
    }
}

